/*
 * Decompiled with CFR 0.152.
 */
package com.opendaylight.persistence.dao;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.persistence.util.common.type.Sort;

public final class SearchCase<T, F, S> {
    private List<T> searchSpace;
    private F filter;
    private List<Sort<S>> sort;
    private List<T> expectedResult;

    private SearchCase(@Nonnull List<T> searchSpace, @Nonnull F filter, @Nullable List<Sort<S>> sort, @Nonnull List<T> expectedResult) {
        this.searchSpace = new ArrayList<T>(searchSpace);
        this.filter = filter;
        this.sort = sort;
        this.expectedResult = expectedResult != null ? Collections.unmodifiableList(new ArrayList<T>(expectedResult)) : Collections.emptyList();
    }

    public static <T, F, S> SearchCase<T, F, S> forCase(@Nonnull List<T> searchSpace, @Nonnull F filter, @Nullable List<Sort<S>> sort, @Nonnull List<T> expectedResult) {
        return new SearchCase<T, F, S>(searchSpace, filter, sort, expectedResult);
    }

    @SafeVarargs
    public static <T, F, S> SearchCase<T, F, S> forCase(@Nonnull List<T> searchSpace, @Nonnull F filter, @Nullable List<Sort<S>> sort, T ... expectedResult) {
        return SearchCase.forCase(searchSpace, filter, sort, Arrays.asList(expectedResult));
    }

    public List<T> getSearchSpace() {
        return this.searchSpace;
    }

    public F getFilter() {
        return this.filter;
    }

    public List<Sort<S>> getSort() {
        return this.sort;
    }

    public List<T> getExpectedResult() {
        return this.expectedResult;
    }

    public boolean isOrdered() {
        return this.sort != null && !this.sort.isEmpty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", this.filter).add("sort", this.sort).add("expectedResult", this.expectedResult).add("searchSpace", this.searchSpace).toString();
    }
}

