/*
 * Decompiled with CFR 0.152.
 */
package com.opendaylight.persistence.dao;

import com.opendaylight.persistence.dao.AbstractBaseDaoTest;
import com.opendaylight.persistence.dao.AbstractDaoTest;
import com.opendaylight.persistence.dao.SearchCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.opendaylight.persistence.DataStore;
import org.opendaylight.persistence.PersistenceException;
import org.opendaylight.persistence.dao.OffsetPageDao;
import org.opendaylight.persistence.util.common.type.page.OffsetPage;
import org.opendaylight.persistence.util.common.type.page.OffsetPageRequest;
import org.opendaylight.persistence.util.common.type.page.PageRequest;
import org.opendaylight.yangtools.concepts.Identifiable;

public abstract class AbstractOffsetPageDaoTest<I extends Serializable, T extends Identifiable<I>, F, S, C, D extends OffsetPageDao<I, T, F, S, C>>
extends AbstractDaoTest<I, T, F, S, C, D> {
    public AbstractOffsetPageDaoTest(@Nonnull DataStore<C> dataStore) {
        super(dataStore);
    }

    @Test
    public void testPagedFind() throws PersistenceException {
        List searchCases = this.getSearchCases();
        Assume.assumeNotNull((Object[])new Object[]{searchCases});
        for (final SearchCase searchCase : searchCases) {
            Map persistedSearchSpace = this.store(searchCase.getSearchSpace());
            int totalRecords = searchCase.getExpectedResult().size();
            for (int limit = 1; limit <= totalRecords; ++limit) {
                int totalPages = totalRecords / limit;
                if (totalPages * limit < totalRecords) {
                    ++totalPages;
                }
                ArrayList aggregatedResult = new ArrayList(totalRecords);
                for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                    long offset = pageIndex * limit;
                    final OffsetPageRequest pageRequest = new OffsetPageRequest(offset, limit);
                    OffsetPage resultPage = (OffsetPage)this.execute(new AbstractBaseDaoTest.DaoQuery<OffsetPage<T>>(){

                        @Override
                        protected OffsetPage<T> execute(D dao, C context) throws PersistenceException {
                            return (OffsetPage)dao.find(searchCase.getFilter(), searchCase.getSort(), (PageRequest)pageRequest, context);
                        }
                    });
                    Assert.assertEquals((String)AbstractOffsetPageDaoTest.getMessage(searchCase), (long)totalPages, (long)resultPage.getTotalPageCount());
                    Assert.assertEquals((String)AbstractOffsetPageDaoTest.getMessage(searchCase), (long)totalRecords, (long)resultPage.getTotalRecordCount());
                    if (pageIndex < totalPages - 1) {
                        Assert.assertEquals((String)AbstractOffsetPageDaoTest.getMessage(searchCase), (long)limit, (long)resultPage.getData().size());
                    } else {
                        Assert.assertEquals((String)AbstractOffsetPageDaoTest.getMessage(searchCase), (long)(totalRecords - pageIndex * limit), (long)resultPage.getData().size());
                    }
                    aggregatedResult.addAll(resultPage.getData());
                }
                this.assertSearch(searchCase.getExpectedResult(), aggregatedResult, persistedSearchSpace, searchCase.isOrdered(), AbstractOffsetPageDaoTest.getMessage(searchCase));
            }
            this.clear();
        }
    }
}

