/*
 * Decompiled with CFR 0.152.
 */
package com.opendaylight.persistence.dao;

import com.opendaylight.persistence.dao.AbstractBaseDaoTest;
import com.opendaylight.persistence.dao.AbstractDaoTest;
import com.opendaylight.persistence.dao.SearchCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.junit.Assume;
import org.junit.Test;
import org.opendaylight.persistence.DataStore;
import org.opendaylight.persistence.PersistenceException;
import org.opendaylight.persistence.dao.MarkPageDao;
import org.opendaylight.persistence.util.common.type.page.MarkPage;
import org.opendaylight.persistence.util.common.type.page.MarkPageRequest;
import org.opendaylight.persistence.util.common.type.page.PageRequest;
import org.opendaylight.persistence.util.common.type.tuple.UnaryTuple;
import org.opendaylight.yangtools.concepts.Identifiable;

public abstract class AbstractMarkPageDaoTest<I extends Serializable, T extends Identifiable<I>, F, S, C, D extends MarkPageDao<I, T, F, S, C>>
extends AbstractDaoTest<I, T, F, S, C, D> {
    public AbstractMarkPageDaoTest(@Nonnull DataStore<C> dataStore) {
        super(dataStore);
    }

    @Test
    public void testPagedFind() throws PersistenceException {
        List searchCases = this.getSearchCases();
        Assume.assumeNotNull((Object[])new Object[]{searchCases});
        for (final SearchCase searchCase : searchCases) {
            Map persistedSearchSpace = this.store(searchCase.getSearchSpace());
            int totalRecords = searchCase.getExpectedResult().size();
            for (int size = 1; size <= totalRecords; ++size) {
                int totalPages = totalRecords / size;
                if (totalPages * size < totalRecords) {
                    ++totalPages;
                }
                ArrayList aggregatedResult = new ArrayList(totalRecords);
                MarkPage page = null;
                final UnaryTuple pageRequest = UnaryTuple.valueOf((Object)new MarkPageRequest(size));
                do {
                    page = (MarkPage)this.execute(new AbstractBaseDaoTest.DaoQuery<MarkPage<T>>(){

                        @Override
                        protected MarkPage<T> execute(D dao, C context) throws PersistenceException {
                            return (MarkPage)dao.find(searchCase.getFilter(), searchCase.getSort(), (PageRequest)pageRequest.getFirst(), context);
                        }
                    });
                    aggregatedResult.addAll(page.getData());
                    pageRequest.setFirst((Object)page.getNextPageRequest());
                } while (!page.getData().isEmpty());
                this.assertSearch(searchCase.getExpectedResult(), aggregatedResult, persistedSearchSpace, searchCase.isOrdered(), AbstractMarkPageDaoTest.getMessage(searchCase));
            }
            this.clear();
        }
    }
}

