/*
 * Decompiled with CFR 0.152.
 */
package com.opendaylight.persistence.dao;

import com.opendaylight.persistence.dao.AbstractBaseDaoTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.persistence.DataStore;
import org.opendaylight.persistence.PersistenceException;
import org.opendaylight.persistence.dao.KeyValueDao;
import org.opendaylight.yangtools.concepts.Identifiable;

public abstract class AbstractKeyValueDaoTest<I extends Serializable, T extends Identifiable<I>, C, D extends KeyValueDao<I, T, C>>
extends AbstractBaseDaoTest<I, T, C, D> {
    public AbstractKeyValueDaoTest(@Nonnull DataStore<C> dataStore) {
        super(dataStore);
    }

    @Test
    public void testGetAll() throws PersistenceException {
        List expected = this.createIdentifiables(5);
        Map searchSpace = this.store(expected);
        Assert.assertEquals((long)expected.size(), (long)this.size());
        Collection actual = (Collection)this.execute(new AbstractBaseDaoTest.DaoQuery<Collection<T>>(){

            @Override
            protected Collection<T> execute(D dao, C context) throws PersistenceException {
                return dao.getAll(context);
            }
        });
        this.assertSearch(expected, new ArrayList(actual), searchSpace, false, null);
    }

    @Test
    public void testSize() throws PersistenceException {
        List expected = this.createIdentifiables(5);
        this.store(expected);
        Assert.assertEquals((long)expected.size(), (long)this.size());
    }

    @Test
    public void testClear() throws PersistenceException {
        List expected = this.createIdentifiables(5);
        this.store(expected);
        Assert.assertEquals((long)expected.size(), (long)this.size());
        this.clear();
        Assert.assertEquals((long)0L, (long)this.size());
    }

    @Override
    protected void clear() throws PersistenceException {
        this.execute(new AbstractBaseDaoTest.DaoQuery<Void>(){

            @Override
            protected Void execute(D dao, C context) throws PersistenceException {
                dao.clear(context);
                return null;
            }
        });
        Assert.assertEquals((long)0L, (long)this.size());
    }

    @Override
    protected long size() throws PersistenceException {
        return (Long)this.execute(new AbstractBaseDaoTest.DaoQuery<Long>(){

            @Override
            protected Long execute(D dao, C context) throws PersistenceException {
                return dao.size(context);
            }
        });
    }
}

