/*
 * Decompiled with CFR 0.152.
 */
package com.opendaylight.persistence.dao;

import com.opendaylight.persistence.dao.AbstractBaseDaoTest;
import com.opendaylight.persistence.dao.AbstractKeyValueDaoTest;
import com.opendaylight.persistence.dao.SearchCase;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.opendaylight.persistence.DataStore;
import org.opendaylight.persistence.PersistenceException;
import org.opendaylight.persistence.dao.Dao;
import org.opendaylight.yangtools.concepts.Identifiable;

public abstract class AbstractDaoTest<I extends Serializable, T extends Identifiable<I>, F, S, C, D extends Dao<I, T, F, S, C>>
extends AbstractKeyValueDaoTest<I, T, C, D> {
    public AbstractDaoTest(@Nonnull DataStore<C> dataStore) {
        super(dataStore);
    }

    @Test
    public void testFind() throws PersistenceException {
        List<SearchCase<T, F, S>> searchCases = this.getSearchCases();
        Assume.assumeNotNull((Object[])new Object[]{searchCases});
        for (final SearchCase<T, F, S> searchCase : searchCases) {
            Map persistedSearchSpace = this.store(searchCase.getSearchSpace());
            List searchResult = (List)this.execute(new AbstractBaseDaoTest.DaoQuery<List<T>>(){

                @Override
                protected List<T> execute(D dao, C context) throws PersistenceException {
                    return dao.find(searchCase.getFilter(), searchCase.getSort(), context);
                }
            });
            this.assertSearch(searchCase.getExpectedResult(), searchResult, persistedSearchSpace, searchCase.isOrdered(), AbstractDaoTest.getMessage(searchCase));
            this.clear();
        }
    }

    @Test
    public void testCount() throws PersistenceException {
        List<SearchCase<T, F, S>> searchCases = this.getSearchCases();
        Assume.assumeNotNull((Object[])new Object[]{searchCases});
        for (final SearchCase<T, F, S> searchCase : searchCases) {
            this.store(searchCase.getSearchSpace());
            Long count = (Long)this.execute(new AbstractBaseDaoTest.DaoQuery<Long>(){

                @Override
                protected Long execute(D dao, C context) throws PersistenceException {
                    return dao.count(searchCase.getFilter(), context);
                }
            });
            Assert.assertEquals((String)AbstractDaoTest.getMessage(searchCase), (long)searchCase.getExpectedResult().size(), (long)count);
            this.clear();
        }
    }

    @Test
    public void testDelete() throws PersistenceException {
        List<SearchCase<T, F, S>> searchCases = this.getSearchCases();
        Assume.assumeNotNull((Object[])new Object[]{searchCases});
        for (final SearchCase<T, F, S> searchCase : searchCases) {
            Map persistedSearchSpace = this.store(searchCase.getSearchSpace());
            this.execute(new AbstractBaseDaoTest.DaoQuery<Void>(){

                @Override
                protected Void execute(D dao, C context) throws PersistenceException {
                    dao.delete(searchCase.getFilter(), context);
                    return null;
                }
            });
            List remaining = (List)this.execute(new AbstractBaseDaoTest.DaoQuery<List<T>>(){

                @Override
                protected List<T> execute(D dao, C context) throws PersistenceException {
                    return dao.find(null, null, context);
                }
            });
            Assert.assertEquals((String)AbstractDaoTest.getMessage(searchCase), (long)(searchCase.getSearchSpace().size() - searchCase.getExpectedResult().size()), (long)remaining.size());
            for (Identifiable remained : remaining) {
                Identifiable remainedOriginal = (Identifiable)persistedSearchSpace.get(remained.getIdentifier()).getOriginal();
                boolean foundInExpectedResult = false;
                for (Identifiable identifiable : searchCase.getExpectedResult()) {
                    if (remainedOriginal != identifiable) continue;
                    foundInExpectedResult = true;
                    break;
                }
                Assert.assertFalse((String)AbstractDaoTest.getMessage(searchCase), (boolean)foundInExpectedResult);
            }
            this.clear();
        }
    }

    protected static String getMessage(@Nonnull SearchCase<?, ?, ?> searchCase) {
        return searchCase.toString();
    }

    protected abstract List<SearchCase<T, F, S>> getSearchCases();
}

