/*
 * Decompiled with CFR 0.152.
 */
package com.opendaylight.persistence.dao;

import com.opendaylight.persistence.dao.StoredObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.persistence.DataStore;
import org.opendaylight.persistence.IntegrityConstraintViolationException;
import org.opendaylight.persistence.PersistenceException;
import org.opendaylight.persistence.Query;
import org.opendaylight.persistence.dao.BaseDao;
import org.opendaylight.persistence.util.test.ThrowableTester;
import org.opendaylight.yangtools.concepts.Identifiable;

public abstract class AbstractBaseDaoTest<I extends Serializable, T extends Identifiable<I>, C, D extends BaseDao<I, T, C>> {
    private DataStore<C> dataStore;

    public AbstractBaseDaoTest(@Nonnull DataStore<C> dataStore) {
        this.dataStore = dataStore;
    }

    @Before
    public void beforeTest() throws PersistenceException {
        this.clear();
    }

    @Test
    public void testAdd() throws PersistenceException {
        final Identifiable original = (Identifiable)this.createIdentifiables(1).get(0);
        Identifiable stored = (Identifiable)this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.add(original, context);
            }
        });
        Assert.assertNotNull((Object)stored);
        Assert.assertNotNull((Object)stored.getIdentifier());
        this.assertEqualState(original, stored);
        Assert.assertEquals((long)1L, (long)this.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddInvalid() throws PersistenceException {
        final Identifiable invalidIdentifiable = null;
        this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.add(invalidIdentifiable, context);
            }
        });
    }

    @Test
    public void testPrimaryKeyIntegrityConstraintViolation() throws PersistenceException {
        Assume.assumeTrue((boolean)this.isPrimaryKeyIntegrityConstraintViolationTestSuitable());
        List<T> identifiables = this.createIdentifiables(1);
        Identifiable original = (Identifiable)identifiables.get(0);
        Identifiable stored = this.store(original);
        T duplicated = this.createIdentifiable((Serializable)stored.getIdentifier());
        ThrowableTester.Instruction violationExecutor = new ThrowableTester.Instruction((Identifiable)duplicated){
            final /* synthetic */ Identifiable val$duplicated;
            {
                this.val$duplicated = identifiable;
            }

            public void execute() throws Throwable {
                AbstractBaseDaoTest.this.execute(new DaoQuery<T>(){

                    @Override
                    protected T execute(D dao, C context) throws PersistenceException {
                        return dao.add(val$duplicated, context);
                    }
                });
            }
        };
        ThrowableTester.testThrows(IntegrityConstraintViolationException.class, (ThrowableTester.Instruction)violationExecutor);
    }

    @Test
    public void testUpdate() throws PersistenceException {
        final Identifiable identifiable = (Identifiable)this.createIdentifiables(1).get(0);
        final Identifiable expected = (Identifiable)this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.add(identifiable, context);
            }
        });
        this.modify(expected);
        Identifiable updated = (Identifiable)this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.update(expected, context);
            }
        });
        this.assertEqualState(expected, updated);
        Identifiable loadedUpdated = (Identifiable)this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.get((Serializable)expected.getIdentifier(), context);
            }
        });
        this.assertEqualState(expected, loadedUpdated);
    }

    @Test
    public void testUpdateNotFound() throws PersistenceException {
        Identifiable original;
        Assume.assumeTrue((boolean)this.isNotFoundExceptionOnUpdateSuitable());
        final Identifiable identifiable = (Identifiable)this.createIdentifiables(1).get(0);
        final Identifiable nonexistent = original = (Identifiable)this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.add(identifiable, context);
            }
        });
        this.execute(new DaoQuery<Void>(){

            @Override
            protected Void execute(D dao, C context) throws PersistenceException {
                dao.delete((Serializable)original.getIdentifier(), context);
                return null;
            }
        });
        ThrowableTester.testThrows(PersistenceException.class, (ThrowableTester.Instruction)new ThrowableTester.Instruction(){

            public void execute() throws Throwable {
                AbstractBaseDaoTest.this.execute(new DaoQuery<Void>(){

                    @Override
                    protected Void execute(D dao, C context) throws PersistenceException {
                        dao.update(nonexistent, context);
                        return null;
                    }
                });
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpdateInvalid() throws PersistenceException {
        final Identifiable invalidIdentifiable = null;
        this.execute(new DaoQuery<Void>(){

            @Override
            protected Void execute(D dao, C context) throws PersistenceException {
                dao.update(invalidIdentifiable, context);
                return null;
            }
        });
    }

    @Test
    public void testUpdateWithVersionConflict() throws PersistenceException {
        Assume.assumeTrue((boolean)this.isVersioned());
        final Identifiable old = this.store((Identifiable)this.createIdentifiables(1).get(0));
        final Identifiable latest = (Identifiable)this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.get((Serializable)old.getIdentifier(), context);
            }
        });
        this.modify(latest);
        this.execute(new DaoQuery<Void>(){

            @Override
            protected Void execute(D dao, C context) throws PersistenceException {
                dao.update(latest, context);
                return null;
            }
        });
        this.modify(old);
        ThrowableTester.testThrows(IllegalStateException.class, (ThrowableTester.Instruction)new ThrowableTester.Instruction(){

            public void execute() throws Throwable {
                AbstractBaseDaoTest.this.execute(new DaoQuery<Void>(){

                    @Override
                    protected Void execute(D dao, C context) throws PersistenceException {
                        dao.update(old, context);
                        return null;
                    }
                });
            }
        });
    }

    @Test
    public void testDeleteWithId() throws PersistenceException {
        Identifiable identifiable = (Identifiable)this.createIdentifiables(1).get(0);
        final Serializable id = (Serializable)this.store(identifiable).getIdentifier();
        Assert.assertEquals((long)1L, (long)this.size());
        this.execute(new DaoQuery<Void>(){

            @Override
            protected Void execute(D dao, C context) throws PersistenceException {
                dao.delete(id, context);
                return null;
            }
        });
        Assert.assertEquals((long)0L, (long)this.size());
    }

    @Test
    public void testDeleteWithIdInvalid() throws PersistenceException {
        final Serializable invalidId = null;
        this.execute(new DaoQuery<Void>(){

            @Override
            protected Void execute(D dao, C context) throws PersistenceException {
                dao.delete(invalidId, context);
                return null;
            }
        });
    }

    @Test
    public void testGet() throws PersistenceException {
        Identifiable identifiable = (Identifiable)this.createIdentifiables(1).get(0);
        final Identifiable original = this.store(identifiable);
        Identifiable retrieved = (Identifiable)this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.get((Serializable)original.getIdentifier(), context);
            }
        });
        this.assertEqualState(original, retrieved);
    }

    @Test
    public void testGetInvalid() throws PersistenceException {
        final Serializable invalidId = null;
        this.execute(new DaoQuery<T>(){

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.get(invalidId, context);
            }
        });
    }

    @Test
    public void testExist() throws PersistenceException {
        Identifiable identifiable = (Identifiable)this.createIdentifiables(1).get(0);
        final Identifiable stored = this.store(identifiable);
        Boolean exist = (Boolean)this.execute(new DaoQuery<Boolean>(){

            @Override
            protected Boolean execute(D dao, C context) throws PersistenceException {
                return dao.exist((Serializable)stored.getIdentifier(), context);
            }
        });
        Assert.assertTrue((boolean)exist);
    }

    @Test
    public void testExistInvalid() throws PersistenceException {
        final Serializable invalidId = null;
        this.execute(new DaoQuery<Boolean>(){

            @Override
            protected Boolean execute(D dao, C context) throws PersistenceException {
                return dao.exist(invalidId, context);
            }
        });
    }

    protected <R> R execute(@Nonnull Query<R, C> query) throws PersistenceException {
        return (R)this.dataStore.execute(query);
    }

    protected T store(@Nonnull T identifiable) throws PersistenceException {
        return (T)((Identifiable)this.execute(new DaoQuery<T>((Identifiable)identifiable){
            final /* synthetic */ Identifiable val$identifiable;
            {
                this.val$identifiable = identifiable;
            }

            @Override
            protected T execute(D dao, C context) throws PersistenceException {
                return dao.add(this.val$identifiable, context);
            }
        }));
    }

    protected Map<I, StoredObject<T>> store(@Nonnull Collection<T> original) throws PersistenceException {
        HashMap<Object, StoredObject<Identifiable>> persistedObjects = new HashMap<Object, StoredObject<Identifiable>>();
        for (final Identifiable identifiable : original) {
            Identifiable stored = (Identifiable)this.execute(new DaoQuery<T>(){

                @Override
                protected T execute(D dao, C context) throws PersistenceException {
                    return dao.add(identifiable, context);
                }
            });
            persistedObjects.put(stored.getIdentifier(), StoredObject.valueOf(identifiable, stored));
        }
        return persistedObjects;
    }

    protected void assertSearch(@Nonnull List<T> expected, @Nonnull List<T> actual, @Nonnull Map<I, StoredObject<T>> searchSpace, boolean ordered, @Nullable String errorMessage) {
        Assert.assertEquals((String)errorMessage, (long)expected.size(), (long)actual.size());
        if (ordered) {
            for (int i = expected.size() - 1; i >= 0; --i) {
                Identifiable expectedIdentifiable = (Identifiable)expected.get(i);
                Identifiable actualStored = (Identifiable)actual.get(i);
                Identifiable actualOriginal = (Identifiable)searchSpace.get(actualStored.getIdentifier()).getOriginal();
                Assert.assertSame((String)errorMessage, (Object)expectedIdentifiable, (Object)actualOriginal);
            }
        } else {
            for (Identifiable actualStored : actual) {
                Identifiable actualIdentifiable = (Identifiable)searchSpace.get(actualStored.getIdentifier()).getOriginal();
                boolean found = false;
                for (Identifiable identifiable : expected) {
                    if (identifiable != actualIdentifiable) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((String)errorMessage, (boolean)found);
            }
        }
    }

    protected abstract D createDaoInstance();

    protected abstract boolean isPrimaryKeyIntegrityConstraintViolationTestSuitable();

    protected abstract boolean isNotFoundExceptionOnUpdateSuitable();

    protected abstract boolean isVersioned();

    protected abstract void clear() throws PersistenceException;

    protected abstract T createIdentifiable(@Nonnull I var1);

    protected abstract List<T> createIdentifiables(int var1);

    protected abstract void assertEqualState(@Nonnull T var1, @Nonnull T var2);

    protected abstract long size() throws PersistenceException;

    protected abstract void modify(@Nonnull T var1);

    protected abstract class DaoQuery<R>
    implements Query<R, C> {
        protected DaoQuery() {
        }

        public R execute(C context) throws PersistenceException {
            return this.execute(AbstractBaseDaoTest.this.createDaoInstance(), context);
        }

        protected abstract R execute(@Nonnull D var1, @Nonnull C var2) throws PersistenceException;
    }
}

