/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.processors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.TrafficProfileBestEffortAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.TrafficProfileDocsisServiceClassNameAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.TrafficProfileFlowspecAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.traffic.profile.best.effort.attributes.BeAuthorizedEnvelope;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.traffic.profile.best.effort.attributes.BeCommittedEnvelope;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.traffic.profile.best.effort.attributes.BeReservedEnvelope;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.SubscriberIdRpcAddFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.TcpMatchRangesAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.TcpMatchRangesRpcAddFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.UdpMatchRangesAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.UdpMatchRangesRpcAddFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.tcp.match.ranges.attributes.TcpMatchRanges;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.udp.match.ranges.attributes.UpdMatchRanges;
import org.pcmm.gates.IClassifier;
import org.pcmm.gates.IExtendedClassifier;
import org.pcmm.gates.ITrafficProfile;
import org.pcmm.gates.impl.BestEffortService;
import org.pcmm.gates.impl.DOCSISServiceClassNameTrafficProfile;
import org.pcmm.gates.impl.ExtendedClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCMMDataProcessor {
    private Logger logger = LoggerFactory.getLogger(PCMMDataProcessor.class);

    public ITrafficProfile process(TrafficProfileBestEffortAttributes bestEffort) {
        BestEffortService trafficProfile = new BestEffortService(7);
        this.getBEAuthorizedEnvelop(bestEffort, trafficProfile);
        this.getBEReservedEnvelop(bestEffort, trafficProfile);
        this.getBECommittedEnvelop(bestEffort, trafficProfile);
        return trafficProfile;
    }

    public ITrafficProfile process(TrafficProfileDocsisServiceClassNameAttributes docsis) {
        DOCSISServiceClassNameTrafficProfile trafficProfile = new DOCSISServiceClassNameTrafficProfile();
        trafficProfile.setServiceClassName(docsis.getServiceClassName());
        return trafficProfile;
    }

    public ITrafficProfile process(TrafficProfileFlowspecAttributes flowSpec) {
        throw new UnsupportedOperationException("Not impelemnted yet");
    }

    public IClassifier process(Match match) {
        Ipv4Address ipv4Address;
        ExtendedClassifier classifier = new ExtendedClassifier();
        this.getUdpMatchRangeValues((UdpMatchRangesAttributes)match.getAugmentation(UdpMatchRangesRpcAddFlow.class), (IExtendedClassifier)classifier);
        this.getTcpMatchRangesValues((TcpMatchRangesAttributes)match.getAugmentation(TcpMatchRangesRpcAddFlow.class), (IExtendedClassifier)classifier);
        SubscriberIdRpcAddFlow subId = (SubscriberIdRpcAddFlow)match.getAugmentation(SubscriberIdRpcAddFlow.class);
        Ipv6Address ipv6Address = subId.getSubscriberId().getIpv6Address();
        if (ipv6Address != null) {
            try {
                classifier.setDestinationIPAddress(InetAddress.getByName(ipv6Address.getValue()));
            }
            catch (UnknownHostException e) {
                this.logger.error(e.getMessage());
            }
        }
        if ((ipv4Address = subId.getSubscriberId().getIpv4Address()) != null) {
            try {
                classifier.setDestinationIPAddress(InetAddress.getByName(ipv4Address.getValue()));
            }
            catch (UnknownHostException e) {
                this.logger.error(e.getMessage());
            }
        }
        return classifier;
    }

    private void getBECommittedEnvelop(TrafficProfileBestEffortAttributes bestEffort, BestEffortService trafficProfile) {
        BestEffortService.BEEnvelop committedEnvelop = trafficProfile.getCommittedEnvelop();
        BeCommittedEnvelope beCommittedEnvelope = bestEffort.getBeCommittedEnvelope();
        if (beCommittedEnvelope.getTrafficPriority() != null) {
            committedEnvelop.setTrafficPriority(beCommittedEnvelope.getTrafficPriority().byteValue());
        } else {
            committedEnvelop.setTrafficPriority((byte)0);
        }
        if (beCommittedEnvelope.getMaximumTrafficBurst() != null) {
            committedEnvelop.setMaximumTrafficBurst(beCommittedEnvelope.getMaximumTrafficBurst().intValue());
        } else {
            committedEnvelop.setMaximumTrafficBurst(3044);
        }
        if (beCommittedEnvelope.getRequestTransmissionPolicy() != null) {
            committedEnvelop.setRequestTransmissionPolicy(beCommittedEnvelope.getRequestTransmissionPolicy().intValue());
        }
        if (beCommittedEnvelope.getMaximumSustainedTrafficRate() != null) {
            committedEnvelop.setMaximumSustainedTrafficRate(beCommittedEnvelope.getMaximumSustainedTrafficRate().intValue());
        }
    }

    private void getBEReservedEnvelop(TrafficProfileBestEffortAttributes bestEffort, BestEffortService trafficProfile) {
        BestEffortService.BEEnvelop reservedEnvelop = trafficProfile.getReservedEnvelop();
        BeReservedEnvelope beReservedEnvelope = bestEffort.getBeReservedEnvelope();
        if (beReservedEnvelope.getTrafficPriority() != null) {
            reservedEnvelop.setTrafficPriority(beReservedEnvelope.getTrafficPriority().byteValue());
        } else {
            reservedEnvelop.setTrafficPriority((byte)0);
        }
        if (beReservedEnvelope.getMaximumTrafficBurst() != null) {
            reservedEnvelop.setMaximumTrafficBurst(beReservedEnvelope.getMaximumTrafficBurst().intValue());
        } else {
            reservedEnvelop.setMaximumTrafficBurst(3044);
        }
        if (beReservedEnvelope.getRequestTransmissionPolicy() != null) {
            reservedEnvelop.setRequestTransmissionPolicy(beReservedEnvelope.getRequestTransmissionPolicy().intValue());
        }
        if (beReservedEnvelope.getMaximumSustainedTrafficRate() != null) {
            reservedEnvelop.setMaximumSustainedTrafficRate(beReservedEnvelope.getMaximumSustainedTrafficRate().intValue());
        }
    }

    private void getBEAuthorizedEnvelop(TrafficProfileBestEffortAttributes bestEffort, BestEffortService trafficProfile) {
        BestEffortService.BEEnvelop authorizedEnvelop = trafficProfile.getAuthorizedEnvelop();
        BeAuthorizedEnvelope beAuthorizedEnvelope = bestEffort.getBeAuthorizedEnvelope();
        if (beAuthorizedEnvelope.getTrafficPriority() != null) {
            authorizedEnvelop.setTrafficPriority(beAuthorizedEnvelope.getTrafficPriority().byteValue());
        } else {
            authorizedEnvelop.setTrafficPriority((byte)0);
        }
        if (beAuthorizedEnvelope.getMaximumTrafficBurst() != null) {
            authorizedEnvelop.setMaximumTrafficBurst(beAuthorizedEnvelope.getMaximumTrafficBurst().intValue());
        } else {
            authorizedEnvelop.setMaximumTrafficBurst(3044);
        }
        if (beAuthorizedEnvelope.getRequestTransmissionPolicy() != null) {
            authorizedEnvelop.setRequestTransmissionPolicy(beAuthorizedEnvelope.getRequestTransmissionPolicy().intValue());
        }
        if (beAuthorizedEnvelope.getMaximumSustainedTrafficRate() != null) {
            authorizedEnvelop.setMaximumSustainedTrafficRate(beAuthorizedEnvelope.getMaximumSustainedTrafficRate().intValue());
        }
    }

    private void getTcpMatchRangesValues(TcpMatchRangesAttributes tcpRange, IExtendedClassifier classifier) {
        short dstPortEnd = 0;
        short dstPortStart = 0;
        short srcPortEnd = 0;
        short srcPortStart = 0;
        if (tcpRange != null) {
            PortNumber tcpSourcePortEnd;
            PortNumber tcpDestinationPortEnd;
            PortNumber tcpSourcePortStart;
            TcpMatchRanges tcpMatchRanges = tcpRange.getTcpMatchRanges();
            PortNumber tcpDestinationPortStart = tcpMatchRanges.getTcpDestinationPortStart();
            if (tcpDestinationPortStart != null && tcpDestinationPortStart.getValue() != null) {
                dstPortStart = tcpDestinationPortStart.getValue().shortValue();
            }
            if ((tcpSourcePortStart = tcpMatchRanges.getTcpSourcePortStart()) != null && tcpSourcePortStart.getValue() != null) {
                srcPortStart = tcpSourcePortStart.getValue().shortValue();
            }
            if ((tcpDestinationPortEnd = tcpMatchRanges.getTcpDestinationPortEnd()) != null && tcpDestinationPortEnd.getValue() != null) {
                dstPortEnd = tcpDestinationPortEnd.getValue().shortValue();
            }
            if ((tcpSourcePortEnd = tcpMatchRanges.getTcpSourcePortEnd()) != null && tcpSourcePortEnd.getValue() != null) {
                srcPortEnd = tcpSourcePortEnd.getValue().shortValue();
            }
        }
        classifier.setDestinationPortStart(dstPortStart);
        classifier.setSourcePortStart(srcPortStart);
        classifier.setDestinationPortEnd(dstPortEnd);
        classifier.setSourcePortEnd(srcPortEnd);
    }

    private void getUdpMatchRangeValues(UdpMatchRangesAttributes updRange, IExtendedClassifier classifier) {
        short dstPortEnd = 0;
        short dstPortStart = 0;
        short srcPortEnd = 0;
        short srcPortStart = 0;
        if (updRange != null) {
            PortNumber udpSourcePortEnd;
            PortNumber udpDestinationPortEnd;
            PortNumber udpSourcePortStart;
            UpdMatchRanges updMatchRanges = updRange.getUpdMatchRanges();
            PortNumber udpDestinationPortStart = updMatchRanges.getUdpDestinationPortStart();
            if (udpDestinationPortStart != null && udpDestinationPortStart.getValue() != null) {
                dstPortStart = udpDestinationPortStart.getValue().shortValue();
            }
            if ((udpSourcePortStart = updMatchRanges.getUdpSourcePortStart()) != null && udpSourcePortStart.getValue() != null) {
                srcPortStart = udpSourcePortStart.getValue().shortValue();
            }
            if ((udpDestinationPortEnd = updMatchRanges.getUdpDestinationPortEnd()) != null && udpDestinationPortEnd.getValue() != null) {
                dstPortEnd = udpDestinationPortEnd.getValue().shortValue();
            }
            if ((udpSourcePortEnd = updMatchRanges.getUdpSourcePortEnd()) != null && udpSourcePortEnd.getValue() != null) {
                srcPortEnd = udpSourcePortEnd.getValue().shortValue();
            }
        }
        classifier.setDestinationPortStart(dstPortStart);
        classifier.setSourcePortStart(srcPortStart);
        classifier.setDestinationPortEnd(dstPortEnd);
        classifier.setSourcePortEnd(srcPortEnd);
    }
}

