/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.packetcable.provider.OpenDaylightPacketCableProviderService;
import org.opendaylight.controller.packetcable.provider.processors.PCMMDataProcessor;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SalFlowService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.OriginalFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.UpdatedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.TrafficProfileBestEffortAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.TrafficProfileDocsisServiceClassNameAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.TrafficProfileFlowspecAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.add.flow.input.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.BestEffortCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.add.flow.input.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.DocsisServiceClassNameCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.traffic.profile.rev140908.add.flow.input.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.FlowspecCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.ApplyActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsAdded;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsAddedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.broker.rev140909.CmtsUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.rev140909.CmtsCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.cmts.rev140909.nodes.node.CmtsNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.UdpMatchRangesRpcRemoveFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.UdpMatchRangesRpcUpdateFlowOriginal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packetcable.match.types.rev140909.UdpMatchRangesRpcUpdateFlowUpdated;
import org.opendaylight.yangtools.concepts.CompositeObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.pcmm.gates.IClassifier;
import org.pcmm.gates.ITrafficProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpendaylightPacketcableProvider
implements DataChangeListener,
SalFlowService,
OpenDaylightPacketCableProviderService,
BindingAwareProvider,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(OpendaylightPacketcableProvider.class);
    private NotificationProviderService notificationProvider;
    private DataBroker dataProvider;
    private final ExecutorService executor;
    private final AtomicReference<Future<?>> currentConnectionsTasks = new AtomicReference();
    private BindingAwareBroker.ProviderContext providerContext;
    private NotificationProviderService notificationService;
    private DataBroker dataBroker;
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private List<InstanceIdentifier<?>> cmtsInstances;
    private PCMMDataProcessor pcmmDataProcessor;

    public OpendaylightPacketcableProvider() {
        logger.info("Instantiating");
        this.executor = Executors.newCachedThreadPool();
        this.cmtsInstances = Lists.newArrayList();
        this.pcmmDataProcessor = new PCMMDataProcessor();
    }

    public void setNotificationProvider(NotificationProviderService salService) {
        this.notificationProvider = salService;
    }

    public void setDataProvider(DataBroker salDataProvider) {
        this.dataProvider = salDataProvider;
    }

    @Override
    public void close() throws ExecutionException, InterruptedException {
        logger.info("Closing");
        this.executor.shutdown();
        if (this.dataProvider != null) {
            Iterator<InstanceIdentifier<?>> iter = this.cmtsInstances.iterator();
            while (iter.hasNext()) {
                WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
                tx.delete(LogicalDatastoreType.OPERATIONAL, iter.next());
                Futures.addCallback((ListenableFuture)tx.submit(), (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(Void result) {
                        logger.debug("Delete commit result: " + result);
                    }

                    public void onFailure(Throwable t) {
                        logger.error("Delete operation failed", t);
                    }
                });
            }
        }
    }

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> change) {
        DataObject dataObject = (DataObject)change.getUpdatedSubtree();
        logger.debug("OpendaylightPacketcableProvider.onDataChanged() :" + dataObject);
    }

    public void notifyConsumerOnCmtsAdd(CmtsNode input, TransactionId transactionId) {
        CmtsAdded cmtsRemoved = new CmtsAddedBuilder().setAddress(input.getAddress()).setPort(input.getPort()).setTransactionId(transactionId).build();
        this.notificationProvider.publish((Notification)cmtsRemoved);
    }

    public void notifyConsumerOnCmtsRemove(CmtsNode input, TransactionId transactionId) {
        CmtsRemoved cmtsRemoved = new CmtsRemovedBuilder().setAddress(input.getAddress()).setPort(input.getPort()).setTransactionId(transactionId).build();
        this.notificationProvider.publish((Notification)cmtsRemoved);
    }

    public void notifyConsumerOnCmtsUpdate(CmtsNode input, TransactionId transactionId) {
        CmtsUpdated cmtsRemoved = new CmtsUpdatedBuilder().setAddress(input.getAddress()).setPort(input.getPort()).setTransactionId(transactionId).build();
        this.notificationProvider.publish((Notification)cmtsRemoved);
    }

    public Future<RpcResult<AddFlowOutput>> addFlow(AddFlowInput input) {
        Match match = input.getMatch();
        CmtsNode cmts = this.getCmtsNode((NodeContextRef)input);
        if (cmts != null) {
            this.cmtsInstances.add(input.getNode().getValue());
        }
        IClassifier classifier = this.buildClassifier(match);
        ITrafficProfile trafficProfie = null;
        block0: for (Instruction i : input.getInstructions().getInstruction()) {
            if (!(i.getInstruction() instanceof ApplyActionsCase)) continue;
            ApplyActionsCase aac = (ApplyActionsCase)i.getInstruction();
            for (Action a : aac.getApplyActions().getAction()) {
                if (a.getAction() instanceof FlowspecCase) continue;
                if (a.getAction() instanceof BestEffortCase) {
                    trafficProfie = this.buildTrafficProfile((TrafficProfileBestEffortAttributes)((BestEffortCase)a.getAction()).getBestEffort());
                    continue block0;
                }
                if (!(a.getAction() instanceof DocsisServiceClassNameCase)) continue;
                trafficProfie = this.buildTrafficProfile((TrafficProfileDocsisServiceClassNameAttributes)((DocsisServiceClassNameCase)a.getAction()).getDocsisServiceClassName());
                continue block0;
            }
        }
        TransactionId transactionId = null;
        this.notifyConsumerOnCmtsAdd(cmts, transactionId);
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)new AddFlowOutputBuilder().setTransactionId(transactionId).build()).build());
    }

    @Override
    public ITrafficProfile buildTrafficProfile(TrafficProfileDocsisServiceClassNameAttributes docsis) {
        return this.pcmmDataProcessor.process(docsis);
    }

    @Override
    public ITrafficProfile buildTrafficProfile(TrafficProfileBestEffortAttributes bestEffort) {
        return this.pcmmDataProcessor.process(bestEffort);
    }

    @Override
    public ITrafficProfile buildTrafficProfile(TrafficProfileFlowspecAttributes flowSpec) {
        return this.pcmmDataProcessor.process(flowSpec);
    }

    @Override
    public IClassifier buildClassifier(Match match) {
        return this.pcmmDataProcessor.process(match);
    }

    public Future<RpcResult<RemoveFlowOutput>> removeFlow(RemoveFlowInput input) {
        UdpMatchRangesRpcRemoveFlow updRange = (UdpMatchRangesRpcRemoveFlow)input.getMatch().getAugmentation(UdpMatchRangesRpcRemoveFlow.class);
        this.notifyConsumerOnCmtsRemove(this.getCmtsNode((NodeContextRef)input), null);
        return null;
    }

    public Future<RpcResult<UpdateFlowOutput>> updateFlow(UpdateFlowInput input) {
        OriginalFlow foo = input.getOriginalFlow();
        UdpMatchRangesRpcUpdateFlowOriginal bar = (UdpMatchRangesRpcUpdateFlowOriginal)foo.getMatch().getAugmentation(UdpMatchRangesRpcUpdateFlowOriginal.class);
        UpdatedFlow updated = input.getUpdatedFlow();
        UdpMatchRangesRpcUpdateFlowUpdated updatedRange = (UdpMatchRangesRpcUpdateFlowUpdated)updated.getMatch().getAugmentation(UdpMatchRangesRpcUpdateFlowUpdated.class);
        this.notifyConsumerOnCmtsUpdate(this.getCmtsNode((NodeContextRef)input), null);
        return null;
    }

    protected CmtsNode getCmtsNode(NodeContextRef input) {
        NodeRef nodeRef = input.getNode();
        InstanceIdentifier instanceIdentifier = nodeRef.getValue();
        ReadOnlyTransaction rtransaction = this.dataBroker.newReadOnlyTransaction();
        CheckedFuture value = rtransaction.read(LogicalDatastoreType.CONFIGURATION, instanceIdentifier);
        rtransaction.close();
        Optional opt = null;
        try {
            opt = (Optional)value.get();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
        Node node = (Node)opt.get();
        CmtsCapableNode cmts = (CmtsCapableNode)node.getAugmentation(CmtsCapableNode.class);
        CmtsNode cmtsNode = cmts.getCmtsNode();
        return cmtsNode;
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        logger.info("Initiating session");
        this.providerContext = session;
        this.notificationService = (NotificationProviderService)session.getSALService(NotificationProviderService.class);
        this.dataBroker = (DataBroker)session.getSALService(DataBroker.class);
        InstanceIdentifier listenTo = InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(CmtsCapableNode.class).child(CmtsNode.class);
        this.listenerRegistration = this.dataBroker.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, listenTo, (DataChangeListener)this, AsyncDataBroker.DataChangeScope.BASE);
    }

    public void onSessionAdded() {
        CompositeObjectRegistration.CompositeObjectRegistrationBuilder builder = CompositeObjectRegistration.builderFor((Object)this);
        BindingAwareBroker.RoutedRpcRegistration registration = this.providerContext.addRoutedRpcImplementation(SalFlowService.class, (RpcService)this);
    }
}

