/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier.ClassifierContainerValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.classifier.attributes.Classifiers;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.classifier.attributes.classifiers.ClassifierContainer;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.classifier.attributes.classifiers.classifier.container.classifier.choice.QosClassifierChoice;

public class ClassifiersValidator
extends AbstractValidator<Classifiers> {
    private static final String CLASSIFER_CONTAINER = "classifers.classifer-container";
    private final ClassifierContainerValidator classifierContainerValidator = new ClassifierContainerValidator();

    @Override
    protected void doValidate(Classifiers classifiers, Validator.Extent extent) {
        if (classifiers == null) {
            this.getErrorMessages().add("classifiers must exist");
            return;
        }
        this.mustExistAndNotBeEmpty(classifiers.getClassifierContainer(), CLASSIFER_CONTAINER);
        boolean hasBasic = false;
        boolean hasExtOrIpv6 = false;
        for (ClassifierContainer classifier : classifiers.getClassifierContainer()) {
            if (classifier.getClassifierChoice() instanceof QosClassifierChoice) {
                hasBasic = true;
                continue;
            }
            hasExtOrIpv6 = true;
        }
        if (hasBasic && hasExtOrIpv6) {
            this.getErrorMessages().add("Legacy classifiers cannot be used in conjunction with Extended or Ipv6 Classifiers");
        }
        if (extent == Validator.Extent.NODE_AND_SUBTREE) {
            for (ClassifierContainer classifier : classifiers.getClassifierContainer()) {
                this.validateChild(this.classifierContainerValidator, classifier);
            }
        }
    }
}

