/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.TrafficProfile;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.traffic.profile.traffic.profile.choice.FlowSpecChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.traffic.profile.traffic.profile.choice.RtpChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.traffic.profile.traffic.profile.choice.ServiceClassNameChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.traffic.profile.traffic.profile.choice.UgsChoice;

public class TrafficProfileValidator
extends AbstractValidator<TrafficProfile> {
    private static final String FS = "flow-spec-profile";
    private static final String SCN = "service-class-name";
    private static final String SCP = "service-class-name-profile";
    private static final String UGS = "ugs-profile";
    private static final String RTP = "rtp-profile";

    @Override
    protected void doValidate(TrafficProfile trafficProfile, Validator.Extent extent) {
        if (trafficProfile == null) {
            this.getErrorMessages().add("traffic-profile must exist");
            return;
        }
        if (trafficProfile.getTrafficProfileChoice() instanceof ServiceClassNameChoice) {
            this.mustExist(((ServiceClassNameChoice)trafficProfile.getTrafficProfileChoice()).getServiceClassNameProfile(), SCP);
            this.mustExist(((ServiceClassNameChoice)trafficProfile.getTrafficProfileChoice()).getServiceClassNameProfile().getServiceClassName(), SCN);
        } else if (trafficProfile.getTrafficProfileChoice() instanceof FlowSpecChoice) {
            this.mustExist(((FlowSpecChoice)trafficProfile.getTrafficProfileChoice()).getFlowSpecProfile(), SCP);
        } else if (trafficProfile.getTrafficProfileChoice() instanceof RtpChoice) {
            this.mustExist(((RtpChoice)trafficProfile.getTrafficProfileChoice()).getRtpProfile(), RTP);
        } else if (trafficProfile.getTrafficProfileChoice() instanceof UgsChoice) {
            this.mustExist(((UgsChoice)trafficProfile.getTrafficProfileChoice()).getUgsProfile(), UGS);
        } else {
            this.getErrorMessages().add("Unknown traffic profile");
            return;
        }
    }
}

