/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.SubscribersValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.App;

public class AppValidator
extends AbstractValidator<App> {
    private static final String APP_ID = "app.appId";
    private static final String SUBSCRIBERS = "app.subscribers";
    private final SubscribersValidator subscribersValidator = new SubscribersValidator();

    @Override
    protected void doValidate(App app, Validator.Extent extent) {
        if (app == null) {
            this.getErrorMessages().add("app must exist");
            return;
        }
        this.mustExist(app.getAppId(), APP_ID);
        this.mustExist(app.getSubscribers(), SUBSCRIBERS);
        if (extent == Validator.Extent.NODE_AND_SUBTREE) {
            this.validateChild(this.subscribersValidator, app.getSubscribers());
        }
    }
}

