/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalUtils.class);
    private DataBroker databroker = null;

    public MdsalUtils(DataBroker dataBroker) {
        this.databroker = dataBroker;
    }

    public <D extends DataObject> boolean delete(LogicalDatastoreType store, InstanceIdentifier<D> path) {
        boolean result = false;
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.delete(store, path);
        CheckedFuture future = transaction.submit();
        try {
            future.checkedGet();
            result = true;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Failed to delete {} ", path, (Object)e);
        }
        return result;
    }

    public <D extends DataObject> boolean merge(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data) {
        boolean result = false;
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.merge(logicalDatastoreType, path, data, true);
        CheckedFuture future = transaction.submit();
        try {
            future.checkedGet();
            result = true;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Failed to merge {} ", path, (Object)e);
        }
        return result;
    }

    public <D extends DataObject> Optional<D> read(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path) {
        ReadOnlyTransaction readOnlyTransaction = this.databroker.newReadOnlyTransaction();
        CheckedFuture future = readOnlyTransaction.read(logicalDatastoreType, path);
        try {
            return (Optional)future.checkedGet();
        }
        catch (ReadFailedException e) {
            LOG.error("Failed to read {} at path {}", new Object[]{logicalDatastoreType, path, e});
            return Optional.absent();
        }
    }

    public <D extends DataObject> boolean put(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data) {
        boolean result = false;
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.put(logicalDatastoreType, path, data, true);
        CheckedFuture future = transaction.submit();
        try {
            future.checkedGet();
            result = true;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Failed to merge {} ", path, (Object)e);
        }
        return result;
    }
}

