/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;

public class DataChangeUtils {
    public static <T extends DataObject> Map<InstanceIdentifier<T>, T> collectTypeFromMap(Class<T> tClass, Map<InstanceIdentifier<?>, DataObject> map) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<InstanceIdentifier<?>, DataObject> entry : map.entrySet()) {
            if (!tClass.isAssignableFrom(entry.getValue().getImplementedInterface())) continue;
            InstanceIdentifier<?> tIID = entry.getKey();
            DataObject tObj = entry.getValue();
            result.put(tIID, tObj);
        }
        return result;
    }

    public static <T extends DataObject> Set<InstanceIdentifier<T>> collectTypeFromSet(Class<T> tClass, Set<InstanceIdentifier<?>> set) {
        HashSet result = Sets.newHashSet();
        for (InstanceIdentifier<?> iid : set) {
            if (!tClass.isAssignableFrom(iid.getTargetType())) continue;
            InstanceIdentifier<?> tIID = iid;
            result.add(tIID);
        }
        return result;
    }

    public static Map<InstanceIdentifier<?>, DataObject> relativeComplement(Map<InstanceIdentifier<?>, DataObject> setA, Map<InstanceIdentifier<?>, DataObject> setB) {
        HashMap result = Maps.newHashMap();
        for (InstanceIdentifier<?> iid : setB.keySet()) {
            if (setA.containsKey(iid)) continue;
            result.put(iid, setB.get(iid));
        }
        return result;
    }

    public static void logChange(Logger logger, AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> change) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        DataChangeUtils.appendMap(sb, "CREATED", change.getCreatedData());
        DataChangeUtils.appendSet(sb, "REMOVED", change.getRemovedPaths());
        DataChangeUtils.appendMap(sb, "UPDATED", change.getUpdatedData());
        DataChangeUtils.appendMap(sb, "ORIGINAL", change.getOriginalData());
        logger.debug("onDataChanged data:\n{}", (Object)sb.toString());
    }

    private static <E> void appendSet(StringBuilder sb, String name, Set<E> set) {
        sb.append("====").append(name).append("====\n");
        if (set == null || set.isEmpty()) {
            sb.append("None\n");
        } else {
            for (E data : set) {
                sb.append(data).append("\n");
                sb.append("----------\n");
            }
        }
        sb.append("===============\n");
    }

    private static void appendMap(StringBuilder sb, String name, Map<InstanceIdentifier<?>, DataObject> dataMap) {
        sb.append("====").append(name).append("====\n");
        if (dataMap == null || dataMap.isEmpty()) {
            sb.append("None\n");
        } else {
            for (Map.Entry<InstanceIdentifier<?>, DataObject> entry : dataMap.entrySet()) {
                sb.append(entry.getValue()).append("\n");
                sb.append("----------\n");
            }
        }
        sb.append("===============\n");
    }
}

