/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier.ClassifierValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier.ExtClassifierValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier.Ipv6ClassifierValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.classifier.attributes.classifiers.classifier.container.ClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.classifier.attributes.classifiers.classifier.container.classifier.choice.ExtClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.classifier.attributes.classifiers.classifier.container.classifier.choice.Ipv6ClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.classifier.attributes.classifiers.classifier.container.classifier.choice.QosClassifierChoice;

public class ClassifierChoiceValidator
extends AbstractValidator<ClassifierChoice> {
    private final ClassifierValidator classifierValidator = new ClassifierValidator();
    private final ExtClassifierValidator extClassifierValidator = new ExtClassifierValidator();
    private final Ipv6ClassifierValidator ipv6ClassifierValidator = new Ipv6ClassifierValidator();

    @Override
    protected void doValidate(ClassifierChoice choice, Validator.Extent extent) {
        if (choice == null) {
            this.getErrorMessages().add("classifier-choice must exist");
            return;
        }
        if (choice instanceof QosClassifierChoice) {
            this.validateChild(this.classifierValidator, ((QosClassifierChoice)choice).getClassifier());
        } else if (choice instanceof ExtClassifierChoice) {
            this.validateChild(this.extClassifierValidator, ((ExtClassifierChoice)choice).getExtClassifier());
        } else if (choice instanceof Ipv6ClassifierChoice) {
            this.validateChild(this.ipv6ClassifierValidator, ((Ipv6ClassifierChoice)choice).getIpv6Classifier());
        } else {
            throw new IllegalStateException("Unknown ClassifierChoice Type: " + choice.getClass().getName());
        }
    }
}

