/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.packetcable.provider.validation.ValidationException;
import org.opendaylight.controller.packetcable.provider.validation.Validator;

@NotThreadSafe
public abstract class AbstractValidator<T>
implements Validator<T> {
    private ArrayList<String> errorMessages = null;

    protected void throwErrorsIfNeeded() throws ValidationException {
        if (this.errorMessages != null && !this.errorMessages.isEmpty()) {
            ValidationException exception = new ValidationException(this.errorMessages);
            this.resetErrorMessages();
            throw exception;
        }
    }

    protected void resetErrorMessages() {
        this.errorMessages = null;
    }

    protected void mustExist(Object obj, String name) {
        if (obj == null) {
            this.getErrorMessages().add(name + " must exist");
        }
    }

    protected ArrayList<String> getErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList(2);
        }
        return this.errorMessages;
    }

    protected void mustExistAndNotBeEmpty(Collection<?> collection, String name) {
        if (collection == null) {
            this.getErrorMessages().add(name + " must exist");
        } else if (collection.isEmpty()) {
            this.getErrorMessages().add(name + " must not be empty");
        }
    }

    protected <C> void validateChild(Validator<C> validator, C child) {
        try {
            validator.validate(child, Validator.Extent.NODE_AND_SUBTREE);
        }
        catch (ValidationException e) {
            this.getErrorMessages().addAll((Collection<String>)e.getErrorMessages());
        }
    }

    @Override
    public void validate(T data, Validator.Extent extent) throws ValidationException {
        Preconditions.checkNotNull((Object)((Object)extent));
        this.doValidate(data, extent);
        this.throwErrorsIfNeeded();
    }

    protected abstract void doValidate(T var1, Validator.Extent var2);
}

