/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.opendaylight.controller.packetcable.provider.validation.ValidationException;
import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.ValidatorProvider;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ValidatorProviderImpl
implements ValidatorProvider {
    private final Map<Class<? extends DataObject>, Validator<? extends DataObject>> validatorMap = Maps.newHashMap();

    @Override
    public <T extends DataObject> void put(@Nonnull Class<T> tClass, @Nonnull Validator<T> validator) {
        Preconditions.checkNotNull(tClass);
        Preconditions.checkNotNull(validator);
        this.validatorMap.put(tClass, validator);
    }

    @Override
    public <T extends DataObject> void validate(@Nonnull Class<T> tClass, @Nonnull DataObject data, @Nonnull Validator.Extent extent) throws ValidationException {
        if (!tClass.isAssignableFrom(data.getClass())) {
            throw new IllegalArgumentException(String.format("data must be the same type as tClass, got=%s : expected=%s", data.getImplementedInterface(), tClass));
        }
        DataObject tData = data;
        this.validatorFor(tClass).validate(tData, extent);
    }

    @Override
    public <T extends DataObject> Validator<T> validatorFor(@Nonnull Class<T> tClass) {
        Preconditions.checkNotNull(tClass);
        if (this.validatorMap.containsKey(tClass)) {
            Validator<? extends DataObject> result = this.validatorMap.get(tClass);
            return result;
        }
        throw new NoSuchElementException("Entry not found for key: " + tClass);
    }
}

