/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.packetcable.provider.AbstractDataTreeChangeListener;
import org.opendaylight.controller.packetcable.provider.MdsalUtils;
import org.opendaylight.controller.packetcable.provider.PCMMService;
import org.opendaylight.controller.packetcable.provider.Subnet;
import org.opendaylight.controller.packetcable.provider.validation.DataValidator;
import org.opendaylight.controller.packetcable.provider.validation.ValidationException;
import org.opendaylight.controller.packetcable.provider.validation.impl.CcapsValidatorProviderFactory;
import org.opendaylight.controller.packetcable.provider.validation.impl.QosValidatorProviderFactory;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.AppContext;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.CcapContext;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.CcapPollConnectionInput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.CcapPollConnectionOutput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.CcapPollConnectionOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.CcapSetConnectionInput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.CcapSetConnectionOutput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.CcapSetConnectionOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.Ccaps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.FailureType;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.PacketcableService;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.Qos;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosDeleteGateInput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosDeleteGateOutput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosDeleteGateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosGateInfoInput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosGateInfoOutput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosGateInfoOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosPollGatesInput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosPollGatesOutput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosPollGatesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosSetGateInput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosSetGateOutput;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.QosSetGateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.set.connection.output.ccap.ConnectionBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccaps.Ccap;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccaps.CcapBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccaps.CcapKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gate.spec.GateSpec;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gate.spec.GateSpecBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.Apps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.App;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.AppBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.AppKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.Subscribers;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.SubscribersBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.Subscriber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.SubscriberBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.SubscriberKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.Gates;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.GatesBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.Gate;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.TrafficProfile;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.TrafficProfileBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.traffic.profile.TrafficProfileChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.traffic.profile.traffic.profile.choice.ServiceClassNameChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.traffic.profile.traffic.profile.traffic.profile.choice.ServiceClassNameChoiceBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.serviceclass.name.profile.ServiceClassNameProfile;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.serviceclass.name.profile.ServiceClassNameProfileBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.delete.gate.response.DeleteResponseType;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.delete.gate.response.delete.response.type.DeleteFailure;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.delete.gate.response.delete.response.type.DeleteFailureBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.delete.gate.response.delete.response.type.DeleteSuccessful;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.delete.gate.response.delete.response.type.DeleteSuccessfulBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.InfoResponseType;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.InfoFailure;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.InfoFailureBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.InfoSuccessful;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.InfoSuccessfulBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.info.successful.gates.GateBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.response.SetResponseType;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.response.set.response.type.SetFailure;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.response.set.response.type.SetFailureBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.response.set.response.type.SetSuccessful;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.response.set.response.type.SetSuccessfulBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PacketcableProvider
implements BindingAwareProvider,
AutoCloseable,
PacketcableService {
    private static final Logger logger = LoggerFactory.getLogger(PacketcableProvider.class);
    private static final InstanceIdentifier<Ccaps> ccapsIID = InstanceIdentifier.builder(Ccaps.class).build();
    private static final InstanceIdentifier<Qos> qosIID = InstanceIdentifier.builder(Qos.class).build();
    private final Map<String, Ccap> ccapMap = new ConcurrentHashMap<String, Ccap>();
    private final Map<String, Gate> gateMap = new ConcurrentHashMap<String, Gate>();
    private final Map<String, String> gateCcapMap = new ConcurrentHashMap<String, String>();
    private final Map<Subnet, Ccap> subscriberSubnetsMap = new ConcurrentHashMap<Subnet, Ccap>();
    private final Map<ServiceClassName, List<Ccap>> downstreamScnMap = new ConcurrentHashMap<ServiceClassName, List<Ccap>>();
    private final Map<ServiceClassName, List<Ccap>> upstreamScnMap = new ConcurrentHashMap<ServiceClassName, List<Ccap>>();
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final Map<String, PCMMService> pcmmServiceMap = new ConcurrentHashMap<String, PCMMService>();
    private DataBroker dataBroker;
    private MdsalUtils mdsalUtils;
    private BindingAwareBroker.RoutedRpcRegistration<PacketcableService> routedRpcRegistration;
    private BindingAwareBroker.RpcRegistration rpcRegistration;
    private final CcapsDataTreeChangeListener ccapsDataTreeChangeListener = new CcapsDataTreeChangeListener();
    private final QosDataTreeChangeListener qosDataTreeChangeListener = new QosDataTreeChangeListener();
    private ListenerRegistration<DataTreeChangeListener> ccapsDataTreeChangeListenerRegistration;
    private ListenerRegistration<DataTreeChangeListener> qosDataTreeChangeListenerRegistration;

    public PacketcableProvider() {
        logger.info("Starting Packetcable Provider");
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        logger.info("Packetcable Session Initiated");
        logger.info("logging levels: error={}, warn={}, info={}, debug={}, trace={}", new Object[]{logger.isErrorEnabled(), logger.isWarnEnabled(), logger.isInfoEnabled(), logger.isDebugEnabled(), logger.isTraceEnabled()});
        this.dataBroker = (DataBroker)session.getSALService(DataBroker.class);
        this.mdsalUtils = new MdsalUtils(this.dataBroker);
        DataTreeIdentifier ccapsDataTreeIid = new DataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, ccapsIID.child(Ccap.class));
        DataTreeIdentifier appDataTreeIid = new DataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, qosIID.child(Apps.class).child(App.class).child(Subscribers.class).child(Subscriber.class).child(Gates.class).child(Gate.class));
        this.ccapsDataTreeChangeListenerRegistration = this.dataBroker.registerDataTreeChangeListener(ccapsDataTreeIid, (DataTreeChangeListener)new CcapsDataTreeChangeListener());
        this.qosDataTreeChangeListenerRegistration = this.dataBroker.registerDataTreeChangeListener(appDataTreeIid, (DataTreeChangeListener)new QosDataTreeChangeListener());
        this.rpcRegistration = session.addRpcImplementation(PacketcableService.class, (RpcService)this);
        logger.info("onSessionInitiated().rpcRegistration: {}", (Object)this.rpcRegistration);
        this.routedRpcRegistration = session.addRoutedRpcImplementation(PacketcableService.class, (RpcService)this);
        logger.info("onSessionInitiated().routedRpcRegistration: {}", this.routedRpcRegistration);
    }

    @Override
    public void close() throws ExecutionException, InterruptedException {
        if (this.ccapsDataTreeChangeListenerRegistration != null) {
            this.ccapsDataTreeChangeListenerRegistration.close();
        }
        if (this.qosDataTreeChangeListenerRegistration != null) {
            this.qosDataTreeChangeListenerRegistration.close();
        }
        if (this.rpcRegistration != null) {
            this.rpcRegistration.close();
        }
    }

    private void updateCcapMaps(Ccap ccap) {
        ArrayList<Ccap> ccapList;
        for (IpPrefix ipPrefix : ccap.getSubscriberSubnets()) {
            try {
                this.subscriberSubnetsMap.put(Subnet.createInstance(this.getIpPrefixStr(ipPrefix)), ccap);
            }
            catch (UnknownHostException e) {
                logger.error("updateSubscriberSubnets: {}:{} FAILED: {}", new Object[]{ipPrefix, ccap, e.getMessage()});
            }
        }
        for (ServiceClassName scn : ccap.getUpstreamScns()) {
            if (this.upstreamScnMap.containsKey(scn)) {
                this.upstreamScnMap.get(scn).add(ccap);
                continue;
            }
            ccapList = new ArrayList<Ccap>();
            ccapList.add(ccap);
            this.upstreamScnMap.put(scn, ccapList);
        }
        for (ServiceClassName scn : ccap.getDownstreamScns()) {
            if (this.downstreamScnMap.containsKey(scn)) {
                this.downstreamScnMap.get(scn).add(ccap);
                continue;
            }
            ccapList = new ArrayList();
            ccapList.add(ccap);
            this.downstreamScnMap.put(scn, ccapList);
        }
    }

    private String getIpPrefixStr(IpPrefix ipPrefix) {
        Ipv4Prefix ipv4 = ipPrefix.getIpv4Prefix();
        if (ipv4 != null) {
            return ipv4.getValue();
        }
        return ipPrefix.getIpv6Prefix().getValue();
    }

    public InetAddress getInetAddress(String subId) {
        try {
            return InetAddress.getByName(subId);
        }
        catch (UnknownHostException e) {
            logger.error("getInetAddress: {} FAILED: {}", (Object)subId, (Object)e.getMessage());
            return null;
        }
    }

    private Ccap findCcapForSubscriberId(InetAddress inetAddr) {
        Ccap matchedCcap = null;
        int longestPrefixLen = -1;
        for (Map.Entry<Subnet, Ccap> entry : this.subscriberSubnetsMap.entrySet()) {
            int prefixLen;
            Subnet subnet = entry.getKey();
            if (!subnet.isInNet(inetAddr) || (prefixLen = subnet.getPrefixLen()) <= longestPrefixLen) continue;
            matchedCcap = entry.getValue();
            longestPrefixLen = prefixLen;
        }
        return matchedCcap;
    }

    private ServiceFlowDirection findScnOnCcap(ServiceClassName scn, Ccap ccap) {
        List<Ccap> ccapList;
        Preconditions.checkNotNull((Object)scn);
        Preconditions.checkNotNull((Object)ccap);
        if (this.upstreamScnMap.containsKey(scn)) {
            List<Ccap> ccapList2 = this.upstreamScnMap.get(scn);
            if (ccapList2.contains(ccap)) {
                return ServiceFlowDirection.Us;
            }
        } else if (this.downstreamScnMap.containsKey(scn) && (ccapList = this.downstreamScnMap.get(scn)).contains(ccap)) {
            return ServiceFlowDirection.Ds;
        }
        return null;
    }

    private void removeCcapFromAllMaps(Ccap ccap) {
        List ccapList;
        for (Map.Entry<Subnet, Ccap> entry : this.subscriberSubnetsMap.entrySet()) {
            if (entry.getValue() != ccap) continue;
            this.subscriberSubnetsMap.remove(entry.getKey());
        }
        for (Map.Entry<Subnet, Object> entry : this.upstreamScnMap.entrySet()) {
            ccapList = (List)entry.getValue();
            ccapList.remove(ccap);
            if (!ccapList.isEmpty()) continue;
            this.upstreamScnMap.remove(entry.getKey());
        }
        for (Map.Entry<Subnet, Object> entry : this.downstreamScnMap.entrySet()) {
            ccapList = (List)entry.getValue();
            ccapList.remove(ccap);
            if (!ccapList.isEmpty()) continue;
            this.downstreamScnMap.remove(entry.getKey());
        }
        PCMMService service = this.pcmmServiceMap.remove(ccap.getCcapId());
        if (service != null) {
            service.disconect();
        }
    }

    private <T extends DataObject> void saveErrors(@Nonnull DataTreeModification<T> change, ValidationException exception) {
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        InstanceIdentifier iid = change.getRootPath().getRootIdentifier();
        DataObject badData = change.getRootNode().getDataAfter();
        if (badData instanceof Ccap) {
            Ccap ccap = (Ccap)badData;
            Ccap opperationalCcap = new CcapBuilder().setCcapId(ccap.getCcapId()).setError(exception.getErrorMessages()).build();
            InstanceIdentifier ccapIID = (InstanceIdentifier)change;
            writeTransaction.put(LogicalDatastoreType.OPERATIONAL, ccapIID, (DataObject)opperationalCcap);
        } else if (badData instanceof Gate) {
            Gate gate = (Gate)badData;
            Gate operationalGate = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder().setGateId(gate.getGateId()).setError(exception.getErrorMessages()).build();
            Gates operationalGates = new GatesBuilder().setGate(Collections.singletonList(operationalGate)).build();
            SubscriberKey subscriberKey = (SubscriberKey)InstanceIdentifier.keyOf((InstanceIdentifier)iid.firstIdentifierOf(Subscriber.class));
            Subscriber operationalSubscriber = new SubscriberBuilder().setSubscriberId(subscriberKey.getSubscriberId()).setGates(operationalGates).build();
            Subscribers operationalSubscribers = new SubscribersBuilder().setSubscriber(Collections.singletonList(operationalSubscriber)).build();
            InstanceIdentifier appIID = iid.firstIdentifierOf(App.class);
            AppKey appKey = (AppKey)InstanceIdentifier.keyOf((InstanceIdentifier)appIID);
            App operationalApp = new AppBuilder().setAppId(appKey.getAppId()).setSubscribers(operationalSubscribers).build();
            writeTransaction.put(LogicalDatastoreType.OPERATIONAL, appIID, (DataObject)operationalApp);
        } else {
            logger.error("Unexpected type requested for error saving: {}", (Object)badData);
            throw new IllegalStateException("Unsupported type for error saving");
        }
        CheckedFuture future = writeTransaction.submit();
        try {
            future.checkedGet();
        }
        catch (TransactionCommitFailedException e) {
            logger.error("Failed to write errors to operational datastore", (Throwable)e);
        }
    }

    public Future<RpcResult<CcapSetConnectionOutput>> ccapSetConnection(CcapSetConnectionInput input) {
        InstanceIdentifier ccapIid = input.getCcapId();
        ArrayList<String> outputError = new ArrayList<String>();
        String rpcResponse = null;
        Boolean inputIsConnected = input.getConnection().isConnected();
        Boolean effectiveIsConnected = null;
        String ccapId = ((CcapKey)input.getCcapId().firstIdentifierOf(Ccap.class).firstKeyOf(Ccap.class)).getCcapId();
        PCMMService pcmmService = this.pcmmServiceMap.get(ccapId);
        if (!inputIsConnected.booleanValue()) {
            if (pcmmService.getPcmmPdpSocket().booleanValue()) {
                outputError.add(ccapId + ": CCAP COPS socket is already closed");
                effectiveIsConnected = false;
            } else {
                outputError.add(ccapId + ": CCAP client is disconnected with error: " + pcmmService.getPcmmCcapClientConnectErrMsg());
                pcmmService.ccapClient.disconnect();
                effectiveIsConnected = false;
            }
        } else if (!pcmmService.getPcmmPdpSocket().booleanValue() && pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
            outputError.add(ccapId + ": CCAP COPS socket is already open");
            outputError.add(ccapId + ": CCAP client is connected");
            effectiveIsConnected = true;
        } else {
            if (pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
                pcmmService.ccapClient.disconnect();
            }
            pcmmService.ccapClient.connect();
            if (pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
                effectiveIsConnected = true;
                outputError.add(ccapId + ": CCAP client is connected");
            } else {
                effectiveIsConnected = false;
                outputError.add(ccapId + ": CCAP client is disconnected with error: " + pcmmService.getPcmmCcapClientConnectErrMsg());
            }
        }
        DateAndTime connectionDateAndTime = this.getNowTimeStamp();
        ConnectionBuilder connectionRpcOutput = new ConnectionBuilder().setConnected(effectiveIsConnected).setError(outputError).setTimestamp(connectionDateAndTime);
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.set.connection.output.CcapBuilder ccapRpcOutput = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.set.connection.output.CcapBuilder().setCcapId(ccapId).setConnection(connectionRpcOutput.build());
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.attributes.ConnectionBuilder connectionOps = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.attributes.ConnectionBuilder().setConnected(effectiveIsConnected).setError(outputError).setTimestamp(connectionDateAndTime);
        CcapBuilder responseCcapBuilder = new CcapBuilder().setCcapId(ccapId).setConnection(connectionOps.build());
        this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, ccapIid, responseCcapBuilder.build());
        DateAndTime rpcDateAndTime = this.getNowTimeStamp();
        rpcResponse = ccapId + ": CCAP set complete";
        CcapSetConnectionOutputBuilder outputBuilder = new CcapSetConnectionOutputBuilder().setCcap(ccapRpcOutput.build()).setResponse(rpcResponse).setTimestamp(rpcDateAndTime);
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
    }

    public Future<RpcResult<CcapPollConnectionOutput>> ccapPollConnection(CcapPollConnectionInput input) {
        InstanceIdentifier ccapIid = input.getCcapId();
        ArrayList<String> outputError = new ArrayList<String>();
        String ccapId = ((CcapKey)input.getCcapId().firstIdentifierOf(Ccap.class).firstKeyOf(Ccap.class)).getCcapId();
        PCMMService pcmmService = this.pcmmServiceMap.get(ccapId);
        Boolean effectiveIsConnected = true;
        String response = null;
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.poll.connection.output.ccap.ConnectionBuilder connectionRpcOutput = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.poll.connection.output.ccap.ConnectionBuilder();
        if (pcmmService != null) {
            if (pcmmService.getPcmmPdpSocket().booleanValue()) {
                outputError.add(ccapId + ": CCAP Cops socket is closed");
                if (!pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
                    outputError.add(ccapId + ": CCAP client is disconnected with error: " + pcmmService.getPcmmCcapClientConnectErrMsg());
                }
                effectiveIsConnected = false;
            } else if (!pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
                outputError.add(ccapId + ": CCAP client is disconnected with error: " + pcmmService.getPcmmCcapClientConnectErrMsg());
                effectiveIsConnected = false;
            } else {
                outputError.add(ccapId + ": CCAP client is connected");
            }
            DateAndTime connectionDateAndTime = this.getNowTimeStamp();
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.attributes.ConnectionBuilder connectionOps = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.attributes.ConnectionBuilder().setConnected(effectiveIsConnected).setError(outputError).setTimestamp(connectionDateAndTime);
            CcapBuilder responseCcapBuilder = new CcapBuilder().setCcapId(ccapId).setConnection(connectionOps.build());
            connectionRpcOutput = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.poll.connection.output.ccap.ConnectionBuilder().setConnected(effectiveIsConnected).setError(outputError).setTimestamp(connectionDateAndTime);
            this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, ccapIid, responseCcapBuilder.build());
            response = ccapId + ": CCAP poll complete";
        } else {
            response = ccapId + ": CCAP connection null; no poll performed";
        }
        DateAndTime rpcDateAndTime = this.getNowTimeStamp();
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.poll.connection.output.CcapBuilder ccapRpcOutput = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.poll.connection.output.CcapBuilder().setCcapId(ccapId).setConnection(connectionRpcOutput.build());
        CcapPollConnectionOutputBuilder outputBuilder = new CcapPollConnectionOutputBuilder().setCcap(ccapRpcOutput.build()).setResponse(response).setTimestamp(rpcDateAndTime);
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
    }

    private App readAppFromOperationalDatastore(InstanceIdentifier<App> appIid) {
        Optional<App> optionalApp = this.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, appIid);
        AppBuilder thisAppBuilder = new AppBuilder((App)optionalApp.get());
        App thisApp = thisAppBuilder.build();
        logger.info("readAppFromConfigDatastore() retrived App: " + thisApp.getAppId());
        return thisApp;
    }

    private Gate readGateFromOperationalDatastore(InstanceIdentifier<Gate> gateIid) {
        Optional<Gate> optionalGate = this.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, gateIid);
        if (optionalGate.isPresent()) {
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder gateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder((Gate)optionalGate.get());
            Gate thisGate = gateBuilder.build();
            return thisGate;
        }
        return null;
    }

    private Subscriber readSubscriberFromOperationalDatastore(InstanceIdentifier<Subscriber> subscriberIid) {
        Optional<Subscriber> optionalSubscriber = this.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, subscriberIid);
        if (optionalSubscriber.isPresent()) {
            SubscriberBuilder subscriberBuilder = new SubscriberBuilder((Subscriber)optionalSubscriber.get());
            Subscriber thisSubscriber = subscriberBuilder.build();
            return thisSubscriber;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RpcResult<QosSetGateOutput>> qosSetGate(QosSetGateInput input) {
        logger.debug("RPC call to qosSetGate()");
        String inputAppIid = input.getAppId();
        String inputSubscriberId = input.getSubscriberId();
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.Gates gates = input.getGates();
        List gate = gates.getGate();
        QosSetGateOutputBuilder outputBuilder = new QosSetGateOutputBuilder();
        String inputGateId = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getGateId();
        Boolean retryOption = false;
        InstanceIdentifier gateIID = qosIID.builder().child(Apps.class).child(App.class, (Identifier)new AppKey(inputAppIid)).child(Subscribers.class).child(Subscriber.class, (Identifier)new SubscriberKey(inputSubscriberId)).child(Gates.class).child(Gate.class, (Identifier)new GateKey(inputGateId)).build();
        Gate newGate = this.readGateFromOperationalDatastore((InstanceIdentifier<Gate>)gateIID);
        String newGatePathStr = "/" + inputAppIid + "/" + inputSubscriberId + "/" + inputGateId;
        InetAddress subscriberAddr = this.getInetAddress(inputSubscriberId);
        if (subscriberAddr == null) {
            String msg = String.format("SubscriberId must be a valid ipaddress: %s", inputSubscriberId);
            logger.error(msg);
            SetFailureBuilder fb = new SetFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            SetFailure f = fb.build();
            outputBuilder.setSetResponseType((SetResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        Ccap ccap = this.findCcapForSubscriberId(subscriberAddr);
        if (ccap == null) {
            String msg = String.format("qosSetGate(): Error finding CCAP for %s", newGatePathStr);
            logger.error(msg);
            SetFailureBuilder fb = new SetFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            SetFailure f = fb.build();
            outputBuilder.setSetResponseType((SetResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        logger.debug("Mapped {} to {}", (Object)inputSubscriberId, (Object)ccap.getCcapId());
        PCMMService pcmmService = this.pcmmServiceMap.get(ccap.getCcapId());
        if (pcmmService == null) {
            String msg = String.format("Unable to locate PCMM Service for CCAP: %s ; with subscriber: %s", ccap, inputSubscriberId);
            logger.error(msg);
            SetFailureBuilder fb = new SetFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            SetFailure f = fb.build();
            outputBuilder.setSetResponseType((SetResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder gateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder();
        gateBuilder.setGateId(inputGateId).setGatePath(newGatePathStr).setCcapId(ccap.getCcapId()).setCopsGateId(((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getCopsGateId()).setTimestamp(this.getNowTimeStamp()).setTimestamp(this.getNowTimeStamp()).setGateSpec(((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getGateSpec()).setTrafficProfile(((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getTrafficProfile()).setClassifiers(((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getClassifiers());
        newGate = gateBuilder.build();
        if (((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getCopsGateId() != null) {
            retryOption = true;
        }
        PCMMService.GateSendStatus status = null;
        PCMMService ft = pcmmService;
        synchronized (ft) {
            logger.info("Sending gate: Path {} inputSubscriberId {} cops-gate-id {}", new Object[]{newGatePathStr, inputSubscriberId, ((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getCopsGateId()});
            status = pcmmService.sendGateSet(newGatePathStr, subscriberAddr, newGate);
        }
        if (status.didSucceed()) {
            this.gateMap.put(newGatePathStr, newGate);
            this.gateCcapMap.put(newGatePathStr, ccap.getCcapId());
            Long copsGateId = 0L;
            SetSuccessfulBuilder sb = new SetSuccessfulBuilder();
            if (status.getCopsGateId() != null) {
                logger.debug("newGate.getCopsGateId() = {} ", (Object)status.getCopsGateId());
                copsGateId = Long.decode(status.getCopsGateId());
                sb.setCopsGateId(copsGateId);
                if (status.getCopsGateId() != null) {
                    gateBuilder.setCopsGateId(status.getCopsGateId());
                }
                if (status.getCopsGateState() != null) {
                    gateBuilder.setCopsGateState(status.getCopsGateState());
                }
                if (status.getCopsGateTimeInfo() != null) {
                    gateBuilder.setCopsGateTimeInfo(status.getCopsGateTimeInfo());
                }
                if (status.getCopsGateUsageInfo() != null) {
                    gateBuilder.setCopsGateUsageInfo(status.getCopsGateUsageInfo());
                }
            }
            this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIID, gateBuilder.build());
            SetSuccessful s = sb.build();
            outputBuilder.setSetResponseType((SetResponseType)s);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        if (retryOption.booleanValue()) {
            logger.info("qosSetGate error msg: {} reason: {}", (Object)status.getMessage(), (Object)status.getCopsGateStateReason());
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder retryGateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder();
            retryGateBuilder.setGateId(inputGateId).setGatePath(newGatePathStr).setCcapId(ccap.getCcapId()).setTimestamp(this.getNowTimeStamp()).setTimestamp(this.getNowTimeStamp()).setGateSpec(((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getGateSpec()).setTrafficProfile(((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getTrafficProfile()).setClassifiers(((org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.set.gate.input.gates.Gate)gate.get(0)).getClassifiers());
            newGate = retryGateBuilder.build();
            PCMMService sb = pcmmService;
            synchronized (sb) {
                logger.info("Sending gate: Path {} inputSubscriberId {} with cops-gate-id undefined", (Object)newGatePathStr);
                status = pcmmService.sendGateSet(newGatePathStr, subscriberAddr, newGate);
            }
            if (status.didSucceed()) {
                this.gateMap.put(newGatePathStr, newGate);
                this.gateCcapMap.put(newGatePathStr, ccap.getCcapId());
                Long copsGateId = 0L;
                SetSuccessfulBuilder sb2 = new SetSuccessfulBuilder();
                if (status.getCopsGateId() != null) {
                    logger.debug("newGate.getCopsGateId() = {} ", (Object)status.getCopsGateId());
                    copsGateId = Long.decode(status.getCopsGateId());
                    sb2.setCopsGateId(copsGateId);
                    if (status.getCopsGateId() != null) {
                        gateBuilder.setCopsGateId(status.getCopsGateId());
                    }
                    if (status.getCopsGateState() != null) {
                        gateBuilder.setCopsGateState(status.getCopsGateState());
                    }
                    if (status.getCopsGateTimeInfo() != null) {
                        gateBuilder.setCopsGateTimeInfo(status.getCopsGateTimeInfo());
                    }
                    if (status.getCopsGateUsageInfo() != null) {
                        gateBuilder.setCopsGateUsageInfo(status.getCopsGateUsageInfo());
                    }
                }
                this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIID, gateBuilder.build());
                SetSuccessful s = sb2.build();
                outputBuilder.setSetResponseType((SetResponseType)s);
                return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
            }
        }
        SetFailureBuilder fb = new SetFailureBuilder();
        FailureType ft2 = FailureType.Failed;
        fb.setFailure(ft2);
        fb.setMessage(status.getMessage());
        SetFailure f = fb.build();
        outputBuilder.setSetResponseType((SetResponseType)f);
        logger.error("qosSetGate error msg: {} reason: {}", (Object)status.getMessage(), (Object)status.getCopsGateStateReason());
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RpcResult<QosDeleteGateOutput>> qosDeleteGate(QosDeleteGateInput input) {
        logger.debug("RPC call to qosDeleteGate()");
        String inputAppIid = input.getAppId();
        String inputSubscriberId = input.getSubscriberId();
        String inputGateId = input.getGateId();
        String strGateId = null;
        InstanceIdentifier gateIID = qosIID.builder().child(Apps.class).child(App.class, (Identifier)new AppKey(inputAppIid)).child(Subscribers.class).child(Subscriber.class, (Identifier)new SubscriberKey(inputSubscriberId)).child(Gates.class).child(Gate.class, (Identifier)new GateKey(inputGateId)).build();
        Gate newGate = this.readGateFromOperationalDatastore((InstanceIdentifier<Gate>)gateIID);
        QosDeleteGateOutputBuilder outputBuilder = new QosDeleteGateOutputBuilder();
        String newGatePathStr = "/" + inputAppIid + "/" + inputSubscriberId + "/" + inputGateId;
        if (newGate != null) {
            strGateId = newGate.getCopsGateId();
            if (strGateId == null || strGateId.length() == 0 || strGateId.equals("null")) {
                String msg = String.format("qosDeleteGate(): Unknown CopsGateId %s", newGatePathStr);
                logger.error(msg);
                DeleteFailureBuilder fb = new DeleteFailureBuilder();
                FailureType ft = FailureType.Unsent;
                fb.setFailure(ft);
                fb.setMessage(msg);
                DeleteFailure f = fb.build();
                outputBuilder.setDeleteResponseType((DeleteResponseType)f);
                return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
            }
        } else {
            String msg = String.format("qosDeleteGate(): Error deleting gate %s", newGatePathStr);
            logger.error(msg);
            DeleteFailureBuilder fb = new DeleteFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            DeleteFailure f = fb.build();
            outputBuilder.setDeleteResponseType((DeleteResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        logger.debug("PacketcableProvider: gateId = {} ", (Object)strGateId);
        InetAddress subscriberAddr = this.getInetAddress(inputSubscriberId);
        if (subscriberAddr == null) {
            String msg = String.format("SubscriberId must be a valid ipaddress: %s", inputSubscriberId);
            logger.error(msg);
            DeleteFailureBuilder fb = new DeleteFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            DeleteFailure f = fb.build();
            outputBuilder.setDeleteResponseType((DeleteResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        Ccap ccap = this.findCcapForSubscriberId(subscriberAddr);
        if (ccap == null) {
            String msg = String.format("Unable to find Ccap for subscriber %s:", inputSubscriberId);
            logger.error(msg);
            DeleteFailureBuilder fb = new DeleteFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            DeleteFailure f = fb.build();
            outputBuilder.setDeleteResponseType((DeleteResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        logger.debug("Mapped {} to {}", (Object)inputSubscriberId, (Object)ccap.getCcapId());
        PCMMService pcmmService = this.pcmmServiceMap.get(ccap.getCcapId());
        if (pcmmService == null) {
            String msg = String.format("Unable to locate PCMM Service for CCAP: %s ; with subscriber: %s", ccap, inputSubscriberId);
            logger.error(msg);
            DeleteFailureBuilder fb = new DeleteFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            DeleteFailure f = fb.build();
            outputBuilder.setDeleteResponseType((DeleteResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        Boolean status = false;
        PCMMService fb = pcmmService;
        synchronized (fb) {
            status = pcmmService.sendGateDelete(newGatePathStr);
        }
        if (status.booleanValue()) {
            Long copsGateId = 0L;
            copsGateId = Long.decode(strGateId);
            logger.info("qosDeleteGate(): Successfully deleted gate {}", (Object)newGatePathStr);
            this.mdsalUtils.delete(LogicalDatastoreType.OPERATIONAL, gateIID);
            DeleteSuccessfulBuilder sb = new DeleteSuccessfulBuilder();
            sb.setCopsGateId(copsGateId);
            DeleteSuccessful s = sb.build();
            outputBuilder.setDeleteResponseType((DeleteResponseType)s);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        String msg = String.format("qosDeleteGate(): Error deleting gate %s", newGatePathStr);
        logger.error(msg);
        DeleteFailureBuilder fb2 = new DeleteFailureBuilder();
        FailureType ft = FailureType.Failed;
        fb2.setFailure(ft);
        fb2.setMessage(msg);
        DeleteFailure f = fb2.build();
        outputBuilder.setDeleteResponseType((DeleteResponseType)f);
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RpcResult<QosGateInfoOutput>> qosGateInfo(QosGateInfoInput input) {
        logger.debug("RPC call to qosGateInfo()");
        String inputAppIid = input.getAppId();
        String inputSubscriberId = input.getSubscriberId();
        String inputGateId = input.getGateId();
        QosGateInfoOutputBuilder outputBuilder = new QosGateInfoOutputBuilder();
        InstanceIdentifier gateIID = qosIID.builder().child(Apps.class).child(App.class, (Identifier)new AppKey(inputAppIid)).child(Subscribers.class).child(Subscriber.class, (Identifier)new SubscriberKey(inputSubscriberId)).child(Gates.class).child(Gate.class, (Identifier)new GateKey(inputGateId)).build();
        Gate infoGate = this.readGateFromOperationalDatastore((InstanceIdentifier<Gate>)gateIID);
        String newGatePathStr = "/" + inputAppIid + "/" + inputSubscriberId + "/" + inputGateId;
        InetAddress subscriberAddr = this.getInetAddress(inputSubscriberId);
        if (subscriberAddr == null) {
            String msg = String.format("SubscriberId must be a valid ipaddress: %s", inputSubscriberId);
            logger.error(msg);
            InfoFailureBuilder fb = new InfoFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            InfoFailure f = fb.build();
            outputBuilder.setInfoResponseType((InfoResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        Ccap ccap = this.findCcapForSubscriberId(subscriberAddr);
        if (ccap == null) {
            String msg = String.format("Unable to find Ccap for subscriber %s:", inputSubscriberId);
            logger.error(msg);
            InfoFailureBuilder fb = new InfoFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            InfoFailure f = fb.build();
            outputBuilder.setInfoResponseType((InfoResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        logger.debug("Mapped {} to {}", (Object)inputSubscriberId, (Object)ccap.getCcapId());
        PCMMService pcmmService = this.pcmmServiceMap.get(ccap.getCcapId());
        if (pcmmService == null) {
            String msg = String.format("Unable to locate PCMM Service for CCAP: %s ; with subscriber: %s", ccap, inputSubscriberId);
            logger.error(msg);
            InfoFailureBuilder fb = new InfoFailureBuilder();
            FailureType ft = FailureType.Unsent;
            fb.setFailure(ft);
            fb.setMessage(msg);
            InfoFailure f = fb.build();
            outputBuilder.setInfoResponseType((InfoResponseType)f);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        PCMMService.GateSendStatus status = null;
        PCMMService fb = pcmmService;
        synchronized (fb) {
            status = pcmmService.sendGateInfo(newGatePathStr);
        }
        if (status.didSucceed()) {
            DateAndTime gateDateAndTime = this.getNowTimeStamp();
            List<Object> gateOutputError = Collections.emptyList();
            gateOutputError = Collections.singletonList(status.getMessage());
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder gateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder();
            gateBuilder.setGateId(inputGateId).setGatePath(newGatePathStr).setCcapId(ccap.getCcapId()).setCopsGateState(status.getCopsGateState() + "/" + status.getCopsGateStateReason()).setCopsGateTimeInfo(status.getCopsGateTimeInfo()).setCopsGateUsageInfo(status.getCopsGateUsageInfo()).setCopsGateId(status.getCopsGateId()).setError(gateOutputError).setTimestamp(gateDateAndTime);
            infoGate = gateBuilder.build();
            this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIID, infoGate);
            GateBuilder responseGateBuilder = new GateBuilder();
            responseGateBuilder.fieldsFrom((DataObject)infoGate);
            responseGateBuilder.setGateId(inputGateId);
            responseGateBuilder.setGatePath(newGatePathStr);
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.info.successful.gates.Gate responseGate = responseGateBuilder.build();
            ArrayList<org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.info.successful.gates.Gate> responseGateList = new ArrayList<org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.info.successful.gates.Gate>();
            responseGateList.add(responseGate);
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.info.successful.GatesBuilder responseGatesBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.info.successful.GatesBuilder();
            responseGatesBuilder.setGate(responseGateList);
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.gate.info.response.info.response.type.info.successful.Gates responseGates = responseGatesBuilder.build();
            InfoSuccessfulBuilder sb = new InfoSuccessfulBuilder();
            sb.setGates(responseGates);
            InfoSuccessful s = sb.build();
            outputBuilder.setInfoResponseType((InfoResponseType)s);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
        }
        String msg = String.format("qosGateInfo(): error msg: %s reason: %s", status.getMessage(), status.getCopsGateStateReason());
        logger.error(msg);
        InfoFailureBuilder fb2 = new InfoFailureBuilder();
        FailureType ft = FailureType.Failed;
        fb2.setFailure(ft);
        fb2.setMessage(msg);
        InfoFailure f = fb2.build();
        outputBuilder.setInfoResponseType((InfoResponseType)f);
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
    }

    public Future<RpcResult<QosPollGatesOutput>> qosPollGates(QosPollGatesInput input) {
        InstanceIdentifier appIid = input.getAppId();
        App app = this.readAppFromOperationalDatastore((InstanceIdentifier<App>)appIid);
        AppKey appKey = (AppKey)InstanceIdentifier.keyOf((InstanceIdentifier)appIid);
        String inputSubscriberId = input.getSubscriberId();
        String inputGateId = input.getGateId();
        List<Object> gateOutputError = Collections.emptyList();
        String subscriberId = null;
        String gateId = null;
        String ccapId = null;
        String gatePathStr = null;
        String opsCopsGateId = null;
        Gate opsGate = null;
        String rpcResponse = null;
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.poll.gates.output.GateBuilder gateOutputBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.poll.gates.output.GateBuilder();
        org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder gateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder();
        if (inputSubscriberId != null) {
            if (inputGateId != null) {
                InstanceIdentifier gateIid = appIid.builder().child(Subscribers.class).child(Subscriber.class, (Identifier)new SubscriberKey(inputSubscriberId)).child(Gates.class).child(Gate.class, (Identifier)new GateKey(inputGateId)).build();
                opsGate = this.readGateFromOperationalDatastore((InstanceIdentifier<Gate>)gateIid);
                if (opsGate == null) {
                    gatePathStr = appKey.getAppId() + "/" + inputSubscriberId + "/" + inputGateId;
                    rpcResponse = gatePathStr + ": gate does not exist in the system; gate poll not performed";
                } else {
                    opsCopsGateId = opsGate.getCopsGateId();
                    gatePathStr = opsGate.getGatePath();
                    if (!Objects.equals(opsCopsGateId, "") && !Objects.equals(opsCopsGateId, null)) {
                        ccapId = this.findCcapForSubscriberId(this.getInetAddress(inputSubscriberId)).getCcapId();
                        PCMMService pcmmService = this.pcmmServiceMap.get(ccapId);
                        if (!pcmmService.getPcmmPdpSocket().booleanValue() && pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
                            PCMMService.GateSendStatus status = pcmmService.sendGateInfo(gatePathStr);
                            DateAndTime gateDateAndTime = this.getNowTimeStamp();
                            gateOutputError = Collections.singletonList(status.getMessage());
                            gateOutputBuilder.setGatePath(gatePathStr).setCcapId(ccapId).setCopsGateState(status.getCopsGateState() + "/" + status.getCopsGateStateReason()).setCopsGateTimeInfo(status.getCopsGateTimeInfo()).setCopsGateUsageInfo(status.getCopsGateUsageInfo()).setCopsGateId(status.getCopsGateId()).setError(gateOutputError).setTimestamp(gateDateAndTime);
                            gateBuilder.setGateId(inputGateId).setGatePath(gatePathStr).setCcapId(ccapId).setCopsGateState(status.getCopsGateState() + "/" + status.getCopsGateStateReason()).setCopsGateTimeInfo(status.getCopsGateTimeInfo()).setCopsGateUsageInfo(status.getCopsGateUsageInfo()).setCopsGateId(status.getCopsGateId()).setError(gateOutputError).setTimestamp(gateDateAndTime);
                            this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIid, gateBuilder.build());
                            rpcResponse = gatePathStr + ": gate poll complete";
                        } else {
                            rpcResponse = ccapId + ": CCAP socket is down or client disconnected; gate poll not performed";
                        }
                    } else {
                        rpcResponse = gatePathStr + ": gate not active; gate poll not performed";
                    }
                }
            } else {
                InstanceIdentifier subIid = appIid.builder().child(Subscribers.class).child(Subscriber.class, (Identifier)new SubscriberKey(inputSubscriberId)).build();
                Subscriber sub = this.readSubscriberFromOperationalDatastore((InstanceIdentifier<Subscriber>)subIid);
                if (sub != null) {
                    subscriberId = sub.getSubscriberId();
                    List gateList = sub.getGates().getGate();
                    for (Gate gate : gateList) {
                        gateId = gate.getGateId();
                        InstanceIdentifier gateIid = subIid.builder().child(Gates.class).child(Gate.class, (Identifier)new GateKey(gateId)).build();
                        opsGate = this.readGateFromOperationalDatastore((InstanceIdentifier<Gate>)gateIid);
                        opsCopsGateId = opsGate.getCopsGateId();
                        gatePathStr = appKey.getAppId() + "/" + subscriberId + "/" + gateId;
                        if (!Objects.equals(opsCopsGateId, "") && !Objects.equals(opsCopsGateId, null)) {
                            ccapId = this.findCcapForSubscriberId(this.getInetAddress(subscriberId)).getCcapId();
                            PCMMService pcmmService = this.pcmmServiceMap.get(ccapId);
                            if (!pcmmService.getPcmmPdpSocket().booleanValue() && pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
                                PCMMService.GateSendStatus status = pcmmService.sendGateInfo(gatePathStr);
                                DateAndTime gateDateAndTime = this.getNowTimeStamp();
                                gateBuilder.setGateId(gateId).setGatePath(gatePathStr).setCcapId(ccapId).setCopsGateState(status.getCopsGateState() + "/" + status.getCopsGateStateReason()).setCopsGateTimeInfo(status.getCopsGateTimeInfo()).setCopsGateUsageInfo(status.getCopsGateUsageInfo()).setCopsGateId(status.getCopsGateId()).setError(gateOutputError).setTimestamp(gateDateAndTime);
                                this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIid, gateBuilder.build());
                                continue;
                            }
                            logger.info("qospollgates: {}: CCAP Cops socket is down or client disconnected; gate poll not performed", (Object)ccapId);
                            continue;
                        }
                        logger.info("qospollgates: {}: gate not active; gate poll not performed", (Object)gatePathStr);
                    }
                    rpcResponse = inputSubscriberId + "/: subscriber subtree poll in progress";
                } else {
                    rpcResponse = inputSubscriberId + "/: subscriber is not defined in the system, gate poll not performed";
                }
            }
        } else if (inputGateId != null) {
            gatePathStr = appKey.getAppId() + "/" + inputSubscriberId + "/" + inputGateId;
            rpcResponse = gatePathStr + ": Subscriber ID not provided; gate poll not performed";
        } else {
            PollAllGatesForApp pollAllGatesForApp = new PollAllGatesForApp(appIid, app);
            Thread t = new Thread(pollAllGatesForApp);
            t.start();
            rpcResponse = appKey.getAppId() + "/: gate subtree poll in progress";
        }
        DateAndTime rpcDateAndTime = this.getNowTimeStamp();
        QosPollGatesOutputBuilder outputBuilder = new QosPollGatesOutputBuilder().setTimestamp(rpcDateAndTime).setResponse(rpcResponse).setGate(gateOutputBuilder.build());
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)outputBuilder.build()).build());
    }

    private DateAndTime getNowTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        return new DateAndTime(dateFormat.format(new Date()));
    }

    private class PollAllGatesForApp
    implements Runnable {
        private InstanceIdentifier<App> appIid;
        private App app;

        private PollAllGatesForApp(InstanceIdentifier<App> appIid, App app) {
            this.app = app;
            this.appIid = appIid;
        }

        @Override
        public void run() {
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.poll.gates.output.GateBuilder gateOutputBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.qos.poll.gates.output.GateBuilder();
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder gateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder();
            AppKey appKey = (AppKey)InstanceIdentifier.keyOf(this.appIid);
            Subscribers subs = this.app.getSubscribers();
            logger.info("qospollgates subscribers: " + subs.toString());
            List subList = subs.getSubscriber();
            logger.info("qospollgates subList: " + subList.toString());
            for (Subscriber sub : subList) {
                String subscriberId = sub.getSubscriberId();
                InstanceIdentifier subIid = this.appIid.builder().child(Subscribers.class).child(Subscriber.class, (Identifier)new SubscriberKey(subscriberId)).build();
                List gateList = sub.getGates().getGate();
                for (Gate gate : gateList) {
                    String gateId = gate.getGateId();
                    InstanceIdentifier gateIid = subIid.builder().child(Gates.class).child(Gate.class, (Identifier)new GateKey(gateId)).build();
                    Gate opsGate = PacketcableProvider.this.readGateFromOperationalDatastore((InstanceIdentifier<Gate>)gateIid);
                    String opsCopsGateId = opsGate.getCopsGateId();
                    String gatePathStr = appKey.getAppId() + "/" + subscriberId + "/" + gateId;
                    if (!Objects.equals(opsCopsGateId, "") && !Objects.equals(opsCopsGateId, null)) {
                        String ccapId = PacketcableProvider.this.findCcapForSubscriberId(PacketcableProvider.this.getInetAddress(subscriberId)).getCcapId();
                        PCMMService pcmmService = (PCMMService)PacketcableProvider.this.pcmmServiceMap.get(ccapId);
                        if (!pcmmService.getPcmmPdpSocket().booleanValue() && pcmmService.getPcmmCcapClientIsConnected().booleanValue()) {
                            PCMMService.GateSendStatus status = pcmmService.sendGateInfo(gatePathStr);
                            DateAndTime gateDateAndTime = PacketcableProvider.this.getNowTimeStamp();
                            List<String> gateOutputError = Collections.singletonList(status.getMessage());
                            gateBuilder.setGateId(gateId).setGatePath(gatePathStr).setCcapId(ccapId).setCopsGateState(status.getCopsGateState() + "/" + status.getCopsGateStateReason()).setCopsGateTimeInfo(status.getCopsGateTimeInfo()).setCopsGateUsageInfo(status.getCopsGateUsageInfo()).setCopsGateId(status.getCopsGateId()).setError(gateOutputError).setTimestamp(gateDateAndTime);
                            PacketcableProvider.this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIid, gateBuilder.build());
                            continue;
                        }
                        logger.info("qospollgates: {}: CCAP socket is down or client disconnected; gate poll not performed", (Object)ccapId);
                        continue;
                    }
                    logger.info("qospollgates: {}: gate not active; gate poll not performed", (Object)gatePathStr);
                }
            }
        }
    }

    private class QosDataTreeChangeListener
    extends AbstractDataTreeChangeListener<Gate> {
        private final Set<InstanceIdentifier<Gate>> updateQueue;

        public QosDataTreeChangeListener() {
            super(Gate.class, new DataValidator(new QosValidatorProviderFactory().build()));
            this.updateQueue = Sets.newConcurrentHashSet();
        }

        @Override
        protected void handleCreatedData(DataTreeModification<Gate> change) {
            InstanceIdentifier gateIID = change.getRootPath().getRootIdentifier();
            Gate newGate = (Gate)change.getRootNode().getDataAfter();
            String newGatePathStr = this.makeGatePathString((InstanceIdentifier<Gate>)gateIID);
            InstanceIdentifier appIID = gateIID.firstIdentifierOf(App.class);
            this.logger.info("Registering App Routed RPC Path...");
            PacketcableProvider.this.routedRpcRegistration.registerPath(AppContext.class, (Path)appIID);
            InstanceIdentifier subscriberIID = gateIID.firstIdentifierOf(Subscriber.class);
            SubscriberKey subscriberKey = (SubscriberKey)InstanceIdentifier.keyOf((InstanceIdentifier)subscriberIID);
            InetAddress subscriberAddr = PacketcableProvider.this.getInetAddress(subscriberKey.getSubscriberId());
            if (subscriberAddr == null) {
                String msg = String.format("subscriberId must be a valid ipaddress: %s", subscriberKey.getSubscriberId());
                this.logger.error(msg);
                this.saveGateError((InstanceIdentifier<Gate>)gateIID, newGatePathStr, msg);
                return;
            }
            Ccap ccap = PacketcableProvider.this.findCcapForSubscriberId(subscriberAddr);
            if (ccap == null) {
                String msg = String.format("Unable to find Ccap for subscriber %s: @ %s", subscriberKey.getSubscriberId(), newGatePathStr);
                this.logger.error(msg);
                this.saveGateError((InstanceIdentifier<Gate>)gateIID, newGatePathStr, msg);
                return;
            }
            PCMMService pcmmService = (PCMMService)PacketcableProvider.this.pcmmServiceMap.get(ccap.getCcapId());
            if (pcmmService == null) {
                String msg = String.format("Unable to locate PCMM Service for CCAP: %s ; with subscriber: %s", ccap, subscriberKey.getSubscriberId());
                this.logger.error(msg);
                this.saveGateError((InstanceIdentifier<Gate>)gateIID, newGatePathStr, msg);
                return;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder gateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder();
            gateBuilder.setGateId(newGate.getGateId()).setGatePath(newGatePathStr).setCcapId(ccap.getCcapId()).setClassifiers(newGate.getClassifiers()).setGateSpec(newGate.getGateSpec()).setCopsGateState("").setCopsGateTimeInfo("").setCopsGateUsageInfo("");
            ServiceFlowDirection scnDirection = null;
            if (newGate.getTrafficProfile().getTrafficProfileChoice() instanceof ServiceClassNameChoice) {
                ServiceClassName scn = ((ServiceClassNameChoice)newGate.getTrafficProfile().getTrafficProfileChoice()).getServiceClassNameProfile().getServiceClassName();
                scnDirection = PacketcableProvider.this.findScnOnCcap(scn, ccap);
                if (scnDirection == null) {
                    String msg = String.format("SCN %s not found on CCAP %s for %s", scn, ccap.getCcapId(), newGatePathStr);
                    this.logger.error(msg);
                    this.saveGateError((InstanceIdentifier<Gate>)gateIID, newGatePathStr, msg);
                    return;
                }
                ServiceClassNameProfileBuilder scnBuilder = new ServiceClassNameProfileBuilder();
                scnBuilder.setServiceClassName(scn);
                ServiceClassNameProfile scnProfile = scnBuilder.build();
                ServiceClassNameChoiceBuilder scncBuilder = new ServiceClassNameChoiceBuilder();
                scncBuilder.setServiceClassNameProfile(scnProfile);
                ServiceClassNameChoice scnChoice = scncBuilder.build();
                TrafficProfileBuilder trafficProfileBuilder = new TrafficProfileBuilder();
                trafficProfileBuilder.setTrafficProfileChoice((TrafficProfileChoice)scnChoice);
                TrafficProfile trafficProfile = trafficProfileBuilder.build();
                gateBuilder.setTrafficProfile(trafficProfile);
            } else {
                gateBuilder.setTrafficProfile(newGate.getTrafficProfile());
            }
            GateSpecBuilder gateSpecBuilder = new GateSpecBuilder();
            gateSpecBuilder.setDirection(scnDirection);
            gateSpecBuilder.setDscpTosMask(newGate.getGateSpec().getDscpTosMask());
            gateSpecBuilder.setDscpTosOverwrite(newGate.getGateSpec().getDscpTosOverwrite());
            gateSpecBuilder.setSessionClassId(newGate.getGateSpec().getSessionClassId());
            gateSpecBuilder.setInactivityTimer(newGate.getGateSpec().getInactivityTimer());
            GateSpec gateSpec = gateSpecBuilder.build();
            gateBuilder.setGateSpec(gateSpec);
            gateBuilder.setTimestamp(PacketcableProvider.this.getNowTimeStamp());
            Gate requestGate = gateBuilder.build();
            PCMMService.GateSendStatus status = pcmmService.sendGateSet(newGatePathStr, subscriberAddr, requestGate);
            if (status.didSucceed()) {
                PacketcableProvider.this.gateMap.put(newGatePathStr, requestGate);
                PacketcableProvider.this.gateCcapMap.put(newGatePathStr, ccap.getCcapId());
                PCMMService.GateSendStatus infoStatus = pcmmService.sendGateInfo(newGatePathStr);
                if (infoStatus.didSucceed()) {
                    gateBuilder.setCopsGateState(infoStatus.getCopsGateState() + "/" + infoStatus.getCopsGateStateReason()).setCopsGateTimeInfo(infoStatus.getCopsGateTimeInfo()).setCopsGateUsageInfo(infoStatus.getCopsGateUsageInfo()).setCopsGateId(status.getCopsGateId());
                } else {
                    ArrayList<String> errors = new ArrayList<String>(2);
                    if (gateBuilder.getError() != null) {
                        errors.addAll(gateBuilder.getError());
                    }
                    errors.add(infoStatus.getMessage());
                    gateBuilder.setError(errors);
                }
            } else {
                gateBuilder.setError(Collections.singletonList(status.getMessage()));
            }
            Gate operationalGate = gateBuilder.build();
            PacketcableProvider.this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIID, operationalGate);
        }

        private void saveGateError(@Nonnull InstanceIdentifier<Gate> gateIID, @Nonnull String gatePathStr, @Nonnull String error) {
            Preconditions.checkNotNull(gateIID);
            Preconditions.checkNotNull((Object)error);
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder gateBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.GateBuilder();
            gateBuilder.setGateId(((GateKey)InstanceIdentifier.keyOf(gateIID)).getGateId()).setGatePath(gatePathStr).setCopsGateId("").setCopsGateState("N/A");
            gateBuilder.setError(Collections.singletonList(error));
            Gate operationalGate = gateBuilder.build();
            PacketcableProvider.this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, gateIID, operationalGate);
        }

        @Override
        protected void handleUpdatedData(DataTreeModification<Gate> change) {
            InstanceIdentifier gateIID = change.getRootPath().getRootIdentifier();
            if (this.updateQueue.contains(gateIID)) {
                this.updateQueue.remove(gateIID);
                return;
            }
            Gate updatedGate = (Gate)change.getRootNode().getDataAfter();
            this.updateQueue.add((InstanceIdentifier<Gate>)gateIID);
            PacketcableProvider.this.mdsalUtils.put(LogicalDatastoreType.CONFIGURATION, gateIID, updatedGate);
        }

        @Override
        protected void handleRemovedData(DataTreeModification<Gate> change) {
            InstanceIdentifier removedGateIID = change.getRootPath().getRootIdentifier();
            Gate newGate = (Gate)change.getRootNode().getDataBefore();
            PacketcableProvider.this.mdsalUtils.delete(LogicalDatastoreType.OPERATIONAL, removedGateIID);
            PacketcableProvider.this.executor.execute(new SubscriberCleaner((InstanceIdentifier<Gate>)removedGateIID));
            String gatePathStr = this.makeGatePathString((InstanceIdentifier<Gate>)removedGateIID);
            if (PacketcableProvider.this.gateMap.containsKey(gatePathStr)) {
                Gate thisGate = (Gate)PacketcableProvider.this.gateMap.remove(gatePathStr);
                String gateId = thisGate.getGateId();
                String ccapId = (String)PacketcableProvider.this.gateCcapMap.remove(gatePathStr);
                Ccap thisCcap = (Ccap)PacketcableProvider.this.ccapMap.get(ccapId);
                PCMMService service = (PCMMService)PacketcableProvider.this.pcmmServiceMap.get(thisCcap.getCcapId());
                if (service != null) {
                    service.sendGateDelete(gatePathStr);
                    this.logger.info("onDataChanged(): removed QoS gate {} for {}/{}/{}: ", new Object[]{gateId, ccapId, gatePathStr, thisGate});
                } else {
                    this.logger.warn("Unable to send to locate PCMMService to send gate delete message with CCAP - " + thisCcap);
                }
            }
        }

        @Override
        protected void handleInvalidData(DataTreeModification<Gate> change, ValidationException validationException) {
            PacketcableProvider.this.saveErrors(change, validationException);
        }

        private String makeGatePathString(InstanceIdentifier<Gate> iid) {
            InstanceIdentifier appIID = iid.firstIdentifierOf(App.class);
            AppKey appKey = (AppKey)InstanceIdentifier.keyOf((InstanceIdentifier)appIID);
            InstanceIdentifier subscriberIID = iid.firstIdentifierOf(Subscriber.class);
            SubscriberKey subscriberKey = (SubscriberKey)InstanceIdentifier.keyOf((InstanceIdentifier)subscriberIID);
            GateKey gateKey = (GateKey)InstanceIdentifier.keyOf(iid);
            return appKey.getAppId() + "/" + subscriberKey.getSubscriberId() + "/" + gateKey.getGateId();
        }
    }

    private class CcapsDataTreeChangeListener
    extends AbstractDataTreeChangeListener<Ccap> {
        private final Set<InstanceIdentifier<Ccap>> updateQueue;

        public CcapsDataTreeChangeListener() {
            super(Ccap.class, new DataValidator(new CcapsValidatorProviderFactory().build()));
            this.updateQueue = Sets.newConcurrentHashSet();
        }

        @Override
        protected void handleCreatedData(DataTreeModification<Ccap> change) {
            CcapBuilder responseCcapBuilder;
            Ccap ccap = (Ccap)change.getRootNode().getDataAfter();
            InstanceIdentifier iid = change.getRootPath().getRootIdentifier();
            if (PacketcableProvider.this.pcmmServiceMap.containsKey(ccap.getCcapId())) {
                this.logger.error("Already monitoring CCAP - " + ccap);
                return;
            }
            PCMMService pcmmService = new PCMMService(-32758, ccap);
            org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.attributes.ConnectionBuilder connectionBuilder = new org.opendaylight.yang.gen.v1.urn.packetcable.rev170224.ccap.attributes.ConnectionBuilder();
            String message = pcmmService.addCcap();
            if (message.contains("200 OK")) {
                PacketcableProvider.this.pcmmServiceMap.put(ccap.getCcapId(), pcmmService);
                PacketcableProvider.this.ccapMap.put(ccap.getCcapId(), ccap);
                PacketcableProvider.this.updateCcapMaps(ccap);
                this.logger.info("Created CCAP: {}/{} : {}", new Object[]{iid, ccap, message});
                this.logger.info("Created CCAP: {} : {}", (Object)iid, (Object)message);
                connectionBuilder.setConnected(Boolean.valueOf(true)).setError(Collections.emptyList());
            } else {
                this.logger.error("Create CCAP Failed: {} : {}", (Object)iid, (Object)message);
                connectionBuilder.setConnected(Boolean.valueOf(false)).setError(Collections.singletonList(message));
            }
            this.logger.info("Registering CCAP Routed RPC Path...");
            PacketcableProvider.this.routedRpcRegistration.registerPath(CcapContext.class, (Path)iid);
            Optional optionalCcap = PacketcableProvider.this.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, iid);
            if (optionalCcap.isPresent()) {
                responseCcapBuilder = new CcapBuilder((Ccap)optionalCcap.get());
            } else {
                responseCcapBuilder = new CcapBuilder();
                responseCcapBuilder.setCcapId(ccap.getCcapId());
            }
            responseCcapBuilder.setConnection(connectionBuilder.build());
            PacketcableProvider.this.mdsalUtils.put(LogicalDatastoreType.OPERATIONAL, iid, responseCcapBuilder.build());
        }

        @Override
        protected void handleUpdatedData(DataTreeModification<Ccap> change) {
            InstanceIdentifier iid = change.getRootPath().getRootIdentifier();
            if (this.updateQueue.contains(iid)) {
                this.updateQueue.remove(iid);
                return;
            }
            Ccap updatedCcap = (Ccap)change.getRootNode().getDataAfter();
            this.logger.info("Registering CCAP Routed RPC Path...");
            PacketcableProvider.this.routedRpcRegistration.registerPath(CcapContext.class, (Path)iid);
            this.updateQueue.add((InstanceIdentifier<Ccap>)iid);
            PacketcableProvider.this.mdsalUtils.put(LogicalDatastoreType.CONFIGURATION, iid, updatedCcap);
        }

        @Override
        protected void handleRemovedData(DataTreeModification<Ccap> change) {
            InstanceIdentifier iid = change.getRootPath().getRootIdentifier();
            Ccap nukedCcap = (Ccap)change.getRootNode().getDataBefore();
            PacketcableProvider.this.removeCcapFromAllMaps(nukedCcap);
            this.logger.info("Un-Registering CCAP Routed RPC Path...");
            PacketcableProvider.this.routedRpcRegistration.unregisterPath(CcapContext.class, (Path)iid);
            PacketcableProvider.this.mdsalUtils.delete(LogicalDatastoreType.OPERATIONAL, iid);
            PacketcableProvider.this.executor.execute(new CcapsCleaner(iid));
        }

        @Override
        protected void handleInvalidData(DataTreeModification<Ccap> change, ValidationException validationException) {
            PacketcableProvider.this.saveErrors(change, validationException);
        }
    }

    private abstract class AbstractCleaner<T extends DataObject>
    implements Runnable {
        final InstanceIdentifier<?> removedIID;
        final Class<T> tClass;
        final LogicalDatastoreType datastoreType;

        public AbstractCleaner(InstanceIdentifier<?> removedIID, Class<T> tClass, LogicalDatastoreType datastoreType) {
            this.removedIID = (InstanceIdentifier)Preconditions.checkNotNull(removedIID);
            this.tClass = (Class)Preconditions.checkNotNull(tClass);
            this.datastoreType = (LogicalDatastoreType)Preconditions.checkNotNull((Object)datastoreType);
        }

        @Override
        public void run() {
            InstanceIdentifier tIID = this.removedIID.firstIdentifierOf(this.tClass);
            if (tIID != null) {
                Optional optional = PacketcableProvider.this.mdsalUtils.read(this.datastoreType, tIID);
                if (optional.isPresent() && this.shouldClean((DataObject)optional.get())) {
                    if (PacketcableProvider.this.mdsalUtils.delete(this.datastoreType, tIID)) {
                        this.postRemove(tIID);
                    } else {
                        this.removeFailed(tIID);
                    }
                }
            } else {
                logger.error("Expected to find InstanceIdentifier<{}> but was not found: {}", (Object)this.tClass.getSimpleName(), this.removedIID);
            }
        }

        abstract boolean shouldClean(T var1);

        void postRemove(InstanceIdentifier<T> tIID) {
        }

        void removeFailed(InstanceIdentifier<T> tIID) {
            logger.error("Failed to remove {}", tIID);
        }
    }

    private class AppsCleaner
    extends AbstractCleaner<Apps> {
        public AppsCleaner(InstanceIdentifier<App> removedAppIID) {
            super(removedAppIID, Apps.class, LogicalDatastoreType.OPERATIONAL);
        }

        @Override
        protected boolean shouldClean(Apps apps) {
            return apps.getApp().isEmpty();
        }
    }

    private class AppCleaner
    extends AbstractCleaner<App> {
        public AppCleaner(InstanceIdentifier<Subscriber> removedSubscriberIID) {
            super(removedSubscriberIID, App.class, LogicalDatastoreType.OPERATIONAL);
        }

        @Override
        boolean shouldClean(App app) {
            return app.getSubscribers().getSubscriber().isEmpty();
        }

        @Override
        void postRemove(InstanceIdentifier<App> appIID) {
            logger.info("Un-Registering App Routed RPC Path...");
            PacketcableProvider.this.routedRpcRegistration.unregisterPath(AppContext.class, appIID);
            PacketcableProvider.this.executor.execute(new AppsCleaner(appIID));
        }
    }

    private class SubscriberCleaner
    extends AbstractCleaner<Subscriber> {
        public SubscriberCleaner(InstanceIdentifier<Gate> removedGateIID) {
            super(removedGateIID, Subscriber.class, LogicalDatastoreType.OPERATIONAL);
        }

        @Override
        protected boolean shouldClean(Subscriber subscriber) {
            return subscriber.getGates().getGate().isEmpty();
        }

        @Override
        protected void postRemove(InstanceIdentifier<Subscriber> subscriberIID) {
            PacketcableProvider.this.executor.execute(new AppCleaner(subscriberIID));
        }
    }

    private class CcapsCleaner
    extends AbstractCleaner<Ccaps> {
        public CcapsCleaner(InstanceIdentifier<?> removedIID) {
            super(removedIID, Ccaps.class, LogicalDatastoreType.OPERATIONAL);
        }

        @Override
        protected boolean shouldClean(Ccaps ccaps) {
            return ccaps.getCcap().isEmpty();
        }
    }
}

