/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.packetcable.provider.validation.DataValidator;
import org.opendaylight.controller.packetcable.provider.validation.ValidationException;
import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataTreeChangeListener<T extends DataObject>
implements DataTreeChangeListener<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<T> tClass;
    private final DataValidator dataValidator;

    public AbstractDataTreeChangeListener(Class<T> tClass, DataValidator dataValidator) {
        this.tClass = (Class)Preconditions.checkNotNull(tClass);
        this.dataValidator = (DataValidator)Preconditions.checkNotNull((Object)dataValidator);
    }

    private ValidationException validateData(DataTreeModification<T> change) {
        InstanceIdentifier iid = change.getRootPath().getRootIdentifier();
        try {
            this.dataValidator.validate(iid, change.getRootNode().getDataAfter(), Validator.Extent.NODE_AND_SUBTREE);
        }
        catch (ValidationException e) {
            this.logger.debug("invalid data: {}", (Object)change.getRootNode().getDataAfter(), (Object)e);
            return e;
        }
        return null;
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<T>> changes) {
        HashMap exceptionMap = Maps.newHashMap();
        for (DataTreeModification<T> change : changes) {
            DataObjectModification root = change.getRootNode();
            switch (root.getModificationType()) {
                case SUBTREE_MODIFIED: {
                    ValidationException validationException;
                    try {
                        validationException = this.validateData(change);
                        if (validationException != null) {
                            this.handleInvalidData(change, validationException);
                            break;
                        }
                        this.handleUpdatedData(change);
                    }
                    catch (NoSuchElementException e) {
                        this.logger.error("Unable to find validator for data: {}", (Object)change.getRootNode().getDataAfter(), (Object)e);
                    }
                    break;
                }
                case WRITE: {
                    ValidationException validationException;
                    try {
                        boolean update;
                        validationException = this.validateData(change);
                        if (validationException != null) {
                            this.handleInvalidData(change, validationException);
                            break;
                        }
                        boolean bl = update = change.getRootNode().getDataBefore() != null;
                        if (update) {
                            this.handleUpdatedData(change);
                            break;
                        }
                        this.handleCreatedData(change);
                    }
                    catch (NoSuchElementException e) {
                        this.logger.error("Unable to find validator for data: {}", (Object)change.getRootNode().getDataAfter(), (Object)e);
                    }
                    break;
                }
                case DELETE: {
                    this.handleRemovedData(change);
                    break;
                }
            }
        }
    }

    protected abstract void handleCreatedData(DataTreeModification<T> var1);

    protected abstract void handleUpdatedData(DataTreeModification<T> var1);

    protected abstract void handleRemovedData(DataTreeModification<T> var1);

    protected abstract void handleInvalidData(DataTreeModification<T> var1, ValidationException var2);
}

