/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier.ClassifierChoiceValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.ClassifierContainer;

public class ClassifierContainerValidator
extends AbstractValidator<ClassifierContainer> {
    private static final String CLASSIFIER_ID = "classifier-container.classifier-id";
    private static final String CLASSIFIER_CHOICE = "classifier-container.classifier-choice";
    private final ClassifierChoiceValidator classifierChoiceValidator = new ClassifierChoiceValidator();

    @Override
    protected void doValidate(ClassifierContainer container, Validator.Extent extent) {
        if (container == null) {
            this.getErrorMessages().add("classifer-container must exist");
            return;
        }
        this.mustExist(container.getClassifierChoice(), CLASSIFIER_CHOICE);
        this.mustExist(container.getClassifierId(), CLASSIFIER_ID);
        if (extent == Validator.Extent.NODE_AND_SUBTREE) {
            this.validateChild(this.classifierChoiceValidator, container.getClassifierChoice());
        }
    }
}

