/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.GatesValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gates.apps.app.subscribers.Subscriber;

public class SubscriberValidator
extends AbstractValidator<Subscriber> {
    private static final String SUBSCRIBER_ID = "subscriber.subscriberId";
    private static final String GATES = "subscriber.gates";
    private final GatesValidator gatesValidator = new GatesValidator();

    @Override
    protected void doValidate(Subscriber subscriber, Validator.Extent extent) {
        if (subscriber == null) {
            this.getErrorMessages().add("subscriber must exist");
            return;
        }
        this.mustExist(subscriber.getSubscriberId(), SUBSCRIBER_ID);
        this.mustExist(subscriber.getGates(), GATES);
        if (extent == Validator.Extent.NODE_AND_SUBTREE) {
            this.validateChild(this.gatesValidator, subscriber.getGates());
        }
    }
}

