/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.TrafficProfileValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.qos.classifier.ClassifiersValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.Gate;

public class GateValidator
extends AbstractValidator<Gate> {
    private static final String GATE_ID = "gate.gateId";
    private static final String GATE_SPEC = "gate.gate-spec";
    private static final String TRAFFIC_PROFILE = "gate.traffic-profile";
    private static final String CLASSIFIERS = "gate.classifiers";
    private final TrafficProfileValidator trafficProfileValidator = new TrafficProfileValidator();
    private final ClassifiersValidator classifiersValidator = new ClassifiersValidator();

    @Override
    protected void doValidate(Gate gate, Validator.Extent extent) {
        if (gate == null) {
            this.getErrorMessages().add("gate must exist");
            return;
        }
        this.mustExist(gate.getGateId(), GATE_ID);
        this.mustExist(gate.getClassifiers(), CLASSIFIERS);
        this.mustExist(gate.getTrafficProfile(), TRAFFIC_PROFILE);
        if (extent == Validator.Extent.NODE_AND_SUBTREE) {
            this.validateChild(this.trafficProfileValidator, gate.getTrafficProfile());
            this.validateChild(this.classifiersValidator, gate.getClassifiers());
        }
    }
}

