/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation.impl.validators.ccaps;

import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.AbstractValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.ccaps.AmIdValidator;
import org.opendaylight.controller.packetcable.provider.validation.impl.validators.ccaps.ConnectionValidator;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap;

public class CcapValidator
extends AbstractValidator<Ccap> {
    private static final String CCAPID = "ccap.ccapid";
    private static final String CONNECTION = "ccap.connection";
    private static final String AM_ID = "ccap.amId";
    private static final String UP_STREAM_SCNS = "ccap.upstream-scns";
    private static final String DOWN_STREAM_SCNS = "ccap.downstream-scns";
    private final AmIdValidator amIdValidator = new AmIdValidator();
    private final ConnectionValidator connectionValidator = new ConnectionValidator();

    @Override
    protected void doValidate(Ccap ccap, Validator.Extent extent) {
        if (ccap == null) {
            this.getErrorMessages().add("ccap must exist");
            return;
        }
        this.mustExist(ccap.getCcapId(), CCAPID);
        this.mustExistAndNotBeEmpty(ccap.getUpstreamScns(), UP_STREAM_SCNS);
        this.mustExistAndNotBeEmpty(ccap.getDownstreamScns(), DOWN_STREAM_SCNS);
        if (extent == Validator.Extent.NODE_AND_SUBTREE) {
            this.validateChild(this.amIdValidator, ccap.getAmId());
            this.validateChild(this.connectionValidator, ccap.getConnection());
        } else {
            this.mustExist(ccap.getAmId(), AM_ID);
            this.mustExist(ccap.getConnection(), CONNECTION);
        }
    }
}

