/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.opendaylight.controller.packetcable.provider.validation.ValidationException;
import org.opendaylight.controller.packetcable.provider.validation.Validator;
import org.opendaylight.controller.packetcable.provider.validation.ValidatorProvider;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValidator {
    private static final Logger logger = LoggerFactory.getLogger(DataValidator.class);
    private final ValidatorProvider validatorProvider;

    public DataValidator(@Nonnull ValidatorProvider validatorProvider) {
        this.validatorProvider = (ValidatorProvider)Preconditions.checkNotNull((Object)validatorProvider);
    }

    public Map<InstanceIdentifier<?>, ValidationException> validate(@Nonnull Map<InstanceIdentifier<?>, DataObject> dataObjectMap, @Nonnull Validator.Extent extent) {
        Preconditions.checkNotNull(dataObjectMap);
        HashMap exceptionMap = Maps.newHashMap();
        for (Map.Entry<InstanceIdentifier<?>, DataObject> entry : dataObjectMap.entrySet()) {
            InstanceIdentifier<?> iid = entry.getKey();
            DataObject data = entry.getValue();
            try {
                this.validate(iid, data, extent);
            }
            catch (ValidationException e) {
                exceptionMap.put(iid, e);
                logger.debug("invalid data: {}", (Object)data, (Object)e);
            }
            catch (NoSuchElementException e) {
                logger.error("Unable to find validator for data: {}", (Object)data, (Object)e);
            }
        }
        return exceptionMap;
    }

    public void validate(@Nonnull InstanceIdentifier<?> iid, @Nonnull DataObject dataObject, @Nonnull Validator.Extent extent) throws ValidationException {
        Preconditions.checkNotNull(iid);
        Preconditions.checkNotNull((Object)dataObject);
        this.validatorProvider.validate(iid.getTargetType(), dataObject, extent);
    }

    public <T extends DataObject> Map<InstanceIdentifier<T>, ValidationException> validateOneType(@Nonnull Map<InstanceIdentifier<T>, T> dataObjectMap, @Nonnull Validator.Extent extent) {
        Preconditions.checkNotNull(dataObjectMap);
        HashMap exceptionMap = Maps.newHashMap();
        for (Map.Entry<InstanceIdentifier<T>, T> entry : dataObjectMap.entrySet()) {
            InstanceIdentifier<T> iid = entry.getKey();
            DataObject data = (DataObject)entry.getValue();
            try {
                this.validate(iid, data, extent);
            }
            catch (ValidationException e) {
                exceptionMap.put(iid, e);
                logger.debug("invalid data: {}", (Object)data, (Object)e);
            }
            catch (NoSuchElementException e) {
                logger.error("Unable to find validator for data: {}", (Object)data, (Object)e);
            }
        }
        return exceptionMap;
    }
}

