/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Subnet {
    private static final int MIN_MASK_BITS = 0;
    private static final int MAX_MASK_BITS_V4 = 32;
    private static final int MAX_MASK_BITS_V6 = 128;
    private final int prefixLen;
    private final BigInteger mask;
    private final BigInteger routingPrefix;
    private final int addressByteCount;

    public Subnet(@Nonnull InetAddress subnetAddress, int prefixLength) {
        Preconditions.checkNotNull((Object)subnetAddress, (Object)"subnetAddress can not be null");
        int maxMaskBits = subnetAddress instanceof Inet4Address ? 32 : 128;
        Preconditions.checkArgument((prefixLength >= 0 && prefixLength <= maxMaskBits ? 1 : 0) != 0, (String)"The prefixLength must be in range [%s..%s] but was %s", (Object[])new Object[]{0, maxMaskBits, prefixLength});
        this.prefixLen = prefixLength;
        this.addressByteCount = subnetAddress.getAddress().length;
        this.mask = BigInteger.valueOf(-1L).shiftLeft(this.addressByteCount * 8 - prefixLength);
        this.routingPrefix = new BigInteger(subnetAddress.getAddress()).and(this.mask);
    }

    public Subnet(@Nonnull InetAddress subnetAddress, @Nullable InetAddress subnetMask) {
        this(subnetAddress, Subnet.maskToPrefixLen(subnetAddress, subnetMask));
    }

    private static int maskToPrefixLen(@Nonnull InetAddress subnetAddress, @Nullable InetAddress subnetMask) {
        Preconditions.checkNotNull((Object)subnetAddress, (Object)"subnetAddress can not be null");
        if (subnetMask == null) {
            return subnetAddress instanceof Inet4Address ? 32 : 128;
        }
        Preconditions.checkArgument((boolean)subnetAddress.getClass().equals(subnetMask.getClass()));
        BigInteger m = new BigInteger(subnetMask.getAddress());
        BigInteger allOnes = BigInteger.valueOf(-1L);
        int rightMostBit = m.getLowestSetBit();
        BigInteger validSubnet = allOnes.shiftLeft(rightMostBit);
        Preconditions.checkArgument((boolean)validSubnet.equals(m), (String)"Subnet should have contiguous prefix bits, mask: %s(%s)", (Object[])new Object[]{subnetMask});
        return subnetAddress instanceof Inet4Address ? 32 - rightMostBit : 128 - rightMostBit;
    }

    public static Subnet createInstance(@Nonnull String addressAndSubnetStr) throws UnknownHostException {
        String[] stringArr = addressAndSubnetStr.split("/");
        if (2 > stringArr.length) {
            return new Subnet(InetAddress.getByName(stringArr[0]), null);
        }
        if (stringArr[1].contains(".") || stringArr[1].contains(":")) {
            return new Subnet(InetAddress.getByName(stringArr[0]), InetAddress.getByName(stringArr[1]));
        }
        return new Subnet(InetAddress.getByName(stringArr[0]), Integer.parseInt(stringArr[1]));
    }

    public int getPrefixLen() {
        return this.prefixLen;
    }

    public boolean isInNet(@Nonnull InetAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        byte[] bytesAddress = address.getAddress();
        if (this.addressByteCount != bytesAddress.length) {
            return false;
        }
        BigInteger bigAddress = new BigInteger(bytesAddress);
        return bigAddress.and(this.mask).equals(this.routingPrefix);
    }

    public final boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return this.prefixLen == other.prefixLen && this.routingPrefix.equals(other.routingPrefix) && this.mask.equals(other.mask) && this.addressByteCount == other.addressByteCount;
    }

    public final int hashCode() {
        return new HashCodeBuilder(997, 311).append(this.prefixLen).append((Object)this.mask).append((Object)this.routingPrefix).append(this.addressByteCount).build();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Subnet.bigInteger2IpString(buf, this.routingPrefix, this.addressByteCount);
        buf.append('/');
        Subnet.bigInteger2IpString(buf, this.mask, this.addressByteCount);
        return buf.toString();
    }

    private static void bigInteger2IpString(StringBuilder buf, BigInteger bigInteger, int displayBytes) {
        boolean isIPv4 = 4 == displayBytes;
        byte[] bytes = bigInteger.toByteArray();
        int diffLen = displayBytes - bytes.length;
        int fillByte = 0 > bytes[0] ? -1 : 0;
        for (int i = 0; i < displayBytes; ++i) {
            if (0 < i && !isIPv4 && i % 2 == 0) {
                buf.append(':');
            } else if (0 < i && isIPv4) {
                buf.append('.');
            }
            int integer = 0xFF & (i < diffLen ? fillByte : bytes[i - diffLen]);
            if (!isIPv4 && 16 > integer) {
                buf.append('0');
            }
            buf.append(isIPv4 ? Integer.valueOf(integer) : Integer.toHexString(integer));
        }
    }
}

