/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.packetcable.provider.PCMMGateReqBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gates.apps.app.subscribers.subscriber.gates.Gate;
import org.pcmm.PCMMPdpAgent;
import org.pcmm.PCMMPdpDataProcess;
import org.pcmm.PCMMPdpMsgSender;
import org.pcmm.gates.IGateState;
import org.pcmm.gates.IPCMMGate;
import org.pcmm.gates.ITransactionID;
import org.pcmm.gates.impl.PCMMGateReq;
import org.pcmm.gates.impl.TransactionID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umu.cops.prpdp.COPSPdpException;
import org.umu.cops.stack.COPSError;

@ThreadSafe
public class PCMMService {
    private final Logger logger = LoggerFactory.getLogger(PCMMService.class);
    private final Ccap ccap;
    private final IpAddress ipAddr;
    private final PortNumber portNum;
    protected final CcapClient ccapClient;
    protected Map<String, PCMMGateReq> gateRequests = Maps.newConcurrentMap();
    private final short clientType;

    public PCMMService(short clientType, Ccap ccap) {
        this.clientType = clientType;
        this.ccap = ccap;
        this.ipAddr = ccap.getConnection().getIpAddress();
        this.portNum = ccap.getConnection().getPort();
        this.ccapClient = new CcapClient(this.ipAddr, this.portNum);
        this.logger.info("Attempting to add CCAP with ID {} @ {}:{}", new Object[]{ccap.getCcapId(), this.ipAddr.getIpv4Address().getValue(), this.portNum.getValue()});
    }

    public void disconect() {
        this.ccapClient.disconnect();
    }

    public String addCcap() {
        this.ccapClient.connect();
        if (this.ccapClient.isConnected.booleanValue()) {
            this.logger.info("Connected to CCAP with ID - " + this.ccap.getCcapId());
            return String.format("200 OK - CCAP %s connected @ %s:%d", this.ccap.getCcapId(), this.ipAddr.getIpv4Address().getValue(), this.portNum.getValue());
        }
        return String.format("404 Not Found - CCAP %s failed to connect @ %s:%d - %s", this.ccap.getCcapId(), this.ipAddr.getIpv4Address().getValue(), this.portNum.getValue(), this.ccapClient.errMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GateSendStatus sendGateSet(String gatePathStr, InetAddress subId, Gate qosGate, ServiceFlowDirection scnDir) {
        GateSendStatus status = new GateSendStatus();
        this.logger.info("Sending gate to CCAP with ID - " + this.ccap.getCcapId());
        PCMMGateReqBuilder gateBuilder = new PCMMGateReqBuilder();
        gateBuilder.setAmId(this.ccap.getAmId());
        gateBuilder.setSubscriberId(subId);
        ServiceClassName scn = qosGate.getTrafficProfile().getServiceClassName();
        if (scn != null) {
            gateBuilder.setGateSpec(qosGate.getGateSpec(), scnDir);
        } else {
            gateBuilder.setGateSpec(qosGate.getGateSpec(), null);
        }
        gateBuilder.setTrafficProfile(qosGate.getTrafficProfile());
        gateBuilder.setClassifiers(qosGate.getClassifiers().getClassifierContainer());
        PCMMGateReq gateReq = gateBuilder.build();
        if (this.gateRequests.get(gatePathStr) == null) {
            this.gateRequests.put(gatePathStr, gateReq);
            this.ccapClient.sendGateSet(gateReq);
            try {
                PCMMGateReq pCMMGateReq = gateReq;
                synchronized (pCMMGateReq) {
                    this.logger.info("Waiting 5000ms for gate request to be updated");
                    gateReq.wait(5000L);
                    this.logger.debug("Gate request error - " + gateReq.getError());
                    this.logger.debug("Gate request ID - " + gateReq.getGateID());
                }
            }
            catch (Exception e) {
                this.logger.error("PCMMService: sendGateSet(): gate response timeout exceeded for " + gatePathStr + '/' + gateReq, (Throwable)e);
                status.setDidSucceed(false);
                status.setMessage(String.format("408 Request Timeout - gate response timeout exceeded for %s/%s", this.ccap.getCcapId(), gatePathStr));
                return status;
            }
            if (gateReq.getError() != null) {
                this.gateRequests.remove(gatePathStr);
                status.setDidSucceed(false);
                status.setMessage(String.format("404 Not Found - sendGateSet for %s/%s returned error - %s", this.ccap.getCcapId(), gatePathStr, gateReq.getError().toString()));
                this.logger.error("PCMMService: sendGateSet(): returned error: {}", (Object)gateReq.getError().toString());
            } else if (gateReq.getGateID() != null) {
                status.setDidSucceed(true);
                status.setCopsGateId(String.format("%08x", gateReq.getGateID().getGateID()));
                status.setMessage(String.format("200 OK - sendGateSet for %s/%s returned GateId %08x", this.ccap.getCcapId(), gatePathStr, gateReq.getGateID().getGateID()));
                this.logger.info(String.format("PCMMService: sendGateSet(): returned GateId %08x: ", gateReq.getGateID().getGateID()));
            } else {
                status.setDidSucceed(false);
                status.setMessage(String.format("404 Not Found - sendGateSet for %s/%s no gateId returned", this.ccap.getCcapId(), gatePathStr));
                this.logger.info("PCMMService: sendGateSet(): no gateId returned:");
            }
        } else {
            this.logger.info("PCMMService: sendGateSet(): no gateId returned:");
            status.setMessage(String.format("404 Not Found - sendGateSet for %s/%s already exists", this.ccap.getCcapId(), gatePathStr));
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean sendGateDelete(String gatePathStr) {
        this.logger.info("sendGateDelete() - " + this.ccap);
        PCMMGateReq gateReq = this.gateRequests.remove(gatePathStr);
        if (gateReq != null) {
            this.ccapClient.sendGateDelete(gateReq);
            try {
                PCMMGateReq pCMMGateReq = gateReq;
                synchronized (pCMMGateReq) {
                    gateReq.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                this.logger.error("PCMMService: sendGateDelete(): gate response timeout exceeded for {}/{}", (Object)gatePathStr, (Object)gateReq);
            }
            if (gateReq.getError() != null) {
                this.logger.warn("PCMMService: sendGateDelete(): returned error: {}", (Object)gateReq.getError().toString());
                return false;
            }
            if (gateReq.getGateID() != null) {
                this.logger.info(String.format("PCMMService: sendGateDelete(): deleted GateId %08x: ", gateReq.getGateID().getGateID()));
            } else {
                this.logger.error("PCMMService: sendGateDelete(): deleted but no gateId returned");
            }
            return true;
        }
        this.logger.warn("Attempt to delete non-existent gate with path - " + gatePathStr);
        return false;
    }

    public Boolean getPcmmPdpSocket() {
        try {
            return this.ccapClient.pcmmPdp.getSocket().isClosed();
        }
        catch (Exception e) {
            this.logger.error("getPcmmPdpSocket: {} FAILED: {}", (Object)this.ccapClient, (Object)e.getMessage());
            return true;
        }
    }

    public Boolean getPcmmCcapClientIsConnected() {
        try {
            return this.ccapClient.isConnected;
        }
        catch (Exception e) {
            this.logger.error("getPcmmCcapClientIsConnected: {} FAILED: {}", (Object)this.ccapClient, (Object)e.getMessage());
            return false;
        }
    }

    public String getPcmmCcapClientConnectErrMsg() {
        try {
            return this.ccapClient.errMessage;
        }
        catch (Exception e) {
            this.logger.error("getPcmmCcapClientIsConnected: {} FAILED: {}", (Object)this.ccapClient, (Object)e.getMessage());
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GateSendStatus sendGateInfo(String gatePathStr) {
        this.logger.info("sendGateInfo() - " + this.ccap);
        GateSendStatus status = new GateSendStatus();
        PCMMGateReq gateReq = this.gateRequests.get(gatePathStr);
        Boolean socketIsClosed = this.getPcmmPdpSocket();
        if (gateReq != null && !socketIsClosed.booleanValue()) {
            gateReq.setTransactionID((ITransactionID)new TransactionID(gateReq.getTransactionID().getTransactionIdentifier(), ITransactionID.GateCommandType.GATE_INFO));
            this.ccapClient.sendGateInfo(gateReq);
            try {
                PCMMGateReq pCMMGateReq = gateReq;
                synchronized (pCMMGateReq) {
                    this.logger.info("Waiting 5000ms for gate request to be updated");
                    gateReq.wait(5000L);
                    this.logger.debug("Gate request error - " + gateReq.getError());
                    this.logger.debug("Gate request ID - " + gateReq.getGateID());
                }
            }
            catch (InterruptedException e) {
                status.setDidSucceed(false);
                status.setMessage(String.format("Gate-Info Request Timeout for %s", this.ccap.getCcapId()));
                return status;
            }
            if (gateReq.getError() == null) {
                if (gateReq.getGateID() != null) {
                    status.setDidSucceed(true);
                    status.setCopsGateId(String.format("%08x", gateReq.getGateID().getGateID()));
                    IGateState gateState = gateReq.getGateState();
                    status.setCopsGateState(gateState.getGateState().toString());
                    status.setCopsGateStateReason(gateState.getGateStateReason().toString());
                    status.setCopsGateTimeInfo(String.format("%d", gateReq.getGateTimeInfo().getGateTimeInfo()));
                    status.setCopsGateUsageInfo(String.format("%d", gateReq.getGateUsageInfo().getGateUsageInfo()));
                    this.logger.info(String.format("PCMMService: sendGateInfo(): returned GateId %08x: ", gateReq.getGateID().getGateID()));
                } else {
                    status.setDidSucceed(false);
                    status.setMessage(String.format("404 Not Found - sendGateInfo for %s/%s no gateId returned", this.ccap.getCcapId(), gatePathStr));
                    this.logger.info("PCMMService: sendGateInfo(): no gateId returned:");
                }
                return status;
            }
        } else {
            status.setDidSucceed(false);
            if (socketIsClosed.booleanValue()) {
                status.setMessage(String.format("%s: CCAP Cops Socket is closed", this.ccap.getCcapId()));
            } else {
                status.setMessage(String.format("Attempt to get info of non-existent gate with path - " + gatePathStr, new Object[0]));
            }
            return status;
        }
        status.setDidSucceed(false);
        status.setMessage(String.format("%s reports '%s'", this.ccap.getCcapId(), gateReq.getError().toString()));
        this.logger.error("PCMMService: sendGateInfo(): returned error: {}", (Object)gateReq.getError().toString());
        return status;
    }

    protected class CcapClient {
        public final PCMMPdpDataProcess pcmmProcess;
        public final PCMMPdpAgent pcmmPdp;
        private final String ipv4;
        private final Integer port;
        protected transient PCMMPdpMsgSender pcmmSender;
        private transient Boolean isConnected = false;
        private transient String errMessage = null;

        public CcapClient(IpAddress ccapIp, PortNumber portNum) {
            this.ipv4 = ccapIp.getIpv4Address().getValue();
            this.port = portNum != null ? portNum.getValue() : Integer.valueOf(3918);
            this.pcmmProcess = null;
            this.pcmmPdp = new PCMMPdpAgent(this.ipv4, this.port.intValue(), PCMMService.this.clientType, this.pcmmProcess);
        }

        public void connect() {
            PCMMService.this.logger.info("Attempting to connect to host: " + this.ipv4 + " port: " + this.port);
            this.errMessage = null;
            try {
                this.pcmmPdp.connect();
                this.pcmmSender = new PCMMPdpMsgSender(PCMMService.this.clientType, this.pcmmPdp.getClientHandle(), this.pcmmPdp.getSocket());
                this.isConnected = true;
            }
            catch (Exception e) {
                this.isConnected = false;
                PCMMService.this.logger.error("Failed to connect to host: " + this.ipv4 + " port: " + this.port, (Throwable)e);
                this.errMessage = e.getMessage();
            }
        }

        public void disconnect() {
            PCMMService.this.logger.info("CcapClient: disconnect(): {}:{}", (Object)this.ipv4, (Object)this.port);
            this.pcmmPdp.disconnect(new COPSError(COPSError.ErrorTypes.SHUTTING_DOWN, COPSError.ErrorTypes.NA));
            this.isConnected = false;
        }

        public Boolean sendGateSet(PCMMGateReq gateReq) {
            PCMMService.this.logger.info("CcapClient: sendGateSet(): {}:{} => {}", new Object[]{this.ipv4, this.port, gateReq});
            try {
                this.pcmmSender.sendGateSet((IPCMMGate)gateReq);
            }
            catch (COPSPdpException e) {
                PCMMService.this.logger.error("CcapClient: sendGateSet(): {}:{} => {} FAILED:", new Object[]{this.ipv4, this.port, gateReq, e});
            }
            gateReq.setGateID(this.pcmmSender.getGateID());
            return true;
        }

        public Boolean sendGateDelete(PCMMGateReq gateReq) {
            PCMMService.this.logger.info("CcapClient: sendGateDelete(): {}:{} => {}", new Object[]{this.ipv4, this.port, gateReq});
            try {
                this.pcmmSender.sendGateDelete((IPCMMGate)gateReq);
            }
            catch (COPSPdpException e) {
                PCMMService.this.logger.error("CcapClient: sendGateDelete(): {}:{} => {} FAILED: {}", new Object[]{this.ipv4, this.port, gateReq, e.getMessage()});
            }
            return true;
        }

        public Boolean sendGateInfo(PCMMGateReq gateReq) {
            PCMMService.this.logger.info("CcapClient: sendGateInfo(): {}:{} => {}", (Object)this.ipv4, (Object)this.port);
            try {
                this.pcmmSender.sendGateInfo((IPCMMGate)gateReq);
            }
            catch (COPSPdpException e) {
                PCMMService.this.logger.error("CcapClient: sendGateInfo(): {}:{} => {} FAILED: {}", new Object[]{this.ipv4, this.port, e.getMessage()});
            }
            return true;
        }
    }

    public class GateSendStatus {
        private boolean didSucceed = false;
        private String message = "";
        private String copsGateId = "";
        private String copsGateState = "";
        private String copsGateStateReason = "";
        private String copsGateTimeInfo = "";
        private String copsGateUsageInfo = "";

        public boolean didSucceed() {
            return this.didSucceed;
        }

        void setDidSucceed(boolean didSucceed) {
            this.didSucceed = didSucceed;
        }

        public String getMessage() {
            return this.message;
        }

        void setMessage(String message) {
            this.message = message;
        }

        public String getCopsGateId() {
            return this.copsGateId;
        }

        void setCopsGateId(String copsGateId) {
            this.copsGateId = copsGateId;
        }

        public String getCopsGateState() {
            return this.copsGateState;
        }

        void setCopsGateState(String copsGateState) {
            this.copsGateState = copsGateState;
        }

        public String getCopsGateStateReason() {
            return this.copsGateStateReason;
        }

        void setCopsGateStateReason(String copsGateStateReason) {
            this.copsGateStateReason = copsGateStateReason;
        }

        public String getCopsGateTimeInfo() {
            return this.copsGateTimeInfo;
        }

        void setCopsGateTimeInfo(String copsGateTimeInfo) {
            this.copsGateTimeInfo = copsGateTimeInfo;
        }

        public String getCopsGateUsageInfo() {
            return this.copsGateUsageInfo;
        }

        void setCopsGateUsageInfo(String copsGateUsageInfo) {
            this.copsGateUsageInfo = copsGateUsageInfo;
        }
    }
}

