/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.ClassifierContainer;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.ClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice.ExtClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice.Ipv6ClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice.QosClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.traffic.profile.TrafficProfile;
import org.pcmm.gates.IAMID;
import org.pcmm.gates.IClassifier;
import org.pcmm.gates.IExtendedClassifier;
import org.pcmm.gates.IGateID;
import org.pcmm.gates.IGateSpec;
import org.pcmm.gates.IGateState;
import org.pcmm.gates.IGateTimeInfo;
import org.pcmm.gates.IGateUsageInfo;
import org.pcmm.gates.IIPv6Classifier;
import org.pcmm.gates.IPCMMError;
import org.pcmm.gates.ISubscriberID;
import org.pcmm.gates.ITrafficProfile;
import org.pcmm.gates.ITransactionID;
import org.pcmm.gates.impl.AMID;
import org.pcmm.gates.impl.DOCSISServiceClassNameTrafficProfile;
import org.pcmm.gates.impl.ExtendedClassifier;
import org.pcmm.gates.impl.GateID;
import org.pcmm.gates.impl.GateSpec;
import org.pcmm.gates.impl.GateState;
import org.pcmm.gates.impl.GateTimeInfo;
import org.pcmm.gates.impl.GateUsageInfo;
import org.pcmm.gates.impl.IPv6Classifier;
import org.pcmm.gates.impl.PCMMError;
import org.pcmm.gates.impl.PCMMGateReq;
import org.pcmm.gates.impl.SubscriberID;
import org.pcmm.gates.impl.TransactionID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCMMGateReqBuilder {
    private final Logger logger = LoggerFactory.getLogger(PCMMGateReqBuilder.class);
    private GateID gateID = null;
    private AMID amid = null;
    private SubscriberID subscriberID = null;
    private TransactionID transactionID = null;
    private GateSpec gateSpec = null;
    private ITrafficProfile trafficProfile = null;
    private final List<IClassifier> classifiers = Lists.newArrayListWithExpectedSize((int)4);
    private PCMMError error = null;
    private GateState gateState = null;
    private GateTimeInfo gateTimeInfo = null;
    private GateUsageInfo gateUsageInfo = null;

    public PCMMGateReq build() {
        return new PCMMGateReq((IAMID)this.amid, (ISubscriberID)this.subscriberID, (ITransactionID)this.transactionID, (IGateSpec)this.gateSpec, this.trafficProfile, this.classifiers, (IGateID)this.gateID, (IPCMMError)this.error, (IGateState)this.gateState, (IGateTimeInfo)this.gateTimeInfo, (IGateUsageInfo)this.gateUsageInfo);
    }

    public void setAmId(AmId qosAmId) {
        this.amid = new AMID(qosAmId.getAmType().shortValue(), qosAmId.getAmTag().shortValue());
    }

    public void setSubscriberId(InetAddress qosSubId) {
        this.subscriberID = new SubscriberID(qosSubId);
    }

    public void setGateSpec(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gate.spec.GateSpec qosGateSpec, ServiceFlowDirection scnDirection) {
        byte gateTosMask;
        byte dscptos;
        ServiceFlowDirection qosDir = scnDirection != null ? scnDirection : (qosGateSpec.getDirection() != null ? qosGateSpec.getDirection() : ServiceFlowDirection.Ds);
        IGateSpec.Direction gateDir = qosDir == ServiceFlowDirection.Ds ? IGateSpec.Direction.DOWNSTREAM : IGateSpec.Direction.UPSTREAM;
        TosByte tosOverwrite = qosGateSpec.getDscpTosOverwrite();
        if (tosOverwrite != null) {
            dscptos = 1;
            TosByte tosMask = qosGateSpec.getDscpTosMask();
            gateTosMask = tosMask != null ? (byte)tosMask.getValue().byteValue() : (byte)-1;
        } else {
            dscptos = 0;
            gateTosMask = 0;
        }
        this.gateSpec = new GateSpec(gateDir, dscptos, gateTosMask);
    }

    public void setTrafficProfile(TrafficProfile qosTrafficProfile) {
        if (qosTrafficProfile.getServiceClassName() != null) {
            this.trafficProfile = new DOCSISServiceClassNameTrafficProfile(qosTrafficProfile.getServiceClassName().getValue());
        }
    }

    private InetAddress getByName(String ipAddressStr) {
        try {
            return InetAddress.getByName(ipAddressStr);
        }
        catch (UnknownHostException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public void setClassifiers(List<ClassifierContainer> classifiers) {
        Preconditions.checkNotNull(classifiers);
        for (ClassifierContainer container : classifiers) {
            ClassifierChoice choice = container.getClassifierChoice();
            Short index = container.getClassifierId();
            if (choice instanceof QosClassifierChoice) {
                this.addClassifier(index, ((QosClassifierChoice)choice).getClassifier());
                continue;
            }
            if (choice instanceof ExtClassifierChoice) {
                this.addExtClassifier(index, ((ExtClassifierChoice)choice).getExtClassifier());
                continue;
            }
            if (choice instanceof Ipv6ClassifierChoice) {
                this.addIpv6Classifier(index, ((Ipv6ClassifierChoice)choice).getIpv6Classifier());
                continue;
            }
            throw new IllegalStateException("Unknown ClassifierChoice: " + choice);
        }
    }

    private void addClassifier(Short index, Classifier qosClassifier) {
        IClassifier.Protocol protocol = null;
        byte tosOverwrite = 0;
        byte tosMask = 0;
        short srcPort = 0;
        short dstPort = 0;
        byte priority = (byte)(64 + index);
        protocol = qosClassifier.getProtocol() != null ? IClassifier.Protocol.valueOf((short)qosClassifier.getProtocol().getValue().shortValue()) : IClassifier.Protocol.NONE;
        Inet4Address srcAddress = (Inet4Address)this.getByName("0.0.0.0");
        if (qosClassifier.getSrcIp() != null) {
            srcAddress = (Inet4Address)this.getByName(qosClassifier.getSrcIp().getValue());
        }
        Inet4Address dstAddress = (Inet4Address)this.getByName("0.0.0.0");
        if (qosClassifier.getDstIp() != null) {
            dstAddress = (Inet4Address)this.getByName(qosClassifier.getDstIp().getValue());
        }
        if (qosClassifier.getSrcPort() != null) {
            srcPort = qosClassifier.getSrcPort().getValue().shortValue();
        }
        if (qosClassifier.getDstPort() != null) {
            dstPort = qosClassifier.getDstPort().getValue().shortValue();
        }
        if (qosClassifier.getTosByte() != null) {
            tosOverwrite = qosClassifier.getTosByte().getValue().byteValue();
            tosMask = qosClassifier.getTosMask() != null ? (byte)qosClassifier.getTosMask().getValue().byteValue() : (byte)-1;
        }
        this.classifiers.add((IClassifier)new org.pcmm.gates.impl.Classifier(protocol, tosOverwrite, tosMask, srcAddress, dstAddress, srcPort, dstPort, priority));
    }

    private void addExtClassifier(Short index, ExtClassifier qosExtClassifier) {
        byte priority = (byte)(index + 64);
        IExtendedClassifier.ActivationState activationState = IExtendedClassifier.ActivationState.ACTIVE;
        IClassifier.Protocol protocol = qosExtClassifier.getProtocol() != null ? IClassifier.Protocol.valueOf((short)qosExtClassifier.getProtocol().getValue().shortValue()) : IClassifier.Protocol.NONE;
        short srcStartPort = 0;
        short srcEndPort = -1;
        if (qosExtClassifier.getSrcPortStart() != null) {
            srcStartPort = qosExtClassifier.getSrcPortStart().getValue().shortValue();
            srcEndPort = srcStartPort;
            if (qosExtClassifier.getSrcPortEnd() != null) {
                srcEndPort = qosExtClassifier.getSrcPortEnd().getValue().shortValue();
            }
            if ((srcStartPort & 0xFFFF) > (srcEndPort & 0xFFFF)) {
                this.logger.warn("Start port %d > End port %d in ext-classifier source port range -- forcing to same", (Object)srcStartPort, (Object)srcEndPort);
                srcEndPort = srcStartPort;
            }
        }
        short dstStartPort = 0;
        short dstEndPort = -1;
        if (qosExtClassifier.getDstPortStart() != null) {
            dstStartPort = qosExtClassifier.getDstPortStart().getValue().shortValue();
            dstEndPort = dstStartPort;
            if (qosExtClassifier.getDstPortEnd() != null) {
                dstEndPort = qosExtClassifier.getDstPortEnd().getValue().shortValue();
            }
            if ((dstStartPort & 0xFFFF) > (dstEndPort & 0xFFFF)) {
                this.logger.warn("Start port %d > End port %d in ext-classifier destination port range -- forcing to same", (Object)dstStartPort, (Object)dstEndPort);
                dstEndPort = dstStartPort;
            }
        }
        byte tosOverwrite = 0;
        byte tosMask = 0;
        if (qosExtClassifier.getTosByte() != null) {
            tosOverwrite = (byte)(qosExtClassifier.getTosByte().getValue().byteValue() | 1);
            tosMask = qosExtClassifier.getTosMask() != null ? (byte)qosExtClassifier.getTosMask().getValue().byteValue() : (byte)-1;
        }
        Inet4Address srcIpAddr = (Inet4Address)this.getByName("0.0.0.0");
        if (qosExtClassifier.getSrcIp() != null) {
            srcIpAddr = this.getInet4Address(qosExtClassifier.getSrcIp());
        }
        Inet4Address dstIpAddr = (Inet4Address)this.getByName("0.0.0.0");
        if (qosExtClassifier.getDstIp() != null) {
            dstIpAddr = this.getInet4Address(qosExtClassifier.getDstIp());
        }
        Inet4Address srcIpMask = (Inet4Address)this.getByName("255.255.255.255");
        if (qosExtClassifier.getSrcIpMask() != null) {
            srcIpMask = this.getInet4Address(qosExtClassifier.getSrcIpMask());
        }
        Inet4Address dstIpMask = (Inet4Address)this.getByName("255.255.255.255");
        if (qosExtClassifier.getDstIpMask() != null) {
            dstIpMask = this.getInet4Address(qosExtClassifier.getDstIpMask());
        }
        short classifierId = index;
        IExtendedClassifier.Action action = IExtendedClassifier.Action.ADD;
        this.classifiers.add((IClassifier)new ExtendedClassifier(protocol, tosOverwrite, tosMask, srcIpAddr, dstIpAddr, srcStartPort, dstStartPort, priority, srcIpMask, dstIpMask, srcEndPort, dstEndPort, classifierId, activationState, action));
    }

    private Inet4Address getInet4Address(Ipv4Address address) {
        InetAddress out;
        if (address != null && (out = this.getByName(address.getValue())) != null && out instanceof Inet4Address) {
            return (Inet4Address)out;
        }
        return null;
    }

    private void addIpv6Classifier(Short index, Ipv6Classifier qosIpv6Classifier) {
        short nextHdr = qosIpv6Classifier.getNextHdr() != null ? (short)qosIpv6Classifier.getNextHdr().getValue().shortValue() : (short)256;
        byte srcPrefixLen = -128;
        Inet6Address srcAddress = (Inet6Address)this.getByName("0::0");
        if (qosIpv6Classifier.getSrcIp6() != null) {
            String[] parts = qosIpv6Classifier.getSrcIp6().getValue().split("/");
            String Ipv6AddressStr = parts[0];
            srcAddress = (Inet6Address)this.getByName(Ipv6AddressStr);
            srcPrefixLen = parts.length > 1 ? (byte)((byte)Integer.parseInt(parts[1])) : (byte)-128;
        }
        Inet6Address dstAddress = (Inet6Address)this.getByName("0::0");
        byte dstPrefLen = -128;
        if (qosIpv6Classifier.getDstIp6() != null) {
            String[] parts = qosIpv6Classifier.getDstIp6().getValue().split("/");
            String Ipv6AddressStr = parts[0];
            dstAddress = (Inet6Address)this.getByName(Ipv6AddressStr);
            dstPrefLen = parts.length > 1 ? (byte)((byte)Integer.parseInt(parts[1])) : (byte)-128;
        }
        short srcPortBegin = 0;
        short srcPortEnd = -1;
        if (qosIpv6Classifier.getSrcPortStart() != null) {
            srcPortBegin = qosIpv6Classifier.getSrcPortStart().getValue().shortValue();
            srcPortEnd = srcPortBegin;
            if (qosIpv6Classifier.getSrcPortEnd() != null) {
                srcPortEnd = qosIpv6Classifier.getSrcPortEnd().getValue().shortValue();
            }
            if ((srcPortBegin & 0xFFFF) > (srcPortEnd & 0xFFFF)) {
                this.logger.warn("Start port %d > End port %d in ipv6-classifier source port range -- forcing to same", (Object)srcPortBegin, (Object)srcPortEnd);
                srcPortEnd = srcPortBegin;
            }
        }
        short dstPortBegin = 0;
        short dstPortEnd = -1;
        if (qosIpv6Classifier.getDstPortStart() != null) {
            dstPortBegin = qosIpv6Classifier.getDstPortStart().getValue().shortValue();
            dstPortEnd = dstPortBegin;
            if (qosIpv6Classifier.getDstPortEnd() != null) {
                dstPortEnd = qosIpv6Classifier.getDstPortEnd().getValue().shortValue();
            }
            if ((dstPortBegin & 0xFFFF) > (dstPortEnd & 0xFFFF)) {
                this.logger.warn("Start port %d > End port %d in ipv6-classifier destination port range -- forcing to same", (Object)dstPortBegin, (Object)dstPortEnd);
                dstPortEnd = dstPortBegin;
            }
        }
        byte tcLow = qosIpv6Classifier.getTcLow() != null ? qosIpv6Classifier.getTcLow().getValue().byteValue() : (byte)0;
        byte tcHigh = qosIpv6Classifier.getTcHigh() != null ? qosIpv6Classifier.getTcHigh().getValue().byteValue() : (byte)0;
        byte tcMask = qosIpv6Classifier.getTcHigh() != null ? qosIpv6Classifier.getTcHigh().getValue().byteValue() : (qosIpv6Classifier.getTcLow() != null ? (byte)-1 : 0);
        IIPv6Classifier.FlowLabel flowLabelFlag = IIPv6Classifier.FlowLabel.IRRELEVANT;
        int flowLabelId = 0;
        if (qosIpv6Classifier.getFlowLabel() != null) {
            flowLabelFlag = IIPv6Classifier.FlowLabel.VALID;
            flowLabelId = qosIpv6Classifier.getFlowLabel().intValue();
        }
        short classifierId = index;
        IExtendedClassifier.Action action = IExtendedClassifier.Action.ADD;
        this.classifiers.add((IClassifier)new IPv6Classifier(srcAddress, dstAddress, srcPortBegin, dstPortBegin, (byte)(index + 64), srcPortEnd, dstPortEnd, classifierId, IExtendedClassifier.ActivationState.ACTIVE, action, flowLabelFlag, tcLow, tcHigh, tcMask, flowLabelId, nextHdr, srcPrefixLen, dstPrefLen));
    }
}

