/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.packetcable.provider.DataChangeUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataChangeListener<T extends DataObject>
implements DataChangeListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<T> tClass;

    public AbstractDataChangeListener(Class<T> tClass) {
        this.tClass = (Class)Preconditions.checkNotNull(tClass);
    }

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> asyncDataChangeEvent) {
        Set allRemovedPaths;
        this.logger.debug("############{}.onDataChanged()", (Object)this.getClass().getSimpleName());
        DataChangeUtils.logChange(this.logger, asyncDataChangeEvent);
        Map allCreatedData = asyncDataChangeEvent.getCreatedData();
        Map allOriginalData = asyncDataChangeEvent.getOriginalData();
        Map allUpdatedData = asyncDataChangeEvent.getUpdatedData();
        Map<InstanceIdentifier<?>, DataObject> trueUpdatedData = DataChangeUtils.relativeComplement(allCreatedData, allUpdatedData);
        Map<InstanceIdentifier<?>, DataObject> trueOriginalData = DataChangeUtils.relativeComplement(allCreatedData, allOriginalData);
        if (!allCreatedData.isEmpty()) {
            Map<InstanceIdentifier<T>, T> createdTs = DataChangeUtils.collectTypeFromMap(this.tClass, allCreatedData);
            if (createdTs.isEmpty()) {
                this.logger.warn("Expected created {}(s) but none were found: {}", (Object)this.tClass.getSimpleName(), (Object)allCreatedData);
            } else {
                this.handleCreatedData(createdTs);
            }
        }
        if (!trueUpdatedData.isEmpty()) {
            Map<InstanceIdentifier<T>, T> updatedTs = DataChangeUtils.collectTypeFromMap(this.tClass, trueUpdatedData);
            if (updatedTs.isEmpty()) {
                this.logger.warn("Expected updated {}(s) but none were found: {}", (Object)this.tClass.getSimpleName(), trueUpdatedData);
            } else {
                Map<InstanceIdentifier<T>, T> originalTs = DataChangeUtils.collectTypeFromMap(this.tClass, trueOriginalData);
                for (InstanceIdentifier<T> iid : updatedTs.keySet()) {
                    if (originalTs.containsKey(iid)) continue;
                    this.logger.warn("No original data for updated object {}", iid);
                }
                this.handleUpdatedData(updatedTs, originalTs);
            }
        }
        if (!(allRemovedPaths = asyncDataChangeEvent.getRemovedPaths()).isEmpty()) {
            Set<InstanceIdentifier<T>> removedTPaths = DataChangeUtils.collectTypeFromSet(this.tClass, allRemovedPaths);
            if (removedTPaths.isEmpty()) {
                this.logger.warn("Expected removed {} but none were found: {}", (Object)this.tClass.getSimpleName(), (Object)allRemovedPaths);
            }
            HashMap originalTData = Maps.newHashMapWithExpectedSize((int)removedTPaths.size());
            for (InstanceIdentifier<T> iid : removedTPaths) {
                if (!allOriginalData.containsKey(iid)) continue;
                originalTData.put(iid, (DataObject)allOriginalData.get(iid));
            }
            this.handleRemovedData(removedTPaths, originalTData);
        }
    }

    protected abstract void handleCreatedData(Map<InstanceIdentifier<T>, T> var1);

    protected abstract void handleUpdatedData(Map<InstanceIdentifier<T>, T> var1, Map<InstanceIdentifier<T>, T> var2);

    protected abstract void handleRemovedData(Set<InstanceIdentifier<T>> var1, Map<InstanceIdentifier<T>, T> var2);
}

