/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.packetcable.packetcable.policy.server.impl.rev140131;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.packetcable.provider.PacketcableProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.packetcable.packetcable.policy.server.impl.rev140131.AbstractPacketcableProviderModule;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketcableProviderModule
extends AbstractPacketcableProviderModule {
    private static final Logger logger = LoggerFactory.getLogger(PacketcableProviderModule.class);

    public PacketcableProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public PacketcableProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, PacketcableProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
    }

    public AutoCloseable createInstance() {
        logger.info("Creating PacketcableProvider instance");
        DataBroker dataBrokerService = this.getDataBrokerDependency();
        PacketcableProvider provider = new PacketcableProvider(dataBrokerService);
        ListenerRegistration ccapDataChangeListenerRegistration = dataBrokerService.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, PacketcableProvider.ccapIID, (DataChangeListener)provider, AsyncDataBroker.DataChangeScope.SUBTREE);
        ListenerRegistration qosDataChangeListenerRegistration = dataBrokerService.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, PacketcableProvider.qosIID, (DataChangeListener)provider, AsyncDataBroker.DataChangeScope.SUBTREE);
        logger.info("PacketCableProvider Registered with DataBroker");
        return provider;
    }
}

