/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.packetcable.provider.Response;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.CcapsBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmId;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmIdBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.ConnectionBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.ClassifierBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifierBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpecBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.GatesBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6ClassifierBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.traffic.profile.TrafficProfile;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.traffic.profile.TrafficProfileBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateInstanceData {
    private static final Logger logger = LoggerFactory.getLogger(ValidateInstanceData.class);
    private final DataBroker dataBroker;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Map<InstanceIdentifier<Gates>, Gates> gateIidMap;
    private transient Ccaps ccap;
    private transient InstanceIdentifier<Ccaps> ccapIID;

    public ValidateInstanceData(DataBroker dataBroker, Map<InstanceIdentifier<?>, DataObject> thisData) {
        this.dataBroker = dataBroker;
        this.getCcap(thisData);
        this.gateIidMap = new ConcurrentHashMap<InstanceIdentifier<Gates>, Gates>();
        if (this.ccap == null) {
            this.getGates(thisData);
        }
    }

    public boolean isResponseEcho() {
        if (this.ccap != null && this.ccap.getResponse() != null) {
            return true;
        }
        return !this.gateIidMap.isEmpty() && this.gateIidMap.values().iterator().next().getResponse() != null;
    }

    public boolean validateYang() {
        String badText = "400 Bad Request - Invalid Element Values in json object - ";
        if (this.isResponseEcho()) {
            return true;
        }
        if (this.ccap != null) {
            Response response = new Response(this.dataBroker, this.ccapIID, this.ccap, "400 Bad Request - Invalid Element Values in json object - ");
            if (!this.validateCcap(this.ccap, response)) {
                logger.error("Validate CCAP {} failed - {}", (Object)this.ccap.getCcapId(), (Object)response.getMessage());
                this.executor.execute(response);
                return false;
            }
        } else if (!this.gateIidMap.isEmpty()) {
            for (Map.Entry<InstanceIdentifier<Gates>, Gates> entry : this.gateIidMap.entrySet()) {
                Response response;
                InstanceIdentifier<Gates> gateIID = entry.getKey();
                Gates gate = entry.getValue();
                if (this.validateGate(gate, response = new Response(this.dataBroker, gateIID, gate, "400 Bad Request - Invalid Element Values in json object - "))) continue;
                logger.error("Validate Gate {} failed - {}", (Object)gate.getGateId(), (Object)response.getMessage());
                this.executor.execute(response);
                return false;
            }
        }
        return true;
    }

    private void getCcap(Map<InstanceIdentifier<?>, DataObject> thisData) {
        for (Map.Entry<InstanceIdentifier<?>, DataObject> entry : thisData.entrySet()) {
            if (!(entry.getValue() instanceof Ccaps)) continue;
            this.ccap = (Ccaps)entry.getValue();
            this.ccapIID = entry.getKey();
        }
    }

    private void getGates(Map<InstanceIdentifier<?>, DataObject> thisData) {
        for (Map.Entry<InstanceIdentifier<?>, DataObject> entry : thisData.entrySet()) {
            if (!(entry.getValue() instanceof Gates)) continue;
            Gates gate = (Gates)entry.getValue();
            InstanceIdentifier<?> gateIID = entry.getKey();
            this.gateIidMap.put(gateIID, gate);
        }
    }

    private String validateMethod(Class<?> thisClass, Object thisObj, String methodName) {
        try {
            Method method = thisClass.getMethod(methodName, new Class[0]);
            method.invoke(thisObj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
        catch (Exception e) {
            return " ";
        }
        return null;
    }

    private boolean validateGateSpec(Gates gate, GatesBuilder gateBuilder, Response response) {
        String message = "";
        boolean valid = true;
        GateSpec gateSpec = gate.getGateSpec();
        if (gateSpec != null) {
            TosByte tosMask;
            TosByte tosByte;
            ServiceFlowDirection dir;
            String error = this.validateMethod(GateSpec.class, gateSpec, "getDirection");
            if (error == null) {
                dir = gateSpec.getDirection();
                if (dir != null && gate.getTrafficProfile().getServiceClassName() != null) {
                    message = message + " gate-spec.direction not allowed for traffic-profile.SCN;";
                    valid = false;
                }
            } else {
                message = message + " gate-spec.direction invalid: must be 'us' or 'ds' -" + error;
                dir = null;
                valid = false;
            }
            if ((error = this.validateMethod(GateSpec.class, gateSpec, "getDscpTosOverwrite")) == null) {
                tosByte = gateSpec.getDscpTosOverwrite();
            } else {
                message = message + " gate-spec.dscp-tos-overwrite invalid: " + error;
                tosByte = null;
                valid = false;
            }
            error = this.validateMethod(GateSpec.class, gateSpec, "getDscpTosMask");
            if (error == null) {
                tosMask = gateSpec.getDscpTosMask();
                if (tosByte != null && tosMask == null) {
                    message = message + " gate-spec.dscp-tos-mask missing;";
                    valid = false;
                }
            } else {
                message = message + " gate-spec.dscp-tos-mask invalid: " + error;
                tosMask = null;
                valid = false;
            }
            if (!valid) {
                GateSpecBuilder gateSpecBuilder = new GateSpecBuilder();
                gateSpecBuilder.setDirection(dir);
                gateSpecBuilder.setDscpTosOverwrite(tosByte);
                gateSpecBuilder.setDscpTosMask(tosMask);
                gateSpec = gateSpecBuilder.build();
                gateBuilder.setGateSpec(gateSpec);
            }
        }
        if (!valid) {
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateTrafficProfile(Gates gate, GatesBuilder gateBuilder, Response response) {
        String message = "";
        boolean valid = true;
        TrafficProfile profile = gate.getTrafficProfile();
        if (profile == null) {
            message = message + " traffic-profile is required;";
            valid = false;
        } else {
            ServiceClassName scn;
            String error = this.validateMethod(TrafficProfile.class, profile, "getServiceClassName");
            if (error == null) {
                scn = profile.getServiceClassName();
                if (scn == null) {
                    message = message + " traffic-profile.service-class-name missing;";
                    valid = false;
                }
            } else {
                message = message + " traffic-profile.service-class-name invalid: must be 2-16 characters " + error;
                scn = null;
                valid = false;
            }
            if (!valid) {
                TrafficProfileBuilder profileBuilder = new TrafficProfileBuilder();
                profileBuilder.setServiceClassName(scn);
                profile = profileBuilder.build();
                gateBuilder.setTrafficProfile(profile);
            }
        }
        if (!valid) {
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateClassifier(Gates gate, GatesBuilder gateBuilder, Response response) {
        TosByte tosMask;
        TosByte tosByte;
        PortNumber dport;
        PortNumber sport;
        TpProtocol proto;
        Ipv4Address dip;
        Ipv4Address sip;
        String message = "";
        boolean valid = true;
        int count = 0;
        Classifier classifier = gate.getClassifier();
        String error = this.validateMethod(Classifier.class, classifier, "getSrcIp");
        if (error == null) {
            sip = classifier.getSrcIp();
            ++count;
        } else {
            message = message + " classifier.srcIp invalid: - " + error;
            sip = null;
            valid = false;
        }
        error = this.validateMethod(Classifier.class, classifier, "getDstIp");
        if (error == null) {
            dip = classifier.getDstIp();
            ++count;
        } else {
            message = message + " classifier.dstIp invalid: - " + error;
            dip = null;
            valid = false;
        }
        error = this.validateMethod(Classifier.class, classifier, "getProtocol");
        if (error == null) {
            proto = classifier.getProtocol();
            ++count;
        } else {
            message = message + " classifier.protocol invalid: - " + error;
            proto = null;
            valid = false;
        }
        error = this.validateMethod(Classifier.class, classifier, "getSrcPort");
        if (error == null) {
            sport = classifier.getSrcPort();
            ++count;
        } else {
            message = message + " classifier.srcPort invalid: - " + error;
            sport = null;
            valid = false;
        }
        error = this.validateMethod(Classifier.class, classifier, "getDstPort");
        if (error == null) {
            dport = classifier.getDstPort();
            ++count;
        } else {
            message = message + " classifier.dstPort invalid: - " + error;
            dport = null;
            valid = false;
        }
        error = this.validateMethod(Classifier.class, classifier, "getTosByte");
        if (error == null) {
            tosByte = classifier.getTosByte();
            ++count;
        } else {
            message = message + " classifier.tosByte invalid: " + error;
            tosByte = null;
            valid = false;
        }
        error = this.validateMethod(Classifier.class, classifier, "getTosMask");
        if (error == null) {
            tosMask = classifier.getTosMask();
            if (tosByte != null && tosMask == null) {
                message = message + " classifier.tosMask missing;";
                valid = false;
            }
        } else {
            message = message + " classifier.tosMask invalid: " + error;
            tosMask = null;
            valid = false;
        }
        if (count == 0) {
            message = message + " classifer must have at least one match field";
            valid = false;
        }
        if (!valid) {
            ClassifierBuilder cBuilder = new ClassifierBuilder();
            cBuilder.setSrcIp(sip);
            cBuilder.setDstIp(dip);
            cBuilder.setProtocol(proto);
            cBuilder.setSrcPort(sport);
            cBuilder.setDstPort(dport);
            cBuilder.setTosByte(tosByte);
            cBuilder.setTosMask(tosMask);
            classifier = cBuilder.build();
            gateBuilder.setClassifier(classifier);
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateExtClassifier(Gates gate, GatesBuilder gateBuilder, Response response) {
        TosByte tosMask;
        TosByte tosByte;
        PortNumber dportEnd;
        PortNumber dportStart;
        PortNumber sportEnd;
        PortNumber sportStart;
        TpProtocol proto;
        Ipv4Address dipMask;
        Ipv4Address dip;
        Ipv4Address sipMask;
        Ipv4Address sip;
        String message = "";
        boolean valid = true;
        int count = 0;
        ExtClassifier extClassifier = gate.getExtClassifier();
        String error = this.validateMethod(ExtClassifier.class, extClassifier, "getSrcIp");
        if (error == null) {
            sip = extClassifier.getSrcIp();
            ++count;
        } else {
            message = message + " ext-classifier.srcIp invalid: - " + error;
            sip = null;
            valid = false;
        }
        error = this.validateMethod(ExtClassifier.class, extClassifier, "getSrcIpMask");
        if (error == null) {
            sipMask = extClassifier.getSrcIpMask();
            ++count;
        } else {
            message = message + " ext-classifier.srcIpMask invalid: - " + error;
            sipMask = null;
            valid = false;
        }
        if (sip != null && sipMask == null) {
            message = message + " ext-classifier.srcIpMask missing";
            valid = false;
        }
        if ((error = this.validateMethod(ExtClassifier.class, extClassifier, "getDstIp")) == null) {
            dip = extClassifier.getDstIp();
            ++count;
        } else {
            message = message + " ext-classifier.dstIp invalid: - " + error;
            dip = null;
            valid = false;
        }
        error = this.validateMethod(ExtClassifier.class, extClassifier, "getDstIpMask");
        if (error == null) {
            dipMask = extClassifier.getDstIpMask();
            ++count;
        } else {
            message = message + " ext-classifier.srcIpMask invalid: - " + error;
            dipMask = null;
            valid = false;
        }
        if (dip != null && dipMask == null) {
            message = message + " ext-classifier.dstIpMask missing;";
            valid = false;
        }
        if ((error = this.validateMethod(ExtClassifier.class, extClassifier, "getProtocol")) == null) {
            proto = extClassifier.getProtocol();
            ++count;
        } else {
            message = message + " ext-classifier.protocol invalid: - " + error;
            proto = null;
            valid = false;
        }
        error = this.validateMethod(ExtClassifier.class, extClassifier, "getSrcPortStart");
        if (error == null) {
            sportStart = extClassifier.getSrcPortStart();
            ++count;
        } else {
            message = message + " ext-classifier.srcPortStart invalid: - " + error;
            sportStart = null;
            valid = false;
        }
        error = this.validateMethod(ExtClassifier.class, extClassifier, "getSrcPortEnd");
        if (error == null) {
            sportEnd = extClassifier.getSrcPortEnd();
            ++count;
        } else {
            message = message + " ext-classifier.srcPortEnd invalid: - " + error;
            sportEnd = null;
            valid = false;
        }
        if (sportStart != null && sportEnd != null && sportStart.getValue() > sportEnd.getValue()) {
            message = message + " ext-classifier.srcPortStart greater than srcPortEnd";
            valid = false;
        }
        if ((error = this.validateMethod(ExtClassifier.class, extClassifier, "getDstPortStart")) == null) {
            dportStart = extClassifier.getDstPortStart();
            ++count;
        } else {
            message = message + " ext-classifier.dstPortStart invalid: - " + error;
            dportStart = null;
            valid = false;
        }
        error = this.validateMethod(ExtClassifier.class, extClassifier, "getDstPortEnd");
        if (error == null) {
            dportEnd = extClassifier.getDstPortEnd();
            ++count;
        } else {
            message = message + " ext-classifier.dstPortEnd invalid: - " + error;
            dportEnd = null;
            valid = false;
        }
        if (dportStart != null && dportEnd != null && dportStart.getValue() > dportEnd.getValue()) {
            message = message + " ext-classifier.dstPortStart greater than dstPortEnd";
            valid = false;
        }
        if ((error = this.validateMethod(ExtClassifier.class, extClassifier, "getTosByte")) == null) {
            tosByte = extClassifier.getTosByte();
            ++count;
        } else {
            message = message + " ext-classifier.tosByte invalid: " + error;
            tosByte = null;
            valid = false;
        }
        error = this.validateMethod(ExtClassifier.class, extClassifier, "getTosMask");
        if (error == null) {
            tosMask = extClassifier.getTosMask();
            if (tosByte != null && tosMask == null) {
                message = message + " ext-classifier.tosMask missing;";
                valid = false;
            }
        } else {
            message = message + " ext-classifier.tosMask invalid: " + error;
            tosMask = null;
            valid = false;
        }
        if (count == 0) {
            message = message + " ext-classifer must have at least one match field";
            valid = false;
        }
        if (!valid) {
            ExtClassifierBuilder cBuilder = new ExtClassifierBuilder();
            cBuilder.setSrcIp(sip);
            cBuilder.setSrcIpMask(sipMask);
            cBuilder.setDstIp(dip);
            cBuilder.setDstIpMask(dipMask);
            cBuilder.setProtocol(proto);
            cBuilder.setSrcPortStart(sportStart);
            cBuilder.setSrcPortEnd(sportEnd);
            cBuilder.setDstPortStart(dportStart);
            cBuilder.setDstPortEnd(dportEnd);
            cBuilder.setTosByte(tosByte);
            cBuilder.setTosMask(tosMask);
            extClassifier = cBuilder.build();
            gateBuilder.setExtClassifier(extClassifier);
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateIpv6Classifier(Gates gate, GatesBuilder gateBuilder, Response response) {
        TosByte tcMask;
        TosByte tcHigh;
        TosByte tcLow;
        PortNumber dportEnd;
        PortNumber dportStart;
        PortNumber sportEnd;
        PortNumber sportStart;
        TpProtocol nxtHdr;
        Long flowLabel;
        Ipv6Prefix dip6;
        Ipv6Prefix sip6;
        String message = "";
        boolean valid = true;
        int count = 0;
        Ipv6Classifier ipv6Classifier = gate.getIpv6Classifier();
        String error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getSrcIp6");
        if (error == null) {
            sip6 = ipv6Classifier.getSrcIp6();
            ++count;
        } else {
            message = message + " ipv6-classifier.srcIp invalid: - " + error;
            sip6 = null;
            valid = false;
        }
        error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getDstIp6");
        if (error == null) {
            dip6 = ipv6Classifier.getDstIp6();
            ++count;
        } else {
            message = message + " ipv6-classifier.dstIp invalid: - " + error;
            dip6 = null;
            valid = false;
        }
        error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getFlowLabel");
        if (error == null) {
            flowLabel = ipv6Classifier.getFlowLabel();
            if (flowLabel > 1048575L) {
                message = message + " ipv6-classifier.flowLabel invalid: - must be 0..1048575";
                flowLabel = null;
                valid = false;
            } else {
                ++count;
            }
        } else {
            message = message + " ipv6-classifier.flowLabel invalid: - " + error;
            flowLabel = null;
            valid = false;
        }
        error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getNextHdr");
        if (error == null) {
            nxtHdr = ipv6Classifier.getNextHdr();
            ++count;
        } else {
            message = message + " ipv6-classifier.nextHdr invalid: - " + error;
            nxtHdr = null;
            valid = false;
        }
        error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getSrcPortStart");
        if (error == null) {
            sportStart = ipv6Classifier.getSrcPortStart();
            ++count;
        } else {
            message = message + " ipv6-classifier.srcPortStart invalid: - " + error;
            sportStart = null;
            valid = false;
        }
        error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getSrcPortEnd");
        if (error == null) {
            sportEnd = ipv6Classifier.getSrcPortEnd();
            ++count;
        } else {
            message = message + " ipv6-classifier.srcPortEnd invalid: - " + error;
            sportEnd = null;
            valid = false;
        }
        if (sportStart != null && sportEnd != null && sportStart.getValue() > sportEnd.getValue()) {
            message = message + " ipv6-classifier.srcPortStart greater than srcPortEnd";
            valid = false;
        }
        if ((error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getDstPortStart")) == null) {
            dportStart = ipv6Classifier.getDstPortStart();
            ++count;
        } else {
            message = message + " ipv6-classifier.dstPortStart invalid: - " + error;
            dportStart = null;
            valid = false;
        }
        error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getDstPortEnd");
        if (error == null) {
            dportEnd = ipv6Classifier.getDstPortEnd();
            ++count;
        } else {
            message = message + " ipv6-classifier.dstPortEnd invalid: - " + error;
            dportEnd = null;
            valid = false;
        }
        if (dportStart != null && dportEnd != null && dportStart.getValue() > dportEnd.getValue()) {
            message = message + " ipv6-classifier.dstPortStart greater than dstPortEnd";
            valid = false;
        }
        if ((error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getTcLow")) == null) {
            tcLow = ipv6Classifier.getTcLow();
            ++count;
        } else {
            message = message + " ipv6-classifier.tc-low invalid: " + error;
            tcLow = null;
            valid = false;
        }
        error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getTcHigh");
        if (error == null) {
            tcHigh = ipv6Classifier.getTcHigh();
            ++count;
        } else {
            message = message + " ipv6-classifier.tc-high invalid: " + error;
            tcHigh = null;
            valid = false;
        }
        if (tcLow != null && tcHigh != null && tcLow.getValue() > tcHigh.getValue()) {
            message = message + " ipv6-classifier.tc-low is greater than tc-high";
            valid = false;
        }
        if ((error = this.validateMethod(Ipv6Classifier.class, ipv6Classifier, "getTcMask")) == null) {
            tcMask = ipv6Classifier.getTcMask();
        } else {
            message = message + " ipv6-classifier.tc-mask invalid: " + error;
            tcMask = null;
            valid = false;
        }
        if (tcLow != null && tcHigh != null && tcMask == null) {
            message = message + " ipv6-classifier.tc-mask missing;";
            valid = false;
        }
        if (count == 0) {
            message = message + " ipv6-classifer must have at least one match field";
            valid = false;
        }
        if (!valid) {
            Ipv6ClassifierBuilder cBuilder = new Ipv6ClassifierBuilder();
            cBuilder.setSrcIp6(sip6);
            cBuilder.setDstIp6(dip6);
            cBuilder.setFlowLabel(flowLabel);
            cBuilder.setNextHdr(nxtHdr);
            cBuilder.setSrcPortStart(sportStart);
            cBuilder.setSrcPortEnd(sportEnd);
            cBuilder.setDstPortStart(dportStart);
            cBuilder.setDstPortEnd(dportEnd);
            cBuilder.setTcLow(tcLow);
            cBuilder.setTcHigh(tcHigh);
            cBuilder.setTcMask(tcMask);
            ipv6Classifier = cBuilder.build();
            gateBuilder.setIpv6Classifier(ipv6Classifier);
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateGate(Gates gate, Response response) {
        GatesBuilder gateBuilder = new GatesBuilder();
        String message = "";
        boolean rebuild = false;
        if (!this.validateGateSpec(gate, gateBuilder, response)) {
            rebuild = true;
        }
        if (!this.validateTrafficProfile(gate, gateBuilder, response)) {
            rebuild = true;
        }
        Classifier classifier = gate.getClassifier();
        ExtClassifier extClassifier = gate.getExtClassifier();
        Ipv6Classifier ipv6Classifier = gate.getIpv6Classifier();
        int count = 0;
        if (classifier != null) {
            ++count;
        }
        if (extClassifier != null) {
            ++count;
        }
        if (ipv6Classifier != null) {
            ++count;
        }
        if (count < 1) {
            response.addMessage(" Missing classifer: must have only 1 of classifier, ext-classifier, or ipv6-classifier");
            rebuild = true;
        } else if (count > 1) {
            response.addMessage(" Multiple classifiers: must have only 1 of classifier, ext-classifier, or ipv6-classifier");
            rebuild = true;
        } else if (count == 1) {
            if (classifier != null) {
                if (!this.validateClassifier(gate, gateBuilder, response)) {
                    rebuild = true;
                }
            } else if (extClassifier != null) {
                if (!this.validateExtClassifier(gate, gateBuilder, response)) {
                    rebuild = true;
                }
            } else if (ipv6Classifier != null && !this.validateIpv6Classifier(gate, gateBuilder, response)) {
                rebuild = true;
            }
        }
        if (rebuild) {
            gateBuilder.setGateId(gate.getGateId());
            gateBuilder.setKey(gate.getKey());
            gate = gateBuilder.build();
            response.setGateBase(gate);
            response.addMessage(message);
        }
        return !rebuild;
    }

    private boolean validateAmId(Ccaps ccap, CcapsBuilder ccapBuilder, Response response) {
        String message = "";
        boolean valid = true;
        AmId amId = ccap.getAmId();
        if (amId == null) {
            message = message + " amId is required;";
            valid = false;
        } else {
            Integer amType;
            Integer amTag;
            String error = this.validateMethod(AmId.class, amId, "getAmTag");
            if (error == null) {
                amTag = amId.getAmTag();
                if (amTag == null) {
                    message = message + " amId.amTag missing;";
                    valid = false;
                }
            } else {
                message = message + " amId.amTag invalid: " + error;
                amTag = null;
                valid = false;
            }
            if ((error = this.validateMethod(AmId.class, amId, "getAmType")) == null) {
                amType = amId.getAmType();
                if (amType == null) {
                    message = message + " amId.amType missing;";
                    valid = false;
                }
            } else {
                message = message + " amId.amType invalid: " + error;
                amType = null;
                valid = false;
            }
            if (!valid) {
                AmIdBuilder amIdBuilder = new AmIdBuilder();
                amIdBuilder.setAmTag(amTag);
                amIdBuilder.setAmType(amType);
                amId = amIdBuilder.build();
                ccapBuilder.setAmId(amId);
            }
        }
        if (!valid) {
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateConnection(Ccaps ccap, CcapsBuilder ccapBuilder, Response response) {
        String message = "";
        boolean valid = true;
        Connection conn = ccap.getConnection();
        if (conn == null) {
            message = message + " connection is required;";
            valid = false;
        } else {
            PortNumber portNum;
            IpAddress ipAddress;
            String error = this.validateMethod(Connection.class, conn, "getIpAddress");
            if (error == null) {
                ipAddress = conn.getIpAddress();
                if (ipAddress == null) {
                    message = message + " connection.ipAddress missing;";
                    valid = false;
                }
            } else {
                message = message + " connection.ipAddress invalid: " + error;
                ipAddress = null;
                valid = false;
            }
            if ((error = this.validateMethod(Connection.class, conn, "getPort")) == null) {
                portNum = conn.getPort();
            } else {
                message = message + " connection.port invalid: " + error;
                portNum = null;
                valid = false;
            }
            if (!valid) {
                ConnectionBuilder connBuilder = new ConnectionBuilder();
                connBuilder.setIpAddress(ipAddress);
                connBuilder.setPort(portNum);
                conn = connBuilder.build();
                ccapBuilder.setConnection(conn);
            }
        }
        if (!valid) {
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateSubscriberSubnets(Ccaps ccap, CcapsBuilder ccapBuilder, Response response) {
        String message = "";
        boolean valid = true;
        List subnets = null;
        String error = this.validateMethod(Ccaps.class, ccap, "getSubscriberSubnets");
        if (error == null) {
            subnets = ccap.getSubscriberSubnets();
            if (subnets == null) {
                message = message + " subscriber-subnets is required;";
                valid = false;
            }
        } else {
            message = message + " subscriber-subnets contains invalid IpPrefix - must be <ipaddress>/<prefixlen> format;" + error;
            valid = false;
        }
        if (!valid) {
            ccapBuilder.setSubscriberSubnets(subnets);
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateUpstreamScns(Ccaps ccap, CcapsBuilder ccapBuilder, Response response) {
        String message = "";
        boolean valid = true;
        List usScns = null;
        String error = this.validateMethod(Ccaps.class, ccap, "getUpstreamScns");
        if (error == null) {
            usScns = ccap.getUpstreamScns();
            if (usScns == null) {
                message = message + " upstream-scns is required;";
                valid = false;
            }
        } else {
            message = message + " upstream-scns contains invalid SCN - must be 2-16 characters;" + error;
            valid = false;
        }
        if (!valid) {
            ccapBuilder.setUpstreamScns(usScns);
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateDownstreamScns(Ccaps ccap, CcapsBuilder ccapBuilder, Response response) {
        String message = "";
        boolean valid = true;
        List dsScns = null;
        String error = this.validateMethod(Ccaps.class, ccap, "getDownstreamScns");
        if (error == null) {
            dsScns = ccap.getDownstreamScns();
            if (dsScns == null) {
                message = message + " downstream-scns is required;";
                valid = false;
            }
        } else {
            message = message + " downstream-scns contains invalid SCN - must be 2-16 characters;" + error;
            valid = false;
        }
        if (!valid) {
            ccapBuilder.setDownstreamScns(dsScns);
            response.addMessage(message);
        }
        return valid;
    }

    private boolean validateCcap(Ccaps ccap, Response response) {
        CcapsBuilder ccapBuilder = new CcapsBuilder();
        String message = "";
        boolean rebuild = false;
        if (!this.validateAmId(ccap, ccapBuilder, response)) {
            rebuild = true;
        }
        if (!this.validateConnection(ccap, ccapBuilder, response)) {
            rebuild = true;
        }
        if (!this.validateSubscriberSubnets(ccap, ccapBuilder, response)) {
            rebuild = true;
        }
        if (!this.validateUpstreamScns(ccap, ccapBuilder, response)) {
            rebuild = true;
        }
        if (!this.validateDownstreamScns(ccap, ccapBuilder, response)) {
            rebuild = true;
        }
        if (rebuild) {
            ccapBuilder.setCcapId(ccap.getCcapId());
            ccapBuilder.setKey(ccap.getKey());
            ccap = ccapBuilder.build();
            response.setCcapBase(ccap);
            response.addMessage(message);
        }
        return !rebuild;
    }
}

