/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.CcapsBuilder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.GatesBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(Response.class);
    private DataBroker dataBroker;
    private String message = null;
    private InstanceIdentifier<Ccaps> ccapIID = null;
    private Ccaps ccapBase = null;
    private InstanceIdentifier<Gates> gateIID = null;
    private Gates gateBase = null;

    public Response(DataBroker dataBroker, InstanceIdentifier<Ccaps> ccapIID, Ccaps ccapBase, String message) {
        this.dataBroker = dataBroker;
        this.ccapIID = ccapIID;
        this.ccapBase = ccapBase;
        this.message = message;
    }

    public Response(DataBroker dataBroker, InstanceIdentifier<Gates> gateIID, Gates gateBase, String message) {
        this.dataBroker = dataBroker;
        this.gateIID = gateIID;
        this.gateBase = gateBase;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void addMessage(String message) {
        this.message = this.message + message;
    }

    public InstanceIdentifier<Ccaps> getCcapIID() {
        return this.ccapIID;
    }

    public void setCcapIID(InstanceIdentifier<Ccaps> ccapIID) {
        this.ccapIID = ccapIID;
    }

    public Ccaps getCcapBase() {
        return this.ccapBase;
    }

    public void setCcapBase(Ccaps ccapBase) {
        this.ccapBase = ccapBase;
    }

    public InstanceIdentifier<Gates> getGateIID() {
        return this.gateIID;
    }

    public void setGateIID(InstanceIdentifier<Gates> gateIID) {
        this.gateIID = gateIID;
    }

    public Gates getGateBase() {
        return this.gateBase;
    }

    public void setGateBase(Gates gateBase) {
        this.gateBase = gateBase;
    }

    public void setResponse(InstanceIdentifier<Ccaps> ccapIID, Ccaps ccapBase, String message) {
        CcapsBuilder ccapBuilder = new CcapsBuilder(ccapBase);
        ccapBuilder.setResponse(message);
        Ccaps ccap = ccapBuilder.build();
        WriteTransaction writeTx = this.dataBroker.newWriteOnlyTransaction();
        writeTx.merge(LogicalDatastoreType.CONFIGURATION, ccapIID, (DataObject)ccap, true);
        writeTx.commit();
        this.logger.debug("Response.setResponse(ccap) complete {} {} {}", new Object[]{message, ccap, ccapIID});
    }

    public void setResponse(InstanceIdentifier<Gates> gateIID, Gates gateBase, String message) {
        GatesBuilder gateBuilder = new GatesBuilder(gateBase);
        gateBuilder.setResponse(message);
        Gates gate = gateBuilder.build();
        WriteTransaction writeTx = this.dataBroker.newWriteOnlyTransaction();
        writeTx.merge(LogicalDatastoreType.CONFIGURATION, gateIID, (DataObject)gate, true);
        writeTx.commit();
        this.logger.debug("Response.setResponse(gate) complete: {} {} {}", new Object[]{message, gate, gateIID});
    }

    @Override
    public void run() {
        if (this.ccapIID != null) {
            this.setResponse(this.ccapIID, this.ccapBase, this.message);
        } else if (this.gateIID != null) {
            this.setResponse(this.gateIID, this.gateBase, this.message);
        } else {
            this.logger.error("Unknown Response: must be for a CCAP or Gate instance");
        }
    }
}

