/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.packetcable.provider.PCMMService;
import org.opendaylight.controller.packetcable.provider.Response;
import org.opendaylight.controller.packetcable.provider.Subnet;
import org.opendaylight.controller.packetcable.provider.ValidateInstanceData;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Ccap;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.Qos;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.CcapsKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.AppsKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.Subs;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.SubsKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.GatesKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PacketcableProvider
implements DataChangeListener,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PacketcableProvider.class);
    public static final InstanceIdentifier<Ccap> ccapIID = InstanceIdentifier.builder(Ccap.class).build();
    public static final InstanceIdentifier<Qos> qosIID = InstanceIdentifier.builder(Qos.class).build();
    private final DataBroker dataBroker;
    private final ExecutorService executor;
    private final Map<String, Ccaps> ccapMap = new ConcurrentHashMap<String, Ccaps>();
    private final Map<String, Gates> gateMap = new ConcurrentHashMap<String, Gates>();
    private final Map<String, String> gateCcapMap = new ConcurrentHashMap<String, String>();
    private final Map<Subnet, Ccaps> subscriberSubnetsMap = new ConcurrentHashMap<Subnet, Ccaps>();
    private final Map<ServiceClassName, List<Ccaps>> downstreamScnMap = new ConcurrentHashMap<ServiceClassName, List<Ccaps>>();
    private final Map<ServiceClassName, List<Ccaps>> upstreamScnMap = new ConcurrentHashMap<ServiceClassName, List<Ccaps>>();
    private final Map<String, PCMMService> pcmmServiceMap = new ConcurrentHashMap<String, PCMMService>();

    public PacketcableProvider(DataBroker dataBroker) {
        logger.info("Starting provider");
        this.dataBroker = dataBroker;
        this.executor = Executors.newCachedThreadPool();
    }

    @Override
    public void close() throws ExecutionException, InterruptedException {
        this.executor.shutdown();
        if (this.dataBroker != null) {
            ReadWriteTransaction tx = this.dataBroker.newReadWriteTransaction();
            tx.delete(LogicalDatastoreType.CONFIGURATION, ccapIID);
            tx.delete(LogicalDatastoreType.CONFIGURATION, qosIID);
            tx.commit().get();
        }
    }

    public InetAddress getInetAddress(String subId) {
        try {
            return InetAddress.getByName(subId);
        }
        catch (UnknownHostException e) {
            logger.error("getInetAddress: {} FAILED: {}", (Object)subId, (Object)e.getMessage());
            return null;
        }
    }

    private String getIpPrefixStr(IpPrefix ipPrefix) {
        Ipv4Prefix ipv4 = ipPrefix.getIpv4Prefix();
        if (ipv4 != null) {
            return ipv4.getValue();
        }
        return ipPrefix.getIpv6Prefix().getValue();
    }

    private void updateCcapMaps(Ccaps ccap) {
        ArrayList<Ccaps> ccapList;
        for (IpPrefix ipPrefix : ccap.getSubscriberSubnets()) {
            try {
                this.subscriberSubnetsMap.put(Subnet.createInstance(this.getIpPrefixStr(ipPrefix)), ccap);
            }
            catch (UnknownHostException e) {
                logger.error("updateSubscriberSubnets: {}:{} FAILED: {}", new Object[]{ipPrefix, ccap, e.getMessage()});
            }
        }
        for (ServiceClassName scn : ccap.getUpstreamScns()) {
            if (this.upstreamScnMap.containsKey(scn)) {
                this.upstreamScnMap.get(scn).add(ccap);
                continue;
            }
            ccapList = new ArrayList<Ccaps>();
            ccapList.add(ccap);
            this.upstreamScnMap.put(scn, ccapList);
        }
        for (ServiceClassName scn : ccap.getDownstreamScns()) {
            if (this.downstreamScnMap.containsKey(scn)) {
                this.downstreamScnMap.get(scn).add(ccap);
                continue;
            }
            ccapList = new ArrayList();
            ccapList.add(ccap);
            this.downstreamScnMap.put(scn, ccapList);
        }
    }

    private void removeCcapFromAllMaps(Ccaps ccap) {
        List ccapList;
        for (Map.Entry<Subnet, Ccaps> entry : this.subscriberSubnetsMap.entrySet()) {
            if (entry.getValue() != ccap) continue;
            this.subscriberSubnetsMap.remove(entry.getKey());
        }
        for (Map.Entry<Subnet, Object> entry : this.upstreamScnMap.entrySet()) {
            ccapList = (List)entry.getValue();
            ccapList.remove(ccap);
            if (!ccapList.isEmpty()) continue;
            this.upstreamScnMap.remove(entry.getKey());
        }
        for (Map.Entry<Subnet, Object> entry : this.downstreamScnMap.entrySet()) {
            ccapList = (List)entry.getValue();
            ccapList.remove(ccap);
            if (!ccapList.isEmpty()) continue;
            this.downstreamScnMap.remove(entry.getKey());
        }
        PCMMService service = this.pcmmServiceMap.remove(ccap.getCcapId());
        if (service != null) {
            service.disconect();
        }
    }

    private Ccaps findCcapForSubscriberId(InetAddress inetAddr) {
        Ccaps matchedCcap = null;
        int longestPrefixLen = -1;
        for (Map.Entry<Subnet, Ccaps> entry : this.subscriberSubnetsMap.entrySet()) {
            int prefixLen;
            Subnet subnet = entry.getKey();
            if (!subnet.isInNet(inetAddr) || (prefixLen = subnet.getPrefixLen()) <= longestPrefixLen) continue;
            matchedCcap = entry.getValue();
            longestPrefixLen = prefixLen;
        }
        return matchedCcap;
    }

    private ServiceFlowDirection findScnOnCcap(ServiceClassName scn, Ccaps ccap) {
        List<Ccaps> ccapList;
        if (this.upstreamScnMap.containsKey(scn)) {
            List<Ccaps> ccapList2 = this.upstreamScnMap.get(scn);
            if (ccapList2.contains(ccap)) {
                return ServiceFlowDirection.Us;
            }
        } else if (this.downstreamScnMap.containsKey(scn) && (ccapList = this.downstreamScnMap.get(scn)).contains(ccap)) {
            return ServiceFlowDirection.Ds;
        }
        return null;
    }

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> change) {
        logger.info("onDataChanged");
        if (!change.getCreatedData().isEmpty()) {
            if (!new ValidateInstanceData(this.dataBroker, change.getCreatedData()).validateYang()) {
                return;
            }
            this.onCreate(new InstanceData(change.getCreatedData()));
        } else if (!change.getRemovedPaths().isEmpty()) {
            this.onRemove(new InstanceData(change.getRemovedPaths()));
        } else if (!change.getUpdatedData().isEmpty()) {
            if (new ValidateInstanceData(this.dataBroker, change.getUpdatedData()).isResponseEcho()) {
                return;
            }
            this.onUpdate(new InstanceData(change.getUpdatedData()));
        } else {
            logger.error("onDataChanged(): Unknown change action: " + change);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onCreate(InstanceData thisData) {
        logger.info("onCreate(): " + thisData);
        if (!thisData.ccapIidMap.isEmpty()) {
            Iterator<Map.Entry<InstanceIdentifier<Ccaps>, Ccaps>> i$ = thisData.ccapIidMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<InstanceIdentifier<Ccaps>, Ccaps> entry = i$.next();
                Ccaps thisCcap = entry.getValue();
                String ccapId = thisCcap.getCcapId();
                if (this.pcmmServiceMap.get(thisCcap.getCcapId()) != null) {
                    logger.error("Already monitoring CCAP - " + thisCcap);
                    return;
                }
                PCMMService pcmmService = new PCMMService(-32758, thisCcap);
                this.pcmmServiceMap.put(thisCcap.getCcapId(), pcmmService);
                String message = pcmmService.addCcap();
                if (message.contains("200 OK")) {
                    this.ccapMap.put(ccapId, thisCcap);
                    this.updateCcapMaps(thisCcap);
                    logger.info("Created CCAP: {}/{} : {}", new Object[]{thisData.gatePath, thisCcap, message});
                    logger.info("Created CCAP: {} : {}", (Object)thisData.gatePath, (Object)message);
                } else {
                    logger.error("Create CCAP Failed: {} : {}", (Object)thisData.gatePath, (Object)message);
                }
                this.executor.execute(new Response(this.dataBroker, entry.getKey(), thisCcap, message));
            }
            return;
        }
        Iterator<Map.Entry<InstanceIdentifier<Gates>, Gates>> i$ = thisData.gateIidMap.entrySet().iterator();
        while (i$.hasNext()) {
            Gates gate;
            String message;
            Map.Entry<InstanceIdentifier<Gates>, Gates> entry;
            block12: {
                String gatePathStr;
                String gateId;
                block13: {
                    block14: {
                        entry = i$.next();
                        message = null;
                        gate = entry.getValue();
                        gateId = gate.getGateId();
                        gatePathStr = thisData.gatePath + "/" + gateId;
                        InetAddress subId = this.getInetAddress(thisData.subId);
                        if (subId == null) break block13;
                        Ccaps thisCcap = this.findCcapForSubscriberId(subId);
                        if (thisCcap == null) break block14;
                        String ccapId = thisCcap.getCcapId();
                        ServiceClassName scn = gate.getTrafficProfile().getServiceClassName();
                        if (scn != null) {
                            ServiceFlowDirection scnDir = this.findScnOnCcap(scn, thisCcap);
                            if (scnDir != null) {
                                if (this.pcmmServiceMap.get(thisCcap.getCcapId()) == null) {
                                    logger.error("Unable to locate PCMM Service for CCAP - " + thisCcap);
                                    return;
                                }
                                message = this.pcmmServiceMap.get(thisCcap.getCcapId()).sendGateSet(gatePathStr, subId, gate, scnDir);
                                this.gateMap.put(gatePathStr, gate);
                                this.gateCcapMap.put(gatePathStr, thisCcap.getCcapId());
                                if (message.contains("200 OK")) {
                                    logger.info("Created QoS gate {} for {}/{}/{} - {}", new Object[]{gateId, ccapId, gatePathStr, gate, message});
                                    logger.info("Created QoS gate {} for {}/{} - {}", new Object[]{gateId, ccapId, gatePathStr, message});
                                    break block12;
                                } else {
                                    logger.info("Unable to create QoS gate {} for {}/{}/{} - {}", new Object[]{gateId, ccapId, gatePathStr, gate, message});
                                    logger.error("Unable to create QoS gate {} for {}/{} - {}", new Object[]{gateId, ccapId, gatePathStr, message});
                                }
                                break block12;
                            } else {
                                logger.error("PCMMService: sendGateSet(): SCN {} not found on CCAP {} for {}/{}", new Object[]{scn.getValue(), thisCcap, gatePathStr, gate});
                                message = String.format("404 Not Found - SCN %s not found on CCAP %s for %s", scn.getValue(), thisCcap.getCcapId(), gatePathStr);
                            }
                        }
                        break block12;
                    }
                    String subIdStr = thisData.subId;
                    message = String.format("404 Not Found - no CCAP found for subscriber %s in %s", subIdStr, gatePathStr);
                    logger.info("Create QoS gate {} FAILED: no CCAP found for subscriber {}: @ {}/{}", new Object[]{gateId, subIdStr, gatePathStr, gate});
                    logger.error("Create QoS gate {} FAILED: no CCAP found for subscriber {}: @ {}", new Object[]{gateId, subIdStr, gatePathStr});
                    break block12;
                }
                String subIdStr = thisData.subId;
                message = String.format("400 Bad Request - subId must be a valid IP address for subscriber %s in %s", subIdStr, gatePathStr);
                logger.info("Create QoS gate {} FAILED: subId must be a valid IP address for subscriber {}: @ {}/{}", new Object[]{gateId, subIdStr, gatePathStr, gate});
                logger.error("Create QoS gate {} FAILED: subId must be a valid IP address for subscriber {}: @ {}", new Object[]{gateId, subIdStr, gatePathStr});
            }
            this.executor.execute(new Response(this.dataBroker, entry.getKey(), gate, message));
        }
    }

    private void onRemove(InstanceData thisData) {
        logger.info("onRemove(): " + thisData);
        for (String gatePathStr : thisData.removePathList) {
            if (!this.gateMap.containsKey(gatePathStr)) continue;
            Gates thisGate = this.gateMap.remove(gatePathStr);
            String gateId = thisGate.getGateId();
            String ccapId = this.gateCcapMap.remove(gatePathStr);
            Ccaps thisCcap = this.ccapMap.get(ccapId);
            PCMMService service = this.pcmmServiceMap.get(thisCcap.getCcapId());
            if (service != null) {
                service.sendGateDelete(gatePathStr);
                logger.info("onDataChanged(): removed QoS gate {} for {}/{}/{}: ", new Object[]{gateId, ccapId, gatePathStr, thisGate});
                logger.info("onDataChanged(): removed QoS gate {} for {}/{}: ", new Object[]{gateId, ccapId, gatePathStr});
                continue;
            }
            logger.warn("Unable to send to locate PCMMService to send gate delete message with CCAP - " + thisCcap);
        }
        for (String ccapIdStr : thisData.removePathList) {
            if (!this.ccapMap.containsKey(ccapIdStr)) continue;
            Ccaps thisCcap = this.ccapMap.remove(ccapIdStr);
            this.removeCcapFromAllMaps(thisCcap);
        }
    }

    private void onUpdate(InstanceData oldData) {
        logger.info("onUpdate(): " + oldData);
        if (!oldData.ccapIidMap.isEmpty()) {
            for (Map.Entry<InstanceIdentifier<Ccaps>, Ccaps> entry : oldData.ccapIidMap.entrySet()) {
                Ccaps ccap = entry.getValue();
                String ccapId = ccap.getCcapId();
                String message = String.format("405 Method Not Allowed - %s: CCAP update not permitted (use delete); ", ccapId);
                message = message + ccap.getResponse();
                this.executor.execute(new Response(this.dataBroker, entry.getKey(), ccap, message));
                logger.error("onDataChanged(): CCAP update not permitted {}/{}", (Object)ccapId, (Object)ccap);
            }
        } else {
            for (Map.Entry<InstanceIdentifier<Gates>, Gates> entry : oldData.gateIidMap.entrySet()) {
                Gates gate = entry.getValue();
                String gatePathStr = oldData.gatePath + "/" + gate.getGateId();
                String message = String.format("405 Method Not Allowed - %s: QoS Gate update not permitted (use delete); ", gatePathStr);
                message = message + gate.getResponse();
                this.executor.execute(new Response(this.dataBroker, entry.getKey(), gate, message));
                logger.error("onDataChanged(): QoS Gate update not permitted: {}/{}", (Object)gatePathStr, (Object)gate);
            }
        }
    }

    private class InstanceData {
        public final Map<InstanceIdentifier<Ccaps>, Ccaps> ccapIidMap = new HashMap<InstanceIdentifier<Ccaps>, Ccaps>();
        public String subId;
        public final Map<String, String> gatePathMap = new HashMap<String, String>();
        public String gatePath;
        public final Map<InstanceIdentifier<Gates>, Gates> gateIidMap = new HashMap<InstanceIdentifier<Gates>, Gates>();
        public final Set<String> removePathList = new HashSet<String>();

        public InstanceData(Map<InstanceIdentifier<?>, DataObject> thisData) {
            this.getCcaps(thisData);
            if (this.ccapIidMap.isEmpty()) {
                this.getGates(thisData);
                if (!this.gateIidMap.isEmpty()) {
                    this.gatePath = this.gatePathMap.get("appId") + "/" + this.gatePathMap.get("subId");
                }
            }
        }

        public InstanceData(Set<InstanceIdentifier<?>> thisData) {
            for (InstanceIdentifier<?> removeThis : thisData) {
                this.getGatePathMap(removeThis);
                if (this.gatePathMap.containsKey("ccapId")) {
                    this.gatePath = this.gatePathMap.get("ccapId");
                    this.removePathList.add(this.gatePath);
                    continue;
                }
                if (!this.gatePathMap.containsKey("gateId")) continue;
                this.gatePath = this.gatePathMap.get("appId") + "/" + this.gatePathMap.get("subId") + "/" + this.gatePathMap.get("gateId");
                this.removePathList.add(this.gatePath);
            }
        }

        private void getGatePathMap(InstanceIdentifier<?> thisInstance) {
            logger.info("onDataChanged().getGatePathMap(): " + thisInstance);
            try {
                InstanceIdentifier ccapInstance = thisInstance.firstIdentifierOf(Ccaps.class);
                if (ccapInstance != null) {
                    CcapsKey ccapKey = (CcapsKey)InstanceIdentifier.keyOf((InstanceIdentifier)ccapInstance);
                    if (ccapKey != null) {
                        this.gatePathMap.put("ccapId", ccapKey.getCcapId());
                    }
                } else {
                    GatesKey gateKey;
                    InstanceIdentifier gatesInstance;
                    SubsKey subKey;
                    InstanceIdentifier subsInstance;
                    AppsKey appKey;
                    InstanceIdentifier appsInstance = thisInstance.firstIdentifierOf(Apps.class);
                    if (appsInstance != null && (appKey = (AppsKey)InstanceIdentifier.keyOf((InstanceIdentifier)appsInstance)) != null) {
                        this.gatePathMap.put("appId", appKey.getAppId());
                    }
                    if ((subsInstance = thisInstance.firstIdentifierOf(Subs.class)) != null && (subKey = (SubsKey)InstanceIdentifier.keyOf((InstanceIdentifier)subsInstance)) != null) {
                        this.subId = subKey.getSubId();
                        this.gatePathMap.put("subId", this.subId);
                    }
                    if ((gatesInstance = thisInstance.firstIdentifierOf(Gates.class)) != null && (gateKey = (GatesKey)InstanceIdentifier.keyOf((InstanceIdentifier)gatesInstance)) != null) {
                        this.gatePathMap.put("gateId", gateKey.getGateId());
                    }
                }
            }
            catch (ClassCastException err) {
                logger.warn("Unexpected exception", (Throwable)err);
            }
        }

        private void getCcaps(Map<InstanceIdentifier<?>, DataObject> thisData) {
            logger.info("onDataChanged().getCcaps(): " + thisData);
            for (Map.Entry<InstanceIdentifier<?>, DataObject> entry : thisData.entrySet()) {
                if (!(entry.getValue() instanceof Ccaps)) continue;
                this.ccapIidMap.put(entry.getKey(), (Ccaps)entry.getValue());
            }
        }

        private void getGates(Map<InstanceIdentifier<?>, DataObject> thisData) {
            logger.info("onDataChanged().getGates(): " + thisData);
            for (Map.Entry<InstanceIdentifier<?>, DataObject> entry : thisData.entrySet()) {
                if (!(entry.getValue() instanceof Gates)) continue;
                Gates gate = (Gates)entry.getValue();
                InstanceIdentifier<?> gateIID = entry.getKey();
                this.getGatePathMap(gateIID);
                this.gateIidMap.put(gateIID, gate);
            }
        }
    }
}

