/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.packetcable.provider.PCMMGateReqBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.Ccaps;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates;
import org.pcmm.PCMMPdpAgent;
import org.pcmm.PCMMPdpDataProcess;
import org.pcmm.PCMMPdpMsgSender;
import org.pcmm.gates.IPCMMGate;
import org.pcmm.gates.impl.PCMMGateReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umu.cops.prpdp.COPSPdpException;
import org.umu.cops.stack.COPSError;

@ThreadSafe
public class PCMMService {
    private Logger logger = LoggerFactory.getLogger(PCMMService.class);
    private final Ccaps ccap;
    private final IpAddress ipAddr;
    private final PortNumber portNum;
    protected final CcapClient ccapClient;
    protected Map<String, PCMMGateReq> gateRequests = Maps.newConcurrentMap();
    private final short clientType;

    public PCMMService(short clientType, Ccaps ccap) {
        this.clientType = clientType;
        this.ccap = ccap;
        this.ipAddr = ccap.getConnection().getIpAddress();
        this.portNum = ccap.getConnection().getPort();
        this.ccapClient = new CcapClient(this.ipAddr, this.portNum);
        this.logger.info("Attempting to add CCAP with ID {} @ {}:{}", new Object[]{ccap.getCcapId(), this.ipAddr.getIpv4Address().getValue(), this.portNum.getValue()});
    }

    public void disconect() {
        this.ccapClient.disconnect();
    }

    public String addCcap() {
        this.ccapClient.connect();
        if (this.ccapClient.isConnected.booleanValue()) {
            this.logger.info("Connected to CCAP with ID - " + this.ccap.getCcapId());
            return String.format("200 OK - CCAP %s connected @ %s:%d", this.ccap.getCcapId(), this.ipAddr.getIpv4Address().getValue(), this.portNum.getValue());
        }
        return String.format("404 Not Found - CCAP %s failed to connect @ %s:%d - %s", this.ccap.getCcapId(), this.ipAddr.getIpv4Address().getValue(), this.portNum.getValue(), this.ccapClient.errMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendGateSet(String gatePathStr, InetAddress subId, Gates qosGate, ServiceFlowDirection scnDir) {
        this.logger.info("Sending gate to CCAP with ID - " + this.ccap.getCcapId());
        PCMMGateReqBuilder gateBuilder = new PCMMGateReqBuilder();
        gateBuilder.build(this.ccap.getAmId());
        gateBuilder.build(subId);
        ServiceClassName scn = qosGate.getTrafficProfile().getServiceClassName();
        if (scn != null) {
            gateBuilder.build(qosGate.getGateSpec(), scnDir);
        } else {
            gateBuilder.build(qosGate.getGateSpec(), null);
        }
        gateBuilder.build(qosGate.getTrafficProfile());
        if (qosGate.getClassifier() != null) {
            gateBuilder.build(qosGate.getClassifier());
        } else if (qosGate.getExtClassifier() != null) {
            gateBuilder.build(qosGate.getExtClassifier());
        } else if (qosGate.getIpv6Classifier() != null) {
            gateBuilder.build(qosGate.getIpv6Classifier());
        }
        PCMMGateReq gateReq = gateBuilder.getGateReq();
        if (this.gateRequests.get(gatePathStr) == null) {
            this.gateRequests.put(gatePathStr, gateReq);
            this.ccapClient.sendGateSet(gateReq);
            try {
                PCMMGateReq pCMMGateReq = gateReq;
                synchronized (pCMMGateReq) {
                    this.logger.info("Waiting 5000ms for gate request to be updated");
                    gateReq.wait(5000L);
                    this.logger.debug("Gate request error - " + gateReq.getError());
                    this.logger.debug("Gate request ID - " + gateReq.getGateID());
                }
            }
            catch (Exception e) {
                this.logger.error("PCMMService: sendGateSet(): gate response timeout exceeded for " + gatePathStr + '/' + gateReq, (Throwable)e);
                return String.format("408 Request Timeout - gate response timeout exceeded for %s/%s", this.ccap.getCcapId(), gatePathStr);
            }
            if (gateReq.getError() != null) {
                this.logger.error("PCMMService: sendGateSet(): returned error: {}", (Object)gateReq.getError().toString());
                return String.format("404 Not Found - sendGateSet for %s/%s returned error - %s", this.ccap.getCcapId(), gatePathStr, gateReq.getError().toString());
            }
            if (gateReq.getGateID() != null) {
                this.logger.info(String.format("PCMMService: sendGateSet(): returned GateId %08x: ", gateReq.getGateID().getGateID()));
                return String.format("200 OK - sendGateSet for %s/%s returned GateId %08x", this.ccap.getCcapId(), gatePathStr, gateReq.getGateID().getGateID());
            }
            this.logger.info("PCMMService: sendGateSet(): no gateId returned:");
            return String.format("404 Not Found - sendGateSet for %s/%s no gateId returned", this.ccap.getCcapId(), gatePathStr);
        }
        this.logger.info("PCMMService: sendGateSet(): no gateId returned:");
        return String.format("404 Not Found - sendGateSet for %s/%s already exists", this.ccap.getCcapId(), gatePathStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean sendGateDelete(String gatePathStr) {
        this.logger.info("sendGateDelete() - " + this.ccap);
        PCMMGateReq gateReq = this.gateRequests.remove(gatePathStr);
        if (gateReq != null) {
            this.ccapClient.sendGateDelete(gateReq);
            try {
                PCMMGateReq pCMMGateReq = gateReq;
                synchronized (pCMMGateReq) {
                    gateReq.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                this.logger.error("PCMMService: sendGateDelete(): gate response timeout exceeded for {}/{}", (Object)gatePathStr, (Object)gateReq);
            }
            if (gateReq.getError() != null) {
                this.logger.warn("PCMMService: sendGateDelete(): returned error: {}", (Object)gateReq.getError().toString());
                return false;
            }
            if (gateReq.getGateID() != null) {
                this.logger.info(String.format("PCMMService: sendGateDelete(): deleted GateId %08x: ", gateReq.getGateID().getGateID()));
            } else {
                this.logger.error("PCMMService: sendGateDelete(): deleted but no gateId returned");
            }
            return true;
        }
        this.logger.warn("Attempt to delete non-existent gate with path - " + gatePathStr);
        return false;
    }

    protected class CcapClient {
        public final PCMMPdpDataProcess pcmmProcess;
        public final PCMMPdpAgent pcmmPdp;
        private final String ipv4;
        private final Integer port;
        protected transient PCMMPdpMsgSender pcmmSender;
        private transient Boolean isConnected = false;
        private transient String errMessage = null;

        public CcapClient(IpAddress ccapIp, PortNumber portNum) {
            this.ipv4 = ccapIp.getIpv4Address().getValue();
            this.port = portNum != null ? portNum.getValue() : Integer.valueOf(3918);
            this.pcmmProcess = null;
            this.pcmmPdp = new PCMMPdpAgent(this.ipv4, this.port.intValue(), PCMMService.this.clientType, this.pcmmProcess);
        }

        public void connect() {
            PCMMService.this.logger.info("Attempting to connect to host: " + this.ipv4 + " port: " + this.port);
            try {
                this.pcmmPdp.connect();
                this.pcmmSender = new PCMMPdpMsgSender(PCMMService.this.clientType, this.pcmmPdp.getClientHandle(), this.pcmmPdp.getSocket());
                this.isConnected = true;
            }
            catch (Exception e) {
                this.isConnected = false;
                PCMMService.this.logger.error("Failed to connect to host: " + this.ipv4 + " port: " + this.port, (Throwable)e);
                this.errMessage = e.getMessage();
            }
        }

        public void disconnect() {
            PCMMService.this.logger.info("CcapClient: disconnect(): {}:{}", (Object)this.ipv4, (Object)this.port);
            this.pcmmPdp.disconnect(new COPSError(COPSError.ErrorTypes.SHUTTING_DOWN, COPSError.ErrorTypes.NA));
            this.isConnected = false;
        }

        public Boolean sendGateSet(PCMMGateReq gateReq) {
            PCMMService.this.logger.info("CcapClient: sendGateSet(): {}:{} => {}", new Object[]{this.ipv4, this.port, gateReq});
            try {
                this.pcmmSender.sendGateSet((IPCMMGate)gateReq);
            }
            catch (COPSPdpException e) {
                PCMMService.this.logger.error("CcapClient: sendGateSet(): {}:{} => {} FAILED:", new Object[]{this.ipv4, this.port, gateReq, e});
            }
            gateReq.setGateID(this.pcmmSender.getGateID());
            return true;
        }

        public Boolean sendGateDelete(PCMMGateReq gateReq) {
            PCMMService.this.logger.info("CcapClient: sendGateDelete(): {}:{} => {}", new Object[]{this.ipv4, this.port, gateReq});
            try {
                this.pcmmSender.sendGateDelete((IPCMMGate)gateReq);
            }
            catch (COPSPdpException e) {
                PCMMService.this.logger.error("CcapClient: sendGateDelete(): {}:{} => {} FAILED: {}", new Object[]{this.ipv4, this.port, gateReq, e.getMessage()});
            }
            return true;
        }
    }
}

