/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.packetcable.provider;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceFlowDirection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmId;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.traffic.profile.TrafficProfile;
import org.pcmm.gates.IAMID;
import org.pcmm.gates.IClassifier;
import org.pcmm.gates.IGateSpec;
import org.pcmm.gates.ISubscriberID;
import org.pcmm.gates.ITrafficProfile;
import org.pcmm.gates.impl.AMID;
import org.pcmm.gates.impl.DOCSISServiceClassNameTrafficProfile;
import org.pcmm.gates.impl.ExtendedClassifier;
import org.pcmm.gates.impl.GateSpec;
import org.pcmm.gates.impl.IPv6Classifier;
import org.pcmm.gates.impl.PCMMGateReq;
import org.pcmm.gates.impl.SubscriberID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCMMGateReqBuilder {
    private Logger logger = LoggerFactory.getLogger(PCMMGateReqBuilder.class);
    private PCMMGateReq gateReq = new PCMMGateReq();

    public PCMMGateReq getGateReq() {
        return this.gateReq;
    }

    public void build(AmId qosAmId) {
        AMID amId = new AMID();
        amId.setApplicationMgrTag(qosAmId.getAmTag().shortValue());
        amId.setApplicationType(qosAmId.getAmType().shortValue());
        this.gateReq.setAMID((IAMID)amId);
    }

    public void build(InetAddress qosSubId) {
        SubscriberID subId = new SubscriberID();
        subId.setSourceIPAddress(qosSubId);
        this.gateReq.setSubscriberID((ISubscriberID)subId);
    }

    public void build(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec qosGateSpec, ServiceFlowDirection scnDirection) {
        GateSpec gateSpec = new GateSpec();
        ServiceFlowDirection qosDir = null;
        IGateSpec.Direction gateDir = null;
        if (scnDirection != null) {
            qosDir = scnDirection;
        } else if (qosGateSpec.getDirection() != null) {
            qosDir = qosGateSpec.getDirection();
        }
        if (qosDir == ServiceFlowDirection.Ds) {
            gateDir = IGateSpec.Direction.DOWNSTREAM;
        } else if (qosDir == ServiceFlowDirection.Us) {
            gateDir = IGateSpec.Direction.UPSTREAM;
        }
        gateSpec.setDirection(gateDir);
        TosByte tosOverwrite = qosGateSpec.getDscpTosOverwrite();
        if (tosOverwrite != null) {
            byte gateTos = tosOverwrite.getValue().byteValue();
            gateSpec.setDSCP_TOSOverwrite(IGateSpec.DSCPTOS.ENABLE);
            gateSpec.setDSCP_TOSOverwrite(gateTos);
            TosByte tosMask = qosGateSpec.getDscpTosMask();
            if (tosMask != null) {
                byte gateTosMask = tosMask.getValue().byteValue();
                gateSpec.setDSCP_TOSMask(gateTosMask);
            } else {
                gateSpec.setDSCP_TOSMask((byte)-1);
            }
        }
        this.gateReq.setGateSpec((IGateSpec)gateSpec);
    }

    public void build(TrafficProfile qosTrafficProfile) {
        if (qosTrafficProfile.getServiceClassName() != null) {
            String scn = qosTrafficProfile.getServiceClassName().getValue();
            DOCSISServiceClassNameTrafficProfile trafficProfile = new DOCSISServiceClassNameTrafficProfile();
            if (scn.length() <= 16) {
                trafficProfile.setServiceClassName(scn);
                this.gateReq.setTrafficProfile((ITrafficProfile)trafficProfile);
            }
        }
    }

    private InetAddress getByName(String ipAddressStr) {
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipAddressStr);
        }
        catch (UnknownHostException e) {
            this.logger.error(e.getMessage());
        }
        return ipAddress;
    }

    public void build(Classifier qosClassifier) {
        InetAddress dip;
        InetAddress sip;
        org.pcmm.gates.impl.Classifier classifier = new org.pcmm.gates.impl.Classifier();
        classifier.setPriority((byte)64);
        if (qosClassifier.getProtocol() != null) {
            classifier.setProtocol(qosClassifier.getProtocol().getValue().shortValue());
        }
        if (qosClassifier.getSrcIp() != null && (sip = this.getByName(qosClassifier.getSrcIp().getValue())) != null) {
            classifier.setSourceIPAddress(sip);
        }
        if (qosClassifier.getDstIp() != null && (dip = this.getByName(qosClassifier.getDstIp().getValue())) != null) {
            classifier.setDestinationIPAddress(dip);
        }
        if (qosClassifier.getSrcPort() != null) {
            classifier.setSourcePort(qosClassifier.getSrcPort().getValue().shortValue());
        }
        if (qosClassifier.getDstPort() != null) {
            classifier.setDestinationPort(qosClassifier.getDstPort().getValue().shortValue());
        }
        if (qosClassifier.getTosByte() != null) {
            classifier.setDSCPTOS(qosClassifier.getTosByte().getValue().byteValue());
            if (qosClassifier.getTosMask() != null) {
                classifier.setDSCPTOSMask(qosClassifier.getTosMask().getValue().byteValue());
            } else {
                classifier.setDSCPTOSMask((byte)-1);
            }
        }
        this.gateReq.setClassifier((IClassifier)classifier);
    }

    public void build(ExtClassifier qosExtClassifier) {
        InetAddress dip;
        InetAddress sip;
        ExtendedClassifier extClassifier = new ExtendedClassifier();
        extClassifier.setPriority((byte)64);
        extClassifier.setActivationState((byte)1);
        if (qosExtClassifier.getProtocol() != null) {
            extClassifier.setProtocol(qosExtClassifier.getProtocol().getValue().shortValue());
        } else {
            extClassifier.setProtocol((short)0);
        }
        if (qosExtClassifier.getSrcIp() != null && (sip = this.getByName(qosExtClassifier.getSrcIp().getValue())) != null) {
            extClassifier.setSourceIPAddress(sip);
            if (qosExtClassifier.getSrcIpMask() != null) {
                InetAddress sipMask = this.getByName(qosExtClassifier.getSrcIpMask().getValue());
                extClassifier.setIPSourceMask(sipMask);
            } else {
                extClassifier.setIPSourceMask(this.getByName("255.255.255.255"));
            }
        }
        if (qosExtClassifier.getDstIp() != null && (dip = this.getByName(qosExtClassifier.getDstIp().getValue())) != null) {
            extClassifier.setDestinationIPAddress(dip);
            if (qosExtClassifier.getDstIpMask() != null) {
                InetAddress dipMask = this.getByName(qosExtClassifier.getDstIpMask().getValue());
                extClassifier.setIPDestinationMask(dipMask);
            } else {
                extClassifier.setIPDestinationMask(this.getByName("255.255.255.255"));
            }
        }
        short startPort = 0;
        short endPort = -1;
        if (qosExtClassifier.getSrcPortStart() != null) {
            endPort = startPort = qosExtClassifier.getSrcPortStart().getValue().shortValue();
            if (qosExtClassifier.getSrcPortEnd() != null) {
                endPort = qosExtClassifier.getSrcPortEnd().getValue().shortValue();
            }
            if (startPort > endPort) {
                this.logger.warn("Start port %d > End port %d in ext-classifier source port range -- forcing to same", (Object)startPort, (Object)endPort);
                endPort = startPort;
            }
        }
        extClassifier.setSourcePortStart(startPort);
        extClassifier.setSourcePortEnd(endPort);
        startPort = 0;
        endPort = -1;
        if (qosExtClassifier.getDstPortStart() != null) {
            endPort = startPort = qosExtClassifier.getDstPortStart().getValue().shortValue();
            if (qosExtClassifier.getDstPortEnd() != null) {
                endPort = qosExtClassifier.getDstPortEnd().getValue().shortValue();
            }
            if (startPort > endPort) {
                this.logger.warn("Start port %d > End port %d in ext-classifier destination port range -- forcing to same", (Object)startPort, (Object)endPort);
                endPort = startPort;
            }
        }
        extClassifier.setDestinationPortStart(startPort);
        extClassifier.setDestinationPortEnd(endPort);
        if (qosExtClassifier.getTosByte() != null) {
            extClassifier.setDSCPTOS((byte)(qosExtClassifier.getTosByte().getValue().byteValue() | 1));
            if (qosExtClassifier.getTosMask() != null) {
                extClassifier.setDSCPTOSMask(qosExtClassifier.getTosMask().getValue().byteValue());
            } else {
                extClassifier.setDSCPTOSMask((byte)-1);
            }
        }
        this.gateReq.setClassifier((IClassifier)extClassifier);
    }

    public void build(Ipv6Classifier qosIpv6Classifier) {
        byte prefLen;
        String Ipv6AddressStr;
        String[] parts;
        IPv6Classifier ipv6Classifier = new IPv6Classifier();
        ipv6Classifier.setPriority((byte)64);
        ipv6Classifier.setActivationState((byte)1);
        if (qosIpv6Classifier.getFlowLabel() != null) {
            ipv6Classifier.setFlowLabel(qosIpv6Classifier.getFlowLabel());
            ipv6Classifier.setFlowLabelEnableFlag((byte)1);
        }
        if (qosIpv6Classifier.getNextHdr() != null) {
            ipv6Classifier.setNextHdr(qosIpv6Classifier.getNextHdr().getValue().shortValue());
        } else {
            ipv6Classifier.setNextHdr((short)256);
        }
        if (qosIpv6Classifier.getSrcIp6() != null) {
            parts = qosIpv6Classifier.getSrcIp6().getValue().split("/");
            Ipv6AddressStr = parts[0];
            InetAddress sip6 = this.getByName(Ipv6AddressStr);
            if (sip6 != null) {
                ipv6Classifier.setSourceIPAddress(sip6);
            }
            prefLen = -128;
            if (parts.length > 1) {
                prefLen = (byte)Integer.parseInt(parts[1]);
            }
            ipv6Classifier.setSourcePrefixLen(prefLen);
        }
        if (qosIpv6Classifier.getDstIp6() != null) {
            parts = qosIpv6Classifier.getDstIp6().getValue().split("/");
            Ipv6AddressStr = parts[0];
            InetAddress dip6 = this.getByName(Ipv6AddressStr);
            if (dip6 != null) {
                ipv6Classifier.setDestinationIPAddress(dip6);
            }
            prefLen = -128;
            if (parts.length > 1) {
                prefLen = (byte)Integer.parseInt(parts[1]);
            }
            ipv6Classifier.setDestinationPrefixLen(prefLen);
        }
        short startPort = 0;
        short endPort = -1;
        if (qosIpv6Classifier.getSrcPortStart() != null) {
            endPort = startPort = qosIpv6Classifier.getSrcPortStart().getValue().shortValue();
            if (qosIpv6Classifier.getSrcPortEnd() != null) {
                endPort = qosIpv6Classifier.getSrcPortEnd().getValue().shortValue();
            }
            if (startPort > endPort) {
                this.logger.warn("Start port %d > End port %d in ipv6-classifier source port range -- forcing to same", (Object)startPort, (Object)endPort);
                endPort = startPort;
            }
        }
        ipv6Classifier.setSourcePortStart(startPort);
        ipv6Classifier.setSourcePortEnd(endPort);
        startPort = 0;
        endPort = -1;
        if (qosIpv6Classifier.getDstPortStart() != null) {
            endPort = startPort = qosIpv6Classifier.getDstPortStart().getValue().shortValue();
            if (qosIpv6Classifier.getDstPortEnd() != null) {
                endPort = qosIpv6Classifier.getDstPortEnd().getValue().shortValue();
            }
            if (startPort > endPort) {
                this.logger.warn("Start port %d > End port %d in ipv6-classifier destination port range -- forcing to same", (Object)startPort, (Object)endPort);
                endPort = startPort;
            }
        }
        ipv6Classifier.setDestinationPortStart(startPort);
        ipv6Classifier.setDestinationPortEnd(endPort);
        if (qosIpv6Classifier.getTcLow() != null) {
            ipv6Classifier.setTcLow(qosIpv6Classifier.getTcLow().getValue().byteValue());
            if (qosIpv6Classifier.getTcHigh() != null) {
                ipv6Classifier.setTcHigh(qosIpv6Classifier.getTcHigh().getValue().byteValue());
            }
            if (qosIpv6Classifier.getTcMask() != null) {
                ipv6Classifier.setTcMask(qosIpv6Classifier.getTcMask().getValue().byteValue());
            } else {
                ipv6Classifier.setTcMask((byte)-1);
            }
        } else {
            ipv6Classifier.setTcMask((byte)0);
        }
        this.gateReq.setClassifier((IClassifier)ipv6Classifier);
    }
}

