package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import java.util.List;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate
 *
 */
public class GateBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate> {

    private java.lang.String _ccapId;
    private java.lang.String _copsGateId;
    private java.lang.String _copsGateState;
    private java.lang.String _copsGateTimeInfo;
    private java.lang.String _copsGateUsageInfo;
    private List<java.lang.String> _error;
    private java.lang.String _gatePath;
    private DateAndTime _timestamp;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> augmentation = Collections.emptyMap();

    public GateBuilder() {
    }
    public GateBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes arg) {
        this._gatePath = arg.getGatePath();
        this._ccapId = arg.getCcapId();
        this._copsGateState = arg.getCopsGateState();
        this._copsGateTimeInfo = arg.getCopsGateTimeInfo();
        this._copsGateUsageInfo = arg.getCopsGateUsageInfo();
        this._copsGateId = arg.getCopsGateId();
        this._error = arg.getError();
        this._timestamp = arg.getTimestamp();
    }

    public GateBuilder(Gate base) {
        this._ccapId = base.getCcapId();
        this._copsGateId = base.getCopsGateId();
        this._copsGateState = base.getCopsGateState();
        this._copsGateTimeInfo = base.getCopsGateTimeInfo();
        this._copsGateUsageInfo = base.getCopsGateUsageInfo();
        this._error = base.getError();
        this._gatePath = base.getGatePath();
        this._timestamp = base.getTimestamp();
        if (base instanceof GateImpl) {
            GateImpl impl = (GateImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes) {
            this._gatePath = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getGatePath();
            this._ccapId = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getCcapId();
            this._copsGateState = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getCopsGateState();
            this._copsGateTimeInfo = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getCopsGateTimeInfo();
            this._copsGateUsageInfo = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getCopsGateUsageInfo();
            this._copsGateId = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getCopsGateId();
            this._error = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getError();
            this._timestamp = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes)arg).getTimestamp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes] \n" +
              "but was: " + arg
            );
        }
    }

    public java.lang.String getCcapId() {
        return _ccapId;
    }
    
    public java.lang.String getCopsGateId() {
        return _copsGateId;
    }
    
    public java.lang.String getCopsGateState() {
        return _copsGateState;
    }
    
    public java.lang.String getCopsGateTimeInfo() {
        return _copsGateTimeInfo;
    }
    
    public java.lang.String getCopsGateUsageInfo() {
        return _copsGateUsageInfo;
    }
    
    public List<java.lang.String> getError() {
        return _error;
    }
    
    public java.lang.String getGatePath() {
        return _gatePath;
    }
    
    public DateAndTime getTimestamp() {
        return _timestamp;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public GateBuilder setCcapId(final java.lang.String value) {
        this._ccapId = value;
        return this;
    }
    
     
    public GateBuilder setCopsGateId(final java.lang.String value) {
        this._copsGateId = value;
        return this;
    }
    
     
    public GateBuilder setCopsGateState(final java.lang.String value) {
        this._copsGateState = value;
        return this;
    }
    
     
    public GateBuilder setCopsGateTimeInfo(final java.lang.String value) {
        this._copsGateTimeInfo = value;
        return this;
    }
    
     
    public GateBuilder setCopsGateUsageInfo(final java.lang.String value) {
        this._copsGateUsageInfo = value;
        return this;
    }
    
     
    public GateBuilder setError(final List<java.lang.String> value) {
        this._error = value;
        return this;
    }
    
     
    public GateBuilder setGatePath(final java.lang.String value) {
        this._gatePath = value;
        return this;
    }
    
     
    public GateBuilder setTimestamp(final DateAndTime value) {
        this._timestamp = value;
        return this;
    }
    
    public GateBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public GateBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Gate build() {
        return new GateImpl(this);
    }

    private static final class GateImpl implements Gate {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate.class;
        }

        private final java.lang.String _ccapId;
        private final java.lang.String _copsGateId;
        private final java.lang.String _copsGateState;
        private final java.lang.String _copsGateTimeInfo;
        private final java.lang.String _copsGateUsageInfo;
        private final List<java.lang.String> _error;
        private final java.lang.String _gatePath;
        private final DateAndTime _timestamp;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> augmentation = Collections.emptyMap();

        private GateImpl(GateBuilder base) {
            this._ccapId = base.getCcapId();
            this._copsGateId = base.getCopsGateId();
            this._copsGateState = base.getCopsGateState();
            this._copsGateTimeInfo = base.getCopsGateTimeInfo();
            this._copsGateUsageInfo = base.getCopsGateUsageInfo();
            this._error = base.getError();
            this._gatePath = base.getGatePath();
            this._timestamp = base.getTimestamp();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.String getCcapId() {
            return _ccapId;
        }
        
        @Override
        public java.lang.String getCopsGateId() {
            return _copsGateId;
        }
        
        @Override
        public java.lang.String getCopsGateState() {
            return _copsGateState;
        }
        
        @Override
        public java.lang.String getCopsGateTimeInfo() {
            return _copsGateTimeInfo;
        }
        
        @Override
        public java.lang.String getCopsGateUsageInfo() {
            return _copsGateUsageInfo;
        }
        
        @Override
        public List<java.lang.String> getError() {
            return _error;
        }
        
        @Override
        public java.lang.String getGatePath() {
            return _gatePath;
        }
        
        @Override
        public DateAndTime getTimestamp() {
            return _timestamp;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ccapId);
            result = prime * result + Objects.hashCode(_copsGateId);
            result = prime * result + Objects.hashCode(_copsGateState);
            result = prime * result + Objects.hashCode(_copsGateTimeInfo);
            result = prime * result + Objects.hashCode(_copsGateUsageInfo);
            result = prime * result + Objects.hashCode(_error);
            result = prime * result + Objects.hashCode(_gatePath);
            result = prime * result + Objects.hashCode(_timestamp);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate)obj;
            if (!Objects.equals(_ccapId, other.getCcapId())) {
                return false;
            }
            if (!Objects.equals(_copsGateId, other.getCopsGateId())) {
                return false;
            }
            if (!Objects.equals(_copsGateState, other.getCopsGateState())) {
                return false;
            }
            if (!Objects.equals(_copsGateTimeInfo, other.getCopsGateTimeInfo())) {
                return false;
            }
            if (!Objects.equals(_copsGateUsageInfo, other.getCopsGateUsageInfo())) {
                return false;
            }
            if (!Objects.equals(_error, other.getError())) {
                return false;
            }
            if (!Objects.equals(_gatePath, other.getGatePath())) {
                return false;
            }
            if (!Objects.equals(_timestamp, other.getTimestamp())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GateImpl otherImpl = (GateImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Gate [");
            boolean first = true;
        
            if (_ccapId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccapId=");
                builder.append(_ccapId);
             }
            if (_copsGateId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_copsGateId=");
                builder.append(_copsGateId);
             }
            if (_copsGateState != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_copsGateState=");
                builder.append(_copsGateState);
             }
            if (_copsGateTimeInfo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_copsGateTimeInfo=");
                builder.append(_copsGateTimeInfo);
             }
            if (_copsGateUsageInfo != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_copsGateUsageInfo=");
                builder.append(_copsGateUsageInfo);
             }
            if (_error != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_error=");
                builder.append(_error);
             }
            if (_gatePath != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gatePath=");
                builder.append(_gatePath);
             }
            if (_timestamp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_timestamp=");
                builder.append(_timestamp);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
