package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.GateOperationalAttributes;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container gate {
 *     leaf gatePath {
 *         type string;
 *     }
 *     leaf ccapId {
 *         type string;
 *     }
 *     leaf cops-gate-state {
 *         type string;
 *     }
 *     leaf cops-gate-time-info {
 *         type string;
 *     }
 *     leaf cops-gate-usage-info {
 *         type string;
 *     }
 *     leaf cops-gateId {
 *         type string;
 *     }
 *     leaf-list error {
 *         type string;
 *     }
 *     leaf timestamp {
 *         type date-and-time;
 *     }
 *     uses gate-operational-attributes;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/qos-poll-gates/output/gate</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.GateBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.GateBuilder
 *
 */
public interface Gate
    extends
    ChildOf<QosPollGatesOutput>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate>,
    GateOperationalAttributes
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "gate").intern();


}

