package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.traffic.profile;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosTrafficProfile;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceClassName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container traffic-profile {
 *     leaf service-class-name {
 *         type service-class-name;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-traffic-profile/traffic-profile</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.traffic.profile.TrafficProfileBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.traffic.profile.TrafficProfileBuilder
 *
 */
public interface TrafficProfile
    extends
    ChildOf<PcmmQosTrafficProfile>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.traffic.profile.TrafficProfile>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "traffic-profile").intern();

    /**
     * The Service Class Name (SCN). This SCN must be pre-provisioned on the target 
     * CCAP
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceClassName</code> <code>serviceClassName</code>, or <code>null</code> if not present
     */
    ServiceClassName getServiceClassName();

}

