package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier
 *
 */
public class Ipv6ClassifierBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier> {

    private Ipv6Prefix _dstIp6;
    private PortNumber _dstPortEnd;
    private PortNumber _dstPortStart;
    private java.lang.Long _flowLabel;
    private TpProtocol _nextHdr;
    private Ipv6Prefix _srcIp6;
    private PortNumber _srcPortEnd;
    private PortNumber _srcPortStart;
    private TosByte _tcHigh;
    private TosByte _tcLow;
    private TosByte _tcMask;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentation = Collections.emptyMap();

    public Ipv6ClassifierBuilder() {
    }
    public Ipv6ClassifierBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges arg) {
        this._srcPortStart = arg.getSrcPortStart();
        this._srcPortEnd = arg.getSrcPortEnd();
        this._dstPortStart = arg.getDstPortStart();
        this._dstPortEnd = arg.getDstPortEnd();
    }

    public Ipv6ClassifierBuilder(Ipv6Classifier base) {
        this._dstIp6 = base.getDstIp6();
        this._dstPortEnd = base.getDstPortEnd();
        this._dstPortStart = base.getDstPortStart();
        this._flowLabel = base.getFlowLabel();
        this._nextHdr = base.getNextHdr();
        this._srcIp6 = base.getSrcIp6();
        this._srcPortEnd = base.getSrcPortEnd();
        this._srcPortStart = base.getSrcPortStart();
        this._tcHigh = base.getTcHigh();
        this._tcLow = base.getTcLow();
        this._tcMask = base.getTcMask();
        if (base instanceof Ipv6ClassifierImpl) {
            Ipv6ClassifierImpl impl = (Ipv6ClassifierImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges) {
            this._srcPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getSrcPortStart();
            this._srcPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getSrcPortEnd();
            this._dstPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getDstPortStart();
            this._dstPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getDstPortEnd();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges] \n" +
              "but was: " + arg
            );
        }
    }

    public Ipv6Prefix getDstIp6() {
        return _dstIp6;
    }
    
    public PortNumber getDstPortEnd() {
        return _dstPortEnd;
    }
    
    public PortNumber getDstPortStart() {
        return _dstPortStart;
    }
    
    public java.lang.Long getFlowLabel() {
        return _flowLabel;
    }
    
    public TpProtocol getNextHdr() {
        return _nextHdr;
    }
    
    public Ipv6Prefix getSrcIp6() {
        return _srcIp6;
    }
    
    public PortNumber getSrcPortEnd() {
        return _srcPortEnd;
    }
    
    public PortNumber getSrcPortStart() {
        return _srcPortStart;
    }
    
    public TosByte getTcHigh() {
        return _tcHigh;
    }
    
    public TosByte getTcLow() {
        return _tcLow;
    }
    
    public TosByte getTcMask() {
        return _tcMask;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public Ipv6ClassifierBuilder setDstIp6(final Ipv6Prefix value) {
        this._dstIp6 = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setDstPortEnd(final PortNumber value) {
        this._dstPortEnd = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setDstPortStart(final PortNumber value) {
        this._dstPortStart = value;
        return this;
    }
    
     
     private static void checkFlowLabelRange(final long value) {
         if (value >= 0L && value <= 1048575L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥1048575]].", value));
     }
    
    public Ipv6ClassifierBuilder setFlowLabel(final java.lang.Long value) {
    if (value != null) {
        checkFlowLabelRange(value);
    }
        this._flowLabel = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setNextHdr(final TpProtocol value) {
        this._nextHdr = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setSrcIp6(final Ipv6Prefix value) {
        this._srcIp6 = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setSrcPortEnd(final PortNumber value) {
        this._srcPortEnd = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setSrcPortStart(final PortNumber value) {
        this._srcPortStart = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setTcHigh(final TosByte value) {
        this._tcHigh = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setTcLow(final TosByte value) {
        this._tcLow = value;
        return this;
    }
    
     
    public Ipv6ClassifierBuilder setTcMask(final TosByte value) {
        this._tcMask = value;
        return this;
    }
    
    public Ipv6ClassifierBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public Ipv6ClassifierBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6Classifier build() {
        return new Ipv6ClassifierImpl(this);
    }

    private static final class Ipv6ClassifierImpl implements Ipv6Classifier {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier.class;
        }

        private final Ipv6Prefix _dstIp6;
        private final PortNumber _dstPortEnd;
        private final PortNumber _dstPortStart;
        private final java.lang.Long _flowLabel;
        private final TpProtocol _nextHdr;
        private final Ipv6Prefix _srcIp6;
        private final PortNumber _srcPortEnd;
        private final PortNumber _srcPortStart;
        private final TosByte _tcHigh;
        private final TosByte _tcLow;
        private final TosByte _tcMask;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentation = Collections.emptyMap();

        private Ipv6ClassifierImpl(Ipv6ClassifierBuilder base) {
            this._dstIp6 = base.getDstIp6();
            this._dstPortEnd = base.getDstPortEnd();
            this._dstPortStart = base.getDstPortStart();
            this._flowLabel = base.getFlowLabel();
            this._nextHdr = base.getNextHdr();
            this._srcIp6 = base.getSrcIp6();
            this._srcPortEnd = base.getSrcPortEnd();
            this._srcPortStart = base.getSrcPortStart();
            this._tcHigh = base.getTcHigh();
            this._tcLow = base.getTcLow();
            this._tcMask = base.getTcMask();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Ipv6Prefix getDstIp6() {
            return _dstIp6;
        }
        
        @Override
        public PortNumber getDstPortEnd() {
            return _dstPortEnd;
        }
        
        @Override
        public PortNumber getDstPortStart() {
            return _dstPortStart;
        }
        
        @Override
        public java.lang.Long getFlowLabel() {
            return _flowLabel;
        }
        
        @Override
        public TpProtocol getNextHdr() {
            return _nextHdr;
        }
        
        @Override
        public Ipv6Prefix getSrcIp6() {
            return _srcIp6;
        }
        
        @Override
        public PortNumber getSrcPortEnd() {
            return _srcPortEnd;
        }
        
        @Override
        public PortNumber getSrcPortStart() {
            return _srcPortStart;
        }
        
        @Override
        public TosByte getTcHigh() {
            return _tcHigh;
        }
        
        @Override
        public TosByte getTcLow() {
            return _tcLow;
        }
        
        @Override
        public TosByte getTcMask() {
            return _tcMask;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dstIp6);
            result = prime * result + Objects.hashCode(_dstPortEnd);
            result = prime * result + Objects.hashCode(_dstPortStart);
            result = prime * result + Objects.hashCode(_flowLabel);
            result = prime * result + Objects.hashCode(_nextHdr);
            result = prime * result + Objects.hashCode(_srcIp6);
            result = prime * result + Objects.hashCode(_srcPortEnd);
            result = prime * result + Objects.hashCode(_srcPortStart);
            result = prime * result + Objects.hashCode(_tcHigh);
            result = prime * result + Objects.hashCode(_tcLow);
            result = prime * result + Objects.hashCode(_tcMask);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier)obj;
            if (!Objects.equals(_dstIp6, other.getDstIp6())) {
                return false;
            }
            if (!Objects.equals(_dstPortEnd, other.getDstPortEnd())) {
                return false;
            }
            if (!Objects.equals(_dstPortStart, other.getDstPortStart())) {
                return false;
            }
            if (!Objects.equals(_flowLabel, other.getFlowLabel())) {
                return false;
            }
            if (!Objects.equals(_nextHdr, other.getNextHdr())) {
                return false;
            }
            if (!Objects.equals(_srcIp6, other.getSrcIp6())) {
                return false;
            }
            if (!Objects.equals(_srcPortEnd, other.getSrcPortEnd())) {
                return false;
            }
            if (!Objects.equals(_srcPortStart, other.getSrcPortStart())) {
                return false;
            }
            if (!Objects.equals(_tcHigh, other.getTcHigh())) {
                return false;
            }
            if (!Objects.equals(_tcLow, other.getTcLow())) {
                return false;
            }
            if (!Objects.equals(_tcMask, other.getTcMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                Ipv6ClassifierImpl otherImpl = (Ipv6ClassifierImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Ipv6Classifier [");
            boolean first = true;
        
            if (_dstIp6 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp6=");
                builder.append(_dstIp6);
             }
            if (_dstPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortEnd=");
                builder.append(_dstPortEnd);
             }
            if (_dstPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortStart=");
                builder.append(_dstPortStart);
             }
            if (_flowLabel != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowLabel=");
                builder.append(_flowLabel);
             }
            if (_nextHdr != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nextHdr=");
                builder.append(_nextHdr);
             }
            if (_srcIp6 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp6=");
                builder.append(_srcIp6);
             }
            if (_srcPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortEnd=");
                builder.append(_srcPortEnd);
             }
            if (_srcPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortStart=");
                builder.append(_srcPortStart);
             }
            if (_tcHigh != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcHigh=");
                builder.append(_tcHigh);
             }
            if (_tcLow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcLow=");
                builder.append(_tcLow);
             }
            if (_tcMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcMask=");
                builder.append(_tcMask);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
