package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosIpv6Classifier;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container ipv6-classifier {
 *     leaf srcIp6 {
 *         type ipv6-prefix;
 *     }
 *     leaf dstIp6 {
 *         type ipv6-prefix;
 *     }
 *     leaf tc-low {
 *         type tos-byte;
 *     }
 *     leaf tc-high {
 *         type tos-byte;
 *     }
 *     leaf tc-mask {
 *         type tos-byte;
 *     }
 *     leaf next-hdr {
 *         type tp-protocol;
 *     }
 *     leaf flow-label {
 *         type uint32;
 *     }
 *     leaf srcPort-start {
 *         type port-number;
 *     }
 *     leaf srcPort-end {
 *         type port-number;
 *     }
 *     leaf dstPort-start {
 *         type port-number;
 *     }
 *     leaf dstPort-end {
 *         type port-number;
 *     }
 *     uses tp-port-match-ranges;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-ipv6-classifier/ipv6-classifier</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6ClassifierBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6ClassifierBuilder
 *
 */
public interface Ipv6Classifier
    extends
    ChildOf<PcmmQosIpv6Classifier>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier>,
    TpPortMatchRanges
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ipv6-classifier").intern();

    /**
     * Source IPv6 prefix match in 'address/len' notation
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix</code> <code>srcIp6</code>, or <code>null</code> if not present
     */
    Ipv6Prefix getSrcIp6();
    
    /**
     * Destination IPv6 prefix match in 'address/len' notation
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix</code> <code>dstIp6</code>, or <code>null</code> if not present
     */
    Ipv6Prefix getDstIp6();
    
    /**
     * TC low range match
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>tcLow</code>, or <code>null</code> if not present
     */
    TosByte getTcLow();
    
    /**
     * TC high range match
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>tcHigh</code>, or <code>null</code> if not present
     */
    TosByte getTcHigh();
    
    /**
     * TC mask
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>tcMask</code>, or <code>null</code> if not present
     */
    TosByte getTcMask();
    
    /**
     * IPv6 Next Header
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol</code> <code>nextHdr</code>, or <code>null</code> if not present
     */
    TpProtocol getNextHdr();
    
    /**
     * IPv6 Flow Label (20 bits)
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>flowLabel</code>, or <code>null</code> if not present
     */
    java.lang.Long getFlowLabel();

}

