package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gate.spec;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosGateSpec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceFlowDirection;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container gate-spec {
 *     leaf direction {
 *         type service-flow-direction;
 *     }
 *     leaf dscp-tos-overwrite {
 *         type tos-byte;
 *     }
 *     leaf dscp-tos-mask {
 *         type tos-byte;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-gate-spec/gate-spec</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gate.spec.GateSpecBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gate.spec.GateSpecBuilder
 *
 */
public interface GateSpec
    extends
    ChildOf<PcmmQosGateSpec>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gate.spec.GateSpec>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "gate-spec").intern();

    /**
     * Gate Direction (ignored for traffic profile SCN)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceFlowDirection</code> <code>direction</code>, or <code>null</code> if not present
     */
    ServiceFlowDirection getDirection();
    
    /**
     * Optional DSCP/TOS overwrite value
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>dscpTosOverwrite</code>, or <code>null</code> if not present
     */
    TosByte getDscpTosOverwrite();
    
    /**
     * Optional DSCP/TOS overwrite AND mask
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>dscpTosMask</code>, or <code>null</code> if not present
     */
    TosByte getDscpTosMask();

}

