package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier
 *
 */
public class ExtClassifierBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier> {

    private Ipv4Address _dstIp;
    private Ipv4Address _dstIpMask;
    private PortNumber _dstPortEnd;
    private PortNumber _dstPortStart;
    private TpProtocol _protocol;
    private Ipv4Address _srcIp;
    private Ipv4Address _srcIpMask;
    private PortNumber _srcPortEnd;
    private PortNumber _srcPortStart;
    private TosByte _tosByte;
    private TosByte _tosMask;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> augmentation = Collections.emptyMap();

    public ExtClassifierBuilder() {
    }
    public ExtClassifierBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges arg) {
        this._srcPortStart = arg.getSrcPortStart();
        this._srcPortEnd = arg.getSrcPortEnd();
        this._dstPortStart = arg.getDstPortStart();
        this._dstPortEnd = arg.getDstPortEnd();
    }

    public ExtClassifierBuilder(ExtClassifier base) {
        this._dstIp = base.getDstIp();
        this._dstIpMask = base.getDstIpMask();
        this._dstPortEnd = base.getDstPortEnd();
        this._dstPortStart = base.getDstPortStart();
        this._protocol = base.getProtocol();
        this._srcIp = base.getSrcIp();
        this._srcIpMask = base.getSrcIpMask();
        this._srcPortEnd = base.getSrcPortEnd();
        this._srcPortStart = base.getSrcPortStart();
        this._tosByte = base.getTosByte();
        this._tosMask = base.getTosMask();
        if (base instanceof ExtClassifierImpl) {
            ExtClassifierImpl impl = (ExtClassifierImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges) {
            this._srcPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getSrcPortStart();
            this._srcPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getSrcPortEnd();
            this._dstPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getDstPortStart();
            this._dstPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges)arg).getDstPortEnd();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges] \n" +
              "but was: " + arg
            );
        }
    }

    public Ipv4Address getDstIp() {
        return _dstIp;
    }
    
    public Ipv4Address getDstIpMask() {
        return _dstIpMask;
    }
    
    public PortNumber getDstPortEnd() {
        return _dstPortEnd;
    }
    
    public PortNumber getDstPortStart() {
        return _dstPortStart;
    }
    
    public TpProtocol getProtocol() {
        return _protocol;
    }
    
    public Ipv4Address getSrcIp() {
        return _srcIp;
    }
    
    public Ipv4Address getSrcIpMask() {
        return _srcIpMask;
    }
    
    public PortNumber getSrcPortEnd() {
        return _srcPortEnd;
    }
    
    public PortNumber getSrcPortStart() {
        return _srcPortStart;
    }
    
    public TosByte getTosByte() {
        return _tosByte;
    }
    
    public TosByte getTosMask() {
        return _tosMask;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ExtClassifierBuilder setDstIp(final Ipv4Address value) {
        this._dstIp = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setDstIpMask(final Ipv4Address value) {
        this._dstIpMask = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setDstPortEnd(final PortNumber value) {
        this._dstPortEnd = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setDstPortStart(final PortNumber value) {
        this._dstPortStart = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setProtocol(final TpProtocol value) {
        this._protocol = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setSrcIp(final Ipv4Address value) {
        this._srcIp = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setSrcIpMask(final Ipv4Address value) {
        this._srcIpMask = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setSrcPortEnd(final PortNumber value) {
        this._srcPortEnd = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setSrcPortStart(final PortNumber value) {
        this._srcPortStart = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setTosByte(final TosByte value) {
        this._tosByte = value;
        return this;
    }
    
     
    public ExtClassifierBuilder setTosMask(final TosByte value) {
        this._tosMask = value;
        return this;
    }
    
    public ExtClassifierBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ExtClassifierBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ExtClassifier build() {
        return new ExtClassifierImpl(this);
    }

    private static final class ExtClassifierImpl implements ExtClassifier {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier.class;
        }

        private final Ipv4Address _dstIp;
        private final Ipv4Address _dstIpMask;
        private final PortNumber _dstPortEnd;
        private final PortNumber _dstPortStart;
        private final TpProtocol _protocol;
        private final Ipv4Address _srcIp;
        private final Ipv4Address _srcIpMask;
        private final PortNumber _srcPortEnd;
        private final PortNumber _srcPortStart;
        private final TosByte _tosByte;
        private final TosByte _tosMask;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> augmentation = Collections.emptyMap();

        private ExtClassifierImpl(ExtClassifierBuilder base) {
            this._dstIp = base.getDstIp();
            this._dstIpMask = base.getDstIpMask();
            this._dstPortEnd = base.getDstPortEnd();
            this._dstPortStart = base.getDstPortStart();
            this._protocol = base.getProtocol();
            this._srcIp = base.getSrcIp();
            this._srcIpMask = base.getSrcIpMask();
            this._srcPortEnd = base.getSrcPortEnd();
            this._srcPortStart = base.getSrcPortStart();
            this._tosByte = base.getTosByte();
            this._tosMask = base.getTosMask();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Ipv4Address getDstIp() {
            return _dstIp;
        }
        
        @Override
        public Ipv4Address getDstIpMask() {
            return _dstIpMask;
        }
        
        @Override
        public PortNumber getDstPortEnd() {
            return _dstPortEnd;
        }
        
        @Override
        public PortNumber getDstPortStart() {
            return _dstPortStart;
        }
        
        @Override
        public TpProtocol getProtocol() {
            return _protocol;
        }
        
        @Override
        public Ipv4Address getSrcIp() {
            return _srcIp;
        }
        
        @Override
        public Ipv4Address getSrcIpMask() {
            return _srcIpMask;
        }
        
        @Override
        public PortNumber getSrcPortEnd() {
            return _srcPortEnd;
        }
        
        @Override
        public PortNumber getSrcPortStart() {
            return _srcPortStart;
        }
        
        @Override
        public TosByte getTosByte() {
            return _tosByte;
        }
        
        @Override
        public TosByte getTosMask() {
            return _tosMask;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dstIp);
            result = prime * result + Objects.hashCode(_dstIpMask);
            result = prime * result + Objects.hashCode(_dstPortEnd);
            result = prime * result + Objects.hashCode(_dstPortStart);
            result = prime * result + Objects.hashCode(_protocol);
            result = prime * result + Objects.hashCode(_srcIp);
            result = prime * result + Objects.hashCode(_srcIpMask);
            result = prime * result + Objects.hashCode(_srcPortEnd);
            result = prime * result + Objects.hashCode(_srcPortStart);
            result = prime * result + Objects.hashCode(_tosByte);
            result = prime * result + Objects.hashCode(_tosMask);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier)obj;
            if (!Objects.equals(_dstIp, other.getDstIp())) {
                return false;
            }
            if (!Objects.equals(_dstIpMask, other.getDstIpMask())) {
                return false;
            }
            if (!Objects.equals(_dstPortEnd, other.getDstPortEnd())) {
                return false;
            }
            if (!Objects.equals(_dstPortStart, other.getDstPortStart())) {
                return false;
            }
            if (!Objects.equals(_protocol, other.getProtocol())) {
                return false;
            }
            if (!Objects.equals(_srcIp, other.getSrcIp())) {
                return false;
            }
            if (!Objects.equals(_srcIpMask, other.getSrcIpMask())) {
                return false;
            }
            if (!Objects.equals(_srcPortEnd, other.getSrcPortEnd())) {
                return false;
            }
            if (!Objects.equals(_srcPortStart, other.getSrcPortStart())) {
                return false;
            }
            if (!Objects.equals(_tosByte, other.getTosByte())) {
                return false;
            }
            if (!Objects.equals(_tosMask, other.getTosMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ExtClassifierImpl otherImpl = (ExtClassifierImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("ExtClassifier [");
            boolean first = true;
        
            if (_dstIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp=");
                builder.append(_dstIp);
             }
            if (_dstIpMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIpMask=");
                builder.append(_dstIpMask);
             }
            if (_dstPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortEnd=");
                builder.append(_dstPortEnd);
             }
            if (_dstPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortStart=");
                builder.append(_dstPortStart);
             }
            if (_protocol != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocol=");
                builder.append(_protocol);
             }
            if (_srcIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp=");
                builder.append(_srcIp);
             }
            if (_srcIpMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIpMask=");
                builder.append(_srcIpMask);
             }
            if (_srcPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortEnd=");
                builder.append(_srcPortEnd);
             }
            if (_srcPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortStart=");
                builder.append(_srcPortStart);
             }
            if (_tosByte != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosByte=");
                builder.append(_tosByte);
             }
            if (_tosMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosMask=");
                builder.append(_tosMask);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
