package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosExtClassifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpPortMatchRanges;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container ext-classifier {
 *     leaf srcIp {
 *         type ipv4-address;
 *     }
 *     leaf srcIpMask {
 *         type ipv4-address;
 *     }
 *     leaf dstIp {
 *         type ipv4-address;
 *     }
 *     leaf dstIpMask {
 *         type ipv4-address;
 *     }
 *     leaf tos-byte {
 *         type tos-byte;
 *     }
 *     leaf tos-mask {
 *         type tos-byte;
 *     }
 *     leaf protocol {
 *         type tp-protocol;
 *     }
 *     leaf srcPort-start {
 *         type port-number;
 *     }
 *     leaf srcPort-end {
 *         type port-number;
 *     }
 *     leaf dstPort-start {
 *         type port-number;
 *     }
 *     leaf dstPort-end {
 *         type port-number;
 *     }
 *     uses tp-port-match-ranges;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-ext-classifier/ext-classifier</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifierBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifierBuilder
 *
 */
public interface ExtClassifier
    extends
    ChildOf<PcmmQosExtClassifier>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier>,
    TpPortMatchRanges
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ext-classifier").intern();

    /**
     * Source IPv4 address match
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address</code> <code>srcIp</code>, or <code>null</code> if not present
     */
    Ipv4Address getSrcIp();
    
    /**
     * Source IPv4 mask
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address</code> <code>srcIpMask</code>, or <code>null</code> if not present
     */
    Ipv4Address getSrcIpMask();
    
    /**
     * Destination IPv4 address match
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address</code> <code>dstIp</code>, or <code>null</code> if not present
     */
    Ipv4Address getDstIp();
    
    /**
     * Destination IPv4 mask
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address</code> <code>dstIpMask</code>, or <code>null</code> if not present
     */
    Ipv4Address getDstIpMask();
    
    /**
     * TOS/DSCP match
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>tosByte</code>, or <code>null</code> if not present
     */
    TosByte getTosByte();
    
    /**
     * TOS/DSCP mask
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>tosMask</code>, or <code>null</code> if not present
     */
    TosByte getTosMask();
    
    /**
     * IPv4 transport protocol
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol</code> <code>protocol</code>, or <code>null</code> if not present
     */
    TpProtocol getProtocol();

}

