package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier
 *
 */
public class ClassifierBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier> {

    private Ipv4Address _dstIp;
    private PortNumber _dstPort;
    private TpProtocol _protocol;
    private Ipv4Address _srcIp;
    private PortNumber _srcPort;
    private TosByte _tosByte;
    private TosByte _tosMask;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> augmentation = Collections.emptyMap();

    public ClassifierBuilder() {
    }

    public ClassifierBuilder(Classifier base) {
        this._dstIp = base.getDstIp();
        this._dstPort = base.getDstPort();
        this._protocol = base.getProtocol();
        this._srcIp = base.getSrcIp();
        this._srcPort = base.getSrcPort();
        this._tosByte = base.getTosByte();
        this._tosMask = base.getTosMask();
        if (base instanceof ClassifierImpl) {
            ClassifierImpl impl = (ClassifierImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Ipv4Address getDstIp() {
        return _dstIp;
    }
    
    public PortNumber getDstPort() {
        return _dstPort;
    }
    
    public TpProtocol getProtocol() {
        return _protocol;
    }
    
    public Ipv4Address getSrcIp() {
        return _srcIp;
    }
    
    public PortNumber getSrcPort() {
        return _srcPort;
    }
    
    public TosByte getTosByte() {
        return _tosByte;
    }
    
    public TosByte getTosMask() {
        return _tosMask;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ClassifierBuilder setDstIp(final Ipv4Address value) {
        this._dstIp = value;
        return this;
    }
    
     
    public ClassifierBuilder setDstPort(final PortNumber value) {
        this._dstPort = value;
        return this;
    }
    
     
    public ClassifierBuilder setProtocol(final TpProtocol value) {
        this._protocol = value;
        return this;
    }
    
     
    public ClassifierBuilder setSrcIp(final Ipv4Address value) {
        this._srcIp = value;
        return this;
    }
    
     
    public ClassifierBuilder setSrcPort(final PortNumber value) {
        this._srcPort = value;
        return this;
    }
    
     
    public ClassifierBuilder setTosByte(final TosByte value) {
        this._tosByte = value;
        return this;
    }
    
     
    public ClassifierBuilder setTosMask(final TosByte value) {
        this._tosMask = value;
        return this;
    }
    
    public ClassifierBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ClassifierBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Classifier build() {
        return new ClassifierImpl(this);
    }

    private static final class ClassifierImpl implements Classifier {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier.class;
        }

        private final Ipv4Address _dstIp;
        private final PortNumber _dstPort;
        private final TpProtocol _protocol;
        private final Ipv4Address _srcIp;
        private final PortNumber _srcPort;
        private final TosByte _tosByte;
        private final TosByte _tosMask;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> augmentation = Collections.emptyMap();

        private ClassifierImpl(ClassifierBuilder base) {
            this._dstIp = base.getDstIp();
            this._dstPort = base.getDstPort();
            this._protocol = base.getProtocol();
            this._srcIp = base.getSrcIp();
            this._srcPort = base.getSrcPort();
            this._tosByte = base.getTosByte();
            this._tosMask = base.getTosMask();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Ipv4Address getDstIp() {
            return _dstIp;
        }
        
        @Override
        public PortNumber getDstPort() {
            return _dstPort;
        }
        
        @Override
        public TpProtocol getProtocol() {
            return _protocol;
        }
        
        @Override
        public Ipv4Address getSrcIp() {
            return _srcIp;
        }
        
        @Override
        public PortNumber getSrcPort() {
            return _srcPort;
        }
        
        @Override
        public TosByte getTosByte() {
            return _tosByte;
        }
        
        @Override
        public TosByte getTosMask() {
            return _tosMask;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dstIp);
            result = prime * result + Objects.hashCode(_dstPort);
            result = prime * result + Objects.hashCode(_protocol);
            result = prime * result + Objects.hashCode(_srcIp);
            result = prime * result + Objects.hashCode(_srcPort);
            result = prime * result + Objects.hashCode(_tosByte);
            result = prime * result + Objects.hashCode(_tosMask);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier)obj;
            if (!Objects.equals(_dstIp, other.getDstIp())) {
                return false;
            }
            if (!Objects.equals(_dstPort, other.getDstPort())) {
                return false;
            }
            if (!Objects.equals(_protocol, other.getProtocol())) {
                return false;
            }
            if (!Objects.equals(_srcIp, other.getSrcIp())) {
                return false;
            }
            if (!Objects.equals(_srcPort, other.getSrcPort())) {
                return false;
            }
            if (!Objects.equals(_tosByte, other.getTosByte())) {
                return false;
            }
            if (!Objects.equals(_tosMask, other.getTosMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ClassifierImpl otherImpl = (ClassifierImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Classifier [");
            boolean first = true;
        
            if (_dstIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp=");
                builder.append(_dstIp);
             }
            if (_dstPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPort=");
                builder.append(_dstPort);
             }
            if (_protocol != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocol=");
                builder.append(_protocol);
             }
            if (_srcIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp=");
                builder.append(_srcIp);
             }
            if (_srcPort != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPort=");
                builder.append(_srcPort);
             }
            if (_tosByte != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosByte=");
                builder.append(_tosByte);
             }
            if (_tosMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosMask=");
                builder.append(_tosMask);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
