package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosClassifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container classifier {
 *     leaf srcIp {
 *         type ipv4-address;
 *     }
 *     leaf dstIp {
 *         type ipv4-address;
 *     }
 *     leaf tos-byte {
 *         type tos-byte;
 *     }
 *     leaf tos-mask {
 *         type tos-byte;
 *     }
 *     leaf protocol {
 *         type tp-protocol;
 *     }
 *     leaf srcPort {
 *         type port-number;
 *     }
 *     leaf dstPort {
 *         type port-number;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-classifier/classifier</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.ClassifierBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.ClassifierBuilder
 *
 */
public interface Classifier
    extends
    ChildOf<PcmmQosClassifier>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "classifier").intern();

    /**
     * Source IPv4 address (exact match)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address</code> <code>srcIp</code>, or <code>null</code> if not present
     */
    Ipv4Address getSrcIp();
    
    /**
     * Destination IPv4 address (exact match)
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address</code> <code>dstIp</code>, or <code>null</code> if not present
     */
    Ipv4Address getDstIp();
    
    /**
     * TOS/DSCP match
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>tosByte</code>, or <code>null</code> if not present
     */
    TosByte getTosByte();
    
    /**
     * TOS/DSCP mask
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TosByte</code> <code>tosMask</code>, or <code>null</code> if not present
     */
    TosByte getTosMask();
    
    /**
     * IPv4 transport protocol
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.TpProtocol</code> <code>protocol</code>, or <code>null</code> if not present
     */
    TpProtocol getProtocol();
    
    /**
     * TCP/UDP source port (exact match).
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>srcPort</code>, or <code>null</code> if not present
     */
    PortNumber getSrcPort();
    
    /**
     * TCP/UDP destination port (exact match).
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>dstPort</code>, or <code>null</code> if not present
     */
    PortNumber getDstPort();

}

