package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.ClassifierChoice;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosClassifier;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * case qos-classifier-choice {
 *     container classifier {
 *         leaf srcIp {
 *             type ipv4-address;
 *         }
 *         leaf dstIp {
 *             type ipv4-address;
 *         }
 *         leaf tos-byte {
 *             type tos-byte;
 *         }
 *         leaf tos-mask {
 *             type tos-byte;
 *         }
 *         leaf protocol {
 *             type tp-protocol;
 *         }
 *         leaf srcPort {
 *             type port-number;
 *         }
 *         leaf dstPort {
 *             type port-number;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/classifier-attributes/classifiers/classifier-container/classifier-choice/qos-classifier-choice</i>
 *
 */
public interface QosClassifierChoice
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice.QosClassifierChoice>,
    PcmmQosClassifier,
    ClassifierChoice
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "qos-classifier-choice").intern();


}

