package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.ClassifierChoice;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosIpv6Classifier;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * case ipv6-classifier-choice {
 *     container ipv6-classifier {
 *         leaf srcIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf dstIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf tc-low {
 *             type tos-byte;
 *         }
 *         leaf tc-high {
 *             type tos-byte;
 *         }
 *         leaf tc-mask {
 *             type tos-byte;
 *         }
 *         leaf next-hdr {
 *             type tp-protocol;
 *         }
 *         leaf flow-label {
 *             type uint32;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/classifier-attributes/classifiers/classifier-container/classifier-choice/ipv6-classifier-choice</i>
 *
 */
public interface Ipv6ClassifierChoice
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice.Ipv6ClassifierChoice>,
    PcmmQosIpv6Classifier,
    ClassifierChoice
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ipv6-classifier-choice").intern();


}

