package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.ClassifierChoice;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosExtClassifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * case ext-classifier-choice {
 *     container ext-classifier {
 *         leaf srcIp {
 *             type ipv4-address;
 *         }
 *         leaf srcIpMask {
 *             type ipv4-address;
 *         }
 *         leaf dstIp {
 *             type ipv4-address;
 *         }
 *         leaf dstIpMask {
 *             type ipv4-address;
 *         }
 *         leaf tos-byte {
 *             type tos-byte;
 *         }
 *         leaf tos-mask {
 *             type tos-byte;
 *         }
 *         leaf protocol {
 *             type tp-protocol;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/classifier-attributes/classifiers/classifier-container/classifier-choice/ext-classifier-choice</i>
 *
 */
public interface ExtClassifierChoice
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.classifier.container.classifier.choice.ExtClassifierChoice>,
    PcmmQosExtClassifier,
    ClassifierChoice
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ext-classifier-choice").intern();


}

