package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers;
import org.opendaylight.yangtools.yang.binding.Identifier;
import java.util.Objects;


public class ClassifierContainerKey
 implements Identifier<ClassifierContainer> {
    private static final long serialVersionUID = -1741081298034234613L;
    private final java.lang.Short _classifierId;


    public ClassifierContainerKey(java.lang.Short _classifierId) {
    
    
        this._classifierId = _classifierId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ClassifierContainerKey(ClassifierContainerKey source) {
        this._classifierId = source._classifierId;
    }


    public java.lang.Short getClassifierId() {
        return _classifierId;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_classifierId);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        ClassifierContainerKey other = (ClassifierContainerKey) obj;
        if (!Objects.equals(_classifierId, other._classifierId)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.ClassifierContainerKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_classifierId != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_classifierId=");
            builder.append(_classifierId);
         }
        return builder.append(']').toString();
    }
}

