package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.ClassifierContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.List;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers
 *
 */
public class ClassifiersBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers> {

    private List<ClassifierContainer> _classifierContainer;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> augmentation = Collections.emptyMap();

    public ClassifiersBuilder() {
    }

    public ClassifiersBuilder(Classifiers base) {
        this._classifierContainer = base.getClassifierContainer();
        if (base instanceof ClassifiersImpl) {
            ClassifiersImpl impl = (ClassifiersImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public List<ClassifierContainer> getClassifierContainer() {
        return _classifierContainer;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ClassifiersBuilder setClassifierContainer(final List<ClassifierContainer> value) {
        this._classifierContainer = value;
        return this;
    }
    
    public ClassifiersBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ClassifiersBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Classifiers build() {
        return new ClassifiersImpl(this);
    }

    private static final class ClassifiersImpl implements Classifiers {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers.class;
        }

        private final List<ClassifierContainer> _classifierContainer;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> augmentation = Collections.emptyMap();

        private ClassifiersImpl(ClassifiersBuilder base) {
            this._classifierContainer = base.getClassifierContainer();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public List<ClassifierContainer> getClassifierContainer() {
            return _classifierContainer;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_classifierContainer);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers)obj;
            if (!Objects.equals(_classifierContainer, other.getClassifierContainer())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ClassifiersImpl otherImpl = (ClassifiersImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Classifiers [");
            boolean first = true;
        
            if (_classifierContainer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classifierContainer=");
                builder.append(_classifierContainer);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
