package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.classifiers.ClassifierContainer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ClassifierAttributes;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container classifiers {
 *     list classifier-container {
 *         key "classifier-id"
 *         leaf classifier-id {
 *             type uint8;
 *         }
 *         choice classifier-choice {
 *             case ext-classifier-choice {
 *                 container ext-classifier {
 *                     leaf srcIp {
 *                         type ipv4-address;
 *                     }
 *                     leaf srcIpMask {
 *                         type ipv4-address;
 *                     }
 *                     leaf dstIp {
 *                         type ipv4-address;
 *                     }
 *                     leaf dstIpMask {
 *                         type ipv4-address;
 *                     }
 *                     leaf tos-byte {
 *                         type tos-byte;
 *                     }
 *                     leaf tos-mask {
 *                         type tos-byte;
 *                     }
 *                     leaf protocol {
 *                         type tp-protocol;
 *                     }
 *                     leaf srcPort-start {
 *                         type port-number;
 *                     }
 *                     leaf srcPort-end {
 *                         type port-number;
 *                     }
 *                     leaf dstPort-start {
 *                         type port-number;
 *                     }
 *                     leaf dstPort-end {
 *                         type port-number;
 *                     }
 *                     uses tp-port-match-ranges;
 *                 }
 *             }
 *             case ipv6-classifier-choice {
 *                 container ipv6-classifier {
 *                     leaf srcIp6 {
 *                         type ipv6-prefix;
 *                     }
 *                     leaf dstIp6 {
 *                         type ipv6-prefix;
 *                     }
 *                     leaf tc-low {
 *                         type tos-byte;
 *                     }
 *                     leaf tc-high {
 *                         type tos-byte;
 *                     }
 *                     leaf tc-mask {
 *                         type tos-byte;
 *                     }
 *                     leaf next-hdr {
 *                         type tp-protocol;
 *                     }
 *                     leaf flow-label {
 *                         type uint32;
 *                     }
 *                     leaf srcPort-start {
 *                         type port-number;
 *                     }
 *                     leaf srcPort-end {
 *                         type port-number;
 *                     }
 *                     leaf dstPort-start {
 *                         type port-number;
 *                     }
 *                     leaf dstPort-end {
 *                         type port-number;
 *                     }
 *                     uses tp-port-match-ranges;
 *                 }
 *             }
 *             case qos-classifier-choice {
 *                 container classifier {
 *                     leaf srcIp {
 *                         type ipv4-address;
 *                     }
 *                     leaf dstIp {
 *                         type ipv4-address;
 *                     }
 *                     leaf tos-byte {
 *                         type tos-byte;
 *                     }
 *                     leaf tos-mask {
 *                         type tos-byte;
 *                     }
 *                     leaf protocol {
 *                         type tp-protocol;
 *                     }
 *                     leaf srcPort {
 *                         type port-number;
 *                     }
 *                     leaf dstPort {
 *                         type port-number;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/classifier-attributes/classifiers</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.ClassifiersBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.ClassifiersBuilder
 *
 */
public interface Classifiers
    extends
    ChildOf<ClassifierAttributes>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.classifier.attributes.Classifiers>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "classifiers").intern();

    /**
     * @return <code>java.util.List</code> <code>classifierContainer</code>, or <code>null</code> if not present
     */
    List<ClassifierContainer> getClassifierContainer();

}

