package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps;
import org.opendaylight.yangtools.yang.binding.Identifier;
import java.util.Objects;


public class CcapKey
 implements Identifier<Ccap> {
    private static final long serialVersionUID = 8299349459314248956L;
    private final java.lang.String _ccapId;


    public CcapKey(java.lang.String _ccapId) {
    
    
        this._ccapId = _ccapId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public CcapKey(CcapKey source) {
        this._ccapId = source._ccapId;
    }


    public java.lang.String getCcapId() {
        return _ccapId;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_ccapId);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        CcapKey other = (CcapKey) obj;
        if (!Objects.equals(_ccapId, other._ccapId)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.CcapKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_ccapId != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_ccapId=");
            builder.append(_ccapId);
         }
        return builder.append(']').toString();
    }
}

